/**
 * @version June, 14 2002
 * @author  Sergei Troitsky
 */

var gMenu = null;

function CreateMenu(win) {
    gMenu = new CMenu(win);
}

function CMenu(win) {
    this.tm = new TreeMenu("parent.gMenu.tm", win, win.parent, 7*24*60*60*1000);

    this.tm.checkMenu           = "if(parent.gMenu == null || typeof(parent.gMenu) != 'object') {\n"
                                + "  parent.location.reload();\n"
                                + "} else\n";
    this.tm.itemHeight          = 0;
    this.tm.tabWidth            = 9;
    this.tm.buttonWidth         = 11;
    this.tm.spaceTabButton      = 3;
    this.tm.spaceButtonImage    = 3;
    this.tm.spaceImageLink      = 3;
    this.tm.spaceSelimageLink   = 3;
    this.tm.img1x1         .src = "../../images/1x1.gif";
    this.tm.imgButtonOpened.src = "../../images/arrow_open.gif";
    this.tm.imgButtonClosed.src = "../../images/arrow_closed.gif";
    this.tm.imgSelectedYes .src = "../../images/select.gif";
    this.tm.imgSelectedNo  .src = "../../images/nselect.gif";
    this.tm.imgItem        .src = "../../images/page.gif";
    this.tm.imgItemOpened  .src = "../../images/open_book.gif";
    this.tm.imgItemClosed  .src = "../../images/closed_book.gif";
    this.tm.bgcolors[0]         = new TreeMenuBgcolor("#cccbbc", "#f5f4e2", "#9c9b8f");
    this.tm.bgcolors[1]         = new TreeMenuBgcolor("#e1e0cf", "#fefeee", "#aeada0");
    this.tm.bgcolors[2]         = new TreeMenuBgcolor("#f5f4e2", "#ffffff", "#c2c1b2");
    this.tm.bgcolors[3]         = new TreeMenuBgcolor("#fefeee", "#cccbbc", "#cccbbc");
    this.tm.bgcolorMarked       = "#ffcc33";
    this.tm.stsTreeNode         = "Node";
    this.tm.stsDocument         = "Document";
    this.tm.stsExpand           = "Click Here To Expand the Subtree";
    this.tm.stsCollapse         = "Click Here To Compress the Subtree";
    this.tm.a11y                = true;
    this.tm.a11yEnter           = "Entering navigation tree";
    this.tm.a11yLeave           = "Leaving navigation tree";
    this.tm.a11yLevel           = "Level";
    this.tm.a11yExpanded        = "Expanded";
    this.tm.a11ySelected        = "Selected";
    this.tm.itemGo              = PH_itemGo;

    this.stsStructLink          = "Structure link";
    this.imgItemStructLink      = new Image();
    this.imgItemStructLink.src  = "../../images/change_book.gif";

    this.Initialize             = CMenu_Initialize;
    this.IsInitialized          = CMenu_IsInitialized;
    this.Add                    = CMenu_Add;
    this.SetLayout              = CMenu_SetLayout;
    this.SetImagePath           = CMenu_SetImagePath;
    this.SetStyleSheet          = CMenu_SetStyleSheet;
    this.SetCodePage            = CMenu_SetCodePage;
    this.SetLevel2Item          = CMenu_SetLevel2Item;
    this.SetTitle               = CMenu_SetTitle;
    this.GenerateTree           = CMenu_GenerateTree;
    this.SelectEntry            = CMenu_SelectEntry;
    this.Explode                = CMenu_Explode;
    this.Contract               = CMenu_Contract;
    this.PrevEntry              = CMenu_PrevEntry;
    this.NextEntry              = CMenu_NextEntry;
    this.Sync                   = CMenu_Sync;
}

function CMenu_Initialize   (          ) {                                  }
function CMenu_IsInitialized(          ) { return this.tm.generated();      }
function CMenu_SetLayout    (          ) {                                  }
function CMenu_SetImagePath (          ) {                                  }
function CMenu_SetStyleSheet(stylesheet) { this.tm.stylesheet = stylesheet; }
function CMenu_SetCodePage  (codepage  ) { this.tm.charset = codepage;      }
function CMenu_SetLevel2Item(id, init  ) { this.tm.setLevel2(id);           }
function CMenu_SetTitle     (title     ) { this.tm.title = title;           }
function CMenu_GenerateTree (          ) { this.tm.generate();              }
function CMenu_SelectEntry  (id        ) { this.tm.markItem(id);            }
function CMenu_Explode      (          ) { this.tm.openAll();               }
function CMenu_Contract     (          ) { this.tm.closeAll();              }
function CMenu_PrevEntry    (          ) { this.tm.selectPrev();            }
function CMenu_NextEntry    (          ) { this.tm.selectNext();            }

function CMenu_Add(mother, display, myURL, indent, outputWindow, newItem, key) {
    var state  = indent <= 0 ? 1 : 0;
    var href   = "../../" + myURL;
    var image  = outputWindow == "" ? "" : this.imgItemStructLink.src;
    var status = outputWindow == "" ? "" : this.stsStructLink;

    var item = this.tm.add(
    //  level,  state, id,  title,   href, target,       hrefNewWindow, image, imageOpened, status);
        indent, state, key, display, href, outputWindow, "",            image, "",          status);
}

function CMenu_Sync() {
    this.tm.m_cookie.setStateCloseAll();
    this.tm.m_cookie.marked = -1;
    this.tm.m_cookie.save();
    this.tm.m_window.parent.parent.SAP_TEXT.history.go(0);
}

function PH_itemGo(item) {
    var target = item.target;
    if(target == "") {
        this.m_window.parent.parent.SAP_TEXT.location = item.href;
    }
    else if(typeof(target) == "string") {
        if(target.substring(0, 1) == "_") {
            target = target.substring(1);
        }
        top[target].location = item.href;
    }
}

