/*
 *  unsucces.h
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                         
 *   blwtt.h
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
//  This class handles the basic information needed to track call failures
//  for one phone number for one calling device.  This is the most basic
//  object used in the blacklist algorithm.  An overview of operations
//  can be found in the mwbl.txt file.
//
//
//
//
//****************************************************************************

#if !defined(UNSUCCES_H)
#define UNSUCCES_H  1


//---- includes --------------------------------------------------------------

#include <mwblapi.h>  // for the MAX_BL_DIAL_STRING define
#include <time.h>


//---- defines ---------------------------------------------------------------

// This defines how many unsuccessful call time stamps are stored with each
// phone number.  This is the maximum allowed unsuccessful count in a time
// window.
#define MAX_TIME_STAMP_COUNT      6


//These defines are used with the UnsuccessfulRecord.ulRecordStatus field

#define FIRST_SERIES                         1
#define SECOND_SERIES                        2
#define SERIES_TO_SERIES_DELAY               3
#define NUMBER_BLACKLISTED                   4



//-----------------------------------------------------------------------------
typedef struct _UnsuccessfulRecord
{
  
  // This specifies if the class has been initialized
  BOOL bInitialized;

  // A call restricted phone number.  When blank this record is not tracking
  // a phone number.
  char szPhoneNumber[MAX_BL_DIAL_STRING];
  
  // This contains status about the number being tracked.  Information
  // includes First Series, Second Series, Series-to-Series delay, Handle
  // Checked Out, etc.
  ULONG  ulRecordStatus;

  // This keeps track of the number of unsuccessful call attempts in the
  // current series.
  ULONG  ulUnsuccessfulCount;
  
  // This parameter was added to handle special code for Canada.
  ULONG  ulNonBusyUnsuccessfulCount;
  
  
  // This is the time stamp array for when a failure occurred.  This is for
  // call windowing.   Only the first time stamp is used during normal series
  // blacklisting.
  time_t TimeStampArray[MAX_TIME_STAMP_COUNT];
  
} UnsuccessfulRecord; 

ULONG failReset (UnsuccessfulRecord *pRec);
time_t failFindLatestTimeStamp(UnsuccessfulRecord *pRec);
BOOL failIsPhoneNumber (UnsuccessfulRecord *pRec, const char *szComparePhoneNumber);
ULONG failMakeNewRecord (UnsuccessfulRecord *pRec, char *szNewPhoneNumber);
ULONG failRequestDialPermission (UnsuccessfulRecord *pRec, time_t CurrentTime,
				 ULONG FAR *lpulDialStatus,
				 ULONG FAR *lpulDelayTime);
ULONG failDialResults ( UnsuccessfulRecord *pRec, ULONG ulDialStatus, time_t CurrentTime);
ULONG failGetNumberInfo (UnsuccessfulRecord *pRec, struct BL_NumberListItem FAR *lpNumberListItem,
			 time_t CurrentTime);
ULONG failCleanCallWindow (UnsuccessfulRecord *pRec, time_t CurrentTime);
ULONG failCheckCallWindow (UnsuccessfulRecord *pRec, time_t CurrentTime, ULONG FAR *lpulDialStatus,
			   ULONG FAR *lpulDelayTime);
ULONG failCheckSeries (UnsuccessfulRecord *pRec, time_t CurrentTime, ULONG FAR *lpulDialStatus,
		       ULONG FAR *lpulDelayTime);
ULONG failUpdateCallWindow (UnsuccessfulRecord *pRec, time_t CurrentTime);
ULONG failUpdateSeries (UnsuccessfulRecord *pRec, ULONG ulDialStatus, time_t CurrentTime);
ULONG failIsNumberBlacklisted(UnsuccessfulRecord *pRec);


#endif // !defined(UNSUCCES_H)
