/*
 *   mwaveapi.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#ifndef MWAVEAPI_INCLUDED     /* CH12 LBM */
#define MWAVEAPI_INCLUDED     /* CH11 indicate that MWAVEAPI.H has been included */

#include "port_types.h"
#include "mwave.h"

BOOL MwaveAPIInit(DWORD ulReason);

#define START 1
#define STOP 0

RC APIENTRY   dspAbilities(HDSP  hDSP,
                            PUSHORT pusSize,
                            PVOID pDSPQueryBuf);


RC APIENTRY   dspAllocateSegment(HTASK   hTask,
                                  PSZ    pszInstanceName,                 /*CH14*/
                                  ULONG  ulSize,
                                  ULONG  ulAlign,
                                  USHORT usFLAGS,
                                  ULONG  ulDSPAddr,                       /*CH14*/
                                  PHSEG  phSeg);

RC APIENTRY   dspChangeCPF(HTASK hTask,LONG   lCPF);

RC APIENTRY   dspChangeDMA(HTASK hTask,
                            PSZ    pszDMAName,
                            LONG   lPacket,
                            LONG   lMaxPacketSize,
                            LONG   lMaxPacketPF,
                            USHORT usStride,
                            USHORT usHold);

RC APIENTRY   dspChangeModuleState(HMOD hMod,USHORT usFlags);

RC APIENTRY   dspChangeTaskState(HTASK hTask,USHORT usFlags);

RC APIENTRY   dspConnectGPC(HTASK hOwnerTask,
                             PSZ  pszOwner,
                             HTASK hUserTask,
                             PSZ  pszUser,
                             USHORT usProtocol,
                             PULONG pulDSPAddr);

RC APIENTRY   dspConnectIPC(HTASK  hTask,
                             PFN   pfnIPCNotice,
                             PHIPC phIPC);

RC APIENTRY   dspConnectITCB(HTASK hPrimaryTask,
                              PSZ  pszPrimary,
                              HTASK hSecondaryTask,
                              PSZ  pszSecondary);

RC APIENTRY   dspDisconnectIPC(HIPC hIPC);

RC APIENTRY   dspDisconnectGPC(HTASK hOwnerTask,
                                PSZ  pszOwner,
                                HTASK hUserTask,
                                PSZ  pszUser);

RC APIENTRY   dspDisconnectITCB(HTASK hPrimaryTask,
                                 PSZ  pszPrimary,
                                 HTASK hSecondaryTask,
                                 PSZ  pszSecondary);

RC APIENTRY   dspFreeModule(HMOD hMod);

RC APIENTRY   dspFreeSegment(HSEG hSeg);

RC APIENTRY   dspFreeTask(HTASK hTask);

RC APIENTRY   dspInit (HDSP hdsp,PSZ pszFileName);

RC APIENTRY   dspLabelToAddress(HTASK hTask,
                                  PSZ pszName,
                                  PULONG pulDSPAddr);

RC APIENTRY   dspLoadModule(HDSP hDSP,
                             PSZ    pszFileName,
                             PSZ    pszInstanceName,
                             USHORT usFlags,
                             PHMOD  phMod);

RC APIENTRY   dspLoadSegment(HTASK  hTask,
                              PSZ   pszFileName,
                              PSZ   pszSegmentName,
                              PSZ   pszInstanceName,
                              ULONG ulDSPAddr,
                              PHSEG phSeg);

RC APIENTRY   dspLoadTask(HMOD  hMod,
                         HDSP   hDSP,
                         PSZ    pszFilename,
                         PSZ    pszTaskName,
                         PSZ    pszInstanceName,
                         USHORT usFlags,
                         PVOID  pRQHWBuf,
                         PHTASK phTask);

RC APIENTRY   dspLockMem(PVOID   pBuffer,
                         ULONG   ulBufSize,
                         PHLOCK  phLock,
                         PUSHORT pusPhysCount,
                         PVOID   pPhysTable,
                         ULONG   ulDirection );

RC APIENTRY   dspMemTransfer(HDSP   hDSP,
                              ULONG  ulDSPAddr,
                              PVOID  pPCAddress,
                              USHORT usNumWords,
                              USHORT usFlags);

RC APIENTRY   dspNameToModuleHandle(PSZ   pszInstanceName,
                                      PHMOD phMod);

RC APIENTRY   dspNameToSegmentHandle(HTASK  hTask,
                                      PSZ   pszInstanceName,
                                      PHSEG phSeg);

RC APIENTRY   dspNameToTaskHandle(HMOD  hMod,
                                   PSZ   pszInstanceName,
                                   PHTASK phTask);

RC APIENTRY   dspQueryDSPInfo (HDSP    hDSP,
                                PUSHORT pusSize,
                                PVOID   pDSPInfoBuf);

RC APIENTRY   dspQueryManagerInfo (PUSHORT pusSize,
                                    PVOID   pMgrInfoBuf);

RC APIENTRY   dspQueryMiscInfo (USHORT  usType,
                                 HMISC   hMisc,
                                 PUSHORT pusSize,
                                 PVOID   pMiscInfoBuf);

RC APIENTRY   dspQueryModuleInfo (HMOD    hMod,
                                   PUSHORT pusSize,
                                   PVOID   pModInfoBuf);

RC APIENTRY   dspQueryTaskInfo (HTASK   hTask,
                                 PUSHORT pusSize,
                                 PVOID   pTaskInfoBuf);

RC APIENTRY   dspReset (HDSP hdsp);

RC APIENTRY   dspRun  (HDSP hdsp);

RC APIENTRY   dspUnLockMem (PHLOCK  phLock);			/* CH13 */

/*RC APIENTRY   dspCreatePFT (PVOID   pBuffer,         
                            ULONG   ulBufferSize,
                            PUSHORT pusNumPages,
                            PPFT    pPageFrameTable );

RC APIENTRY   dspFreePFT (HPFT hPft);   

RC APIENTRY   dspStartDMA (HPFT hPft);  

RC APIENTRY   CopyBufH2L (HPFT hPft); 
 
RC APIENTRY   dspStopDMA (HPFT hPft); */

#endif  /* CH12 LBM */
