/*
 *   dspabil.c -- Routines for accessing config info  
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "dspmgr.h"                       
extern char *ini_file;
#define MW_USE_REG_FOR_INI_SETTINGS 
//#include "ini2reg.h"

#define __DSPABIL
#include "dspabil.h"
#include "dspstcmp.h"

#define NHWTYPES 9
#define FIRST 0
#define NEXT 1

/* @TBD @PORT. hardcoded locations for dsp files */
static char rootdir[80]="";
static char osname[80]=""; /* /tmp/mwave/mwos3780.dsp"; */
static char osinitname[80]=""; /* /tmp/mwave/init0437.dsp"; */
static char biosname[80]=""; /* /tmp/mwave/mwbi0917.dsp"; */
static char dartlabeldir[80]="";
static char dspfilesdir[80]="";
static char buscapacity[80]="0xffffffff";          
static char lpcount[80]="0";                       

typedef struct entry_list
{
   int   entrynum;
   char  *section;
   char  *entryname;
   char  entryvalue[80];
   char  actentry[20];
} ENTRYLIST, *PENTRYLIST;

typedef struct hardware
{
   char     name[20];
   USHORT   id;
   USHORT   count;
} HARDWARE, *PHARDWARE;

BOOL GetEntry(int which, PENTRYLIST plist, char *filename);

static HARDWARE hardware[NHWTYPES]=
{
   { "Stereo_In",  0x0001, 0 },
   { "Stereo_Out", 0x8001, 0 },
   { "Phone_Line", 0xE006, 0 },
   { "Phone_Set",  0x0006, 0 },
   { "MIDI_In",    0x0008, 0 },
   { "MIDI_Out",   0x8008, 0 },
   { "DSP",        0xE009, 0 },
   { "UART",       0xE00A, 0 },
   { "ACI",        0xE00B, 0 }
};

static int  hwnum=0;

/****************************************************************************/
/*                                                                          */
/*                                                                          */
/****************************************************************************/

BOOL GetEntry(int which, PENTRYLIST plist, char *filename)
{
   BOOL           rtn;
   int            l;

   rtn=FALSE;
   if (which==FIRST) plist->entrynum=0;
   sprintf(plist->actentry, "%s%d", plist->entryname, plist->entrynum+1);
   l=GetPrivateProfileString(plist->section, plist->actentry, "",
            plist->entryvalue, sizeof(plist->entryvalue), filename);
   if (l>0){plist->entrynum++; rtn=TRUE;}
   return(rtn);
}


/****************************************************************************/
/*                                                                          */
/*                                                                          */
/****************************************************************************/

RC GetFirstHW(PUSHORT pusHwid, PUSHORT pusCount)
{
   RC          ulRC;
   int         i, rtn;
   ENTRYLIST   elist;


   hwnum=0;
   elist.section="mwave,board";
   elist.entryname="hw";
        for (i=0; i<NHWTYPES; i++) hardware[i].count=0;
        rtn=GetEntry(FIRST, &elist, ini_file);
        while (rtn==TRUE)
        {
                for (i=0; i<NHWTYPES; i++)
      {
	if (0==strcasecmp(elist.entryvalue, hardware[i].name)) 
         {
            hardware[i].count++;
         }
      }
      rtn=GetEntry(NEXT, &elist, ini_file);
   }
   ulRC=GetNextHW(pusHwid, pusCount);
   return(ulRC);
}


/****************************************************************************/
/*                                                                          */
/*                                                                          */
/****************************************************************************/

RC GetNextHW(PUSHORT pusHwid, PUSHORT pusCount)
{
  /* int         i; */

   for (; hwnum<NHWTYPES; hwnum++)
   {
      if (hardware[hwnum].count>0)
      {
         *pusHwid=hardware[hwnum].id;
         *pusCount=hardware[hwnum].count;
         hwnum++;
         return(DSP_NOERROR);
      }
   }
   return(DSP_ERROR);
}


/****************************************************************************/
/*                                                                          */
/*                                                                          */
/****************************************************************************/

ULONG GetMips()
{
   char  text[80];

   GetPrivateProfileString("MWAVE,BOARD", "ips", "0", text,
                               sizeof(text), ini_file);
   return(atol(text));
}

/****************************************************************************/
/*                                                                          */
/*                                                                          */
/****************************************************************************/

ULONG GetMemSize()
{
   char  text[80];

   GetPrivateProfileString("MWAVE,BOARD", "memsize", "0", text,
                               sizeof(text), ini_file);
   return(atol(text));
}



/****************************************************************************/
/*                                                                          */
/*     GetDSPStringAttribute                                                */
/*                                                                          */
/****************************************************************************/

PSZ FAR PASCAL GetDSPStringAttribute(USHORT type, HDSP hdsp)
{
   UINT   dartsw;
   static int  stringsvalid=0;
   PSZ    pszString;
   CHAR   szName[40];

   MW_SYSLOG_3(TRACE_MANAGER_CORE,"dspabil::GetDSPStringAttribute entry type %x hdsp %x\n",type,(int)hdsp);

   if (stringsvalid!=1)
   {
    // If overlay force read of os & bios name from MWAVE.INI
    // file otherwise use default search path 

      sprintf(szName, "%s", ini_file);

      GetPrivateProfileString("MWAVE", "OSNAME", "", osname, 80, szName);
      GetPrivateProfileString("MWAVE", "BIOS", "", biosname, 80, szName);
      GetPrivateProfileString("MWAVE", "ROOT", "", rootdir, 80, ini_file);
      GetPrivateProfileString("MWAVE,BOARD", "MWOSINIT", "", osinitname, 80, ini_file); /* CH02 */
      GetPrivateProfileString("MWAVE,BOARD", "lpcount", "0", lpcount, 80, ini_file);    /* CH03 */
      sprintf(dartlabeldir, "%s\\LABELS", rootdir);
      sprintf(dspfilesdir, "%s\\DSP", rootdir);
      stringsvalid=1;
   }
   pszString=NULL;
   switch (type)
   {
      case DSPATTR_OSFILENAME   :
         pszString=osname;
         break;
      case DSPATTR_OSMODNAME    :
         pszString=MWAVEOSNAME;
         break;
      case DSPATTR_BIOSFILENAME :
         pszString=biosname;
         break;
      case DSPATTR_OSINITNAME :              
         pszString=osinitname;               
         break;                              
      case DSPATTR_LPCOUNT:                  
         pszString=lpcount;                  
         break;                              
      case DSPATTR_DSPFILESDIR  :
         pszString=dspfilesdir;
         break;
      case DSPATTR_MWPATH       :
         pszString="MWPATH";
         break;
      case DSPATTR_BUSCAPACITY :   
         dartsw=GetPrivateProfileString("MWAVE,BOARD", "buscapacity", "999999999", buscapacity, 80, ini_file);
         pszString=buscapacity;
         break;
   }
   if (strlen(pszString)>0) {
     MW_SYSLOG_2(TRACE_MANAGER_CORE,"dspabil::GetDSPStringAttribute exit pszString %s\n",pszString);
       return(pszString);
   }
   MW_SYSLOG_1(TRACE_MANAGER_CORE,"dspabil::GetDSPStringAttribute exit pszString NULL\n");
   return(NULL);
}

/****************************************************************************/
/*                                                                          */
/*                                                                          */
/****************************************************************************/

void InitManagerCase(void)
{
   int   mgrcase;

   mgrcase=GetPrivateProfileInt("MWAVE", "mgrcase", 1, ini_file);
   SetCase(mgrcase);
}
