// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOPTools_PaveBlockIterator_HeaderFile
#define _BOPTools_PaveBlockIterator_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BOPTools_PaveSet_HeaderFile
#include <BOPTools_PaveSet.hxx>
#endif
#ifndef _BOPTools_CArray1OfPave_HeaderFile
#include <BOPTools_CArray1OfPave.hxx>
#endif
#ifndef _BOPTools_PaveBlock_HeaderFile
#include <BOPTools_PaveBlock.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class BOPTools_PaveSet;
class BOPTools_PaveBlock;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!         class providing iterations for PaveSet to <br>
//!         have the right order of paves along the edge <br>
//! <br>
class BOPTools_PaveBlockIterator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT BOPTools_PaveBlockIterator();


//! Constructor <br>
//! aEdge     -   DS-index of the edge <br>
//! aPaveSet  -   a set of paves for the edge <br>
Standard_EXPORT BOPTools_PaveBlockIterator(const Standard_Integer aEdge,const BOPTools_PaveSet& aPaveSet);


//! Resets the iterator on the PaveSet <aPaveSet> <br>
Standard_EXPORT   void Initialize(const Standard_Integer aEdge,const BOPTools_PaveSet& aPaveSet) ;


//! Returns True if there is a current Pave in <br>
//! the iteration. <br>
Standard_EXPORT   Standard_Boolean More() const;


//! Moves to the next Pave in the PaveSet <br>
Standard_EXPORT   void Next() ;


//! Returns the current Pave <br>
Standard_EXPORT   BOPTools_PaveBlock& Value() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myEdge;
Standard_Integer myIndex;
BOPTools_PaveSet myPaveSet;
BOPTools_CArray1OfPave myPaves;
BOPTools_PaveBlock myPaveBlock;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
