// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Dynamic_DynamicInstance_HeaderFile
#define _Dynamic_DynamicInstance_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Dynamic_DynamicInstance_HeaderFile
#include <Handle_Dynamic_DynamicInstance.hxx>
#endif

#ifndef _Handle_Dynamic_DynamicClass_HeaderFile
#include <Handle_Dynamic_DynamicClass.hxx>
#endif
#ifndef _Handle_Dynamic_ParameterNode_HeaderFile
#include <Handle_Dynamic_ParameterNode.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_Dynamic_Parameter_HeaderFile
#include <Handle_Dynamic_Parameter.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Dynamic_DynamicClass;
class Dynamic_ParameterNode;
class Dynamic_Parameter;


//! A dynamic  instance is a reference  to the dynamic <br>
//!          class and a  sequence of  parameters which  is the <br>
//!          complete listing of all the parameters  of all the <br>
//!          inherited classes. <br>
class Dynamic_DynamicInstance : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates an empty instance of this class. <br>
Standard_EXPORT Dynamic_DynamicInstance();

//! Adds  <aparameter> to  the   sequence of parameters of <br>
//!          <me>. <br>
Standard_EXPORT   void Parameter(const Handle(Dynamic_Parameter)& aparameter) ;

//! Adds all the parameters  of <me>,  to the sequence  of <br>
//!          parameters of <aninstance>. <br>
Standard_EXPORT   void Parameter(const Handle(Dynamic_DynamicInstance)& aninstance) const;

//! Puts the integer value <avalue> into the parameter <br>
//!          object identified by the string <aparameter>. <br>
Standard_EXPORT   void Parameter(const Standard_CString aparameter,const Standard_Integer avalue) const;

//! Puts the real value <avalue> into the parameter <br>
//!          object identified by the string <aparameter>. <br>
Standard_EXPORT   void Parameter(const Standard_CString aparameter,const Standard_Real avalue) const;

//! Puts the string <avalue> into the parameter <br>
//!          object identified by the string <aparameter>. <br>
Standard_EXPORT   void Parameter(const Standard_CString aparameter,const Standard_CString avalue) const;

//! Puts the dynamic instance <avalue> into the parameter <br>
//!          object identified by the string <aparameter>. <br>
Standard_EXPORT   void Parameter(const Standard_CString aparameter,const Handle(Dynamic_DynamicInstance)& avalue) const;

//! Searches and returns the parameter object identified <br>
//!          by the string <aparameter>. <br>
Standard_EXPORT   Handle_Dynamic_Parameter Parameter(const Standard_CString aparameter) const;

//! Sets the reference of the class. <br>
Standard_EXPORT   void Class(const Handle(Dynamic_DynamicClass)& aclass) ;

//! Calls the method identified by the string <amethod>. <br>
Standard_EXPORT   void Execute(const Standard_CString amethod) const;
//Standard_EXPORT ~Dynamic_DynamicInstance();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Dynamic_DynamicClass thedynamicclass;
Handle_Dynamic_ParameterNode thefirstparameternode;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
