// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESGeom_Flash_HeaderFile
#define _IGESGeom_Flash_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESGeom_Flash_HeaderFile
#include <Handle_IGESGeom_Flash.hxx>
#endif

#ifndef _gp_XY_HeaderFile
#include <gp_XY.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class IGESData_IGESEntity;
class Standard_OutOfRange;
class gp_XY;
class gp_Pnt2d;
class gp_Pnt;


//! defines IGESFlash, Type <125> Form <0 - 4> <br>
//!          in package IGESGeom <br>
//!          A flash entity is a point in the ZT=0 plane that locates <br>
//!          a particular closed area. That closed area can be defined <br>
//!          in one of two ways. First, it can be an arbitrary closed <br>
//!          area defined by any entity capable of defining a closed <br>
//!          area. The points of this entity must all lie in the ZT=0 <br>
//!          plane. Second, it can be a member of a predefined set of <br>
//!          flash shapes. <br>
class IGESGeom_Flash : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESGeom_Flash();

//! This method is used to set the fields of the class Flash <br>
//!       - aPoint     : Reference of flash <br>
//!       - aDim       : First flash sizing parameter <br>
//!       - anotherDim : Second flash sizing parameter <br>
//!       - aRotation  : Rotation of flash about reference point <br>
//!                      in radians <br>
//!       - aReference : Pointer to the referenced entity or Null <br>
Standard_EXPORT   void Init(const gp_XY& aPoint,const Standard_Real aDim,const Standard_Real anotherDim,const Standard_Real aRotation,const Handle(IGESData_IGESEntity)& aReference) ;

//! Changes FormNumber (indicates the Nature of the Flash : <br>
//!           0 Unspecified, then given by Reference, 1->4 various <br>
//!           Specialisations (Circle,Rectangle, etc...) ) <br>
//!           Error if not in range [0-4] <br>
Standard_EXPORT   void SetFormNumber(const Standard_Integer form) ;

//! returns the referenced point, Z = 0 always <br>
Standard_EXPORT   gp_Pnt2d ReferencePoint() const;

//! returns the referenced point after applying Transf. Matrix <br>
Standard_EXPORT   gp_Pnt TransformedReferencePoint() const;

//! returns first flash sizing parameter <br>
Standard_EXPORT   Standard_Real Dimension1() const;

//! returns second flash sizing parameter <br>
Standard_EXPORT   Standard_Real Dimension2() const;

//! returns the angle in radians of the rotation of flash about the <br>
//! reference point <br>
Standard_EXPORT   Standard_Real Rotation() const;

//! returns the referenced entity or Null handle. <br>
Standard_EXPORT   Handle_IGESData_IGESEntity ReferenceEntity() const;

//! returns True if referenced entity is present. <br>
Standard_EXPORT   Standard_Boolean HasReferenceEntity() const;
//Standard_EXPORT ~IGESGeom_Flash();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_XY thePoint;
Standard_Real theDim1;
Standard_Real theDim2;
Standard_Real theRotation;
Handle_IGESData_IGESEntity theReference;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
