// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Message_Printer_HeaderFile
#define _Message_Printer_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Message_Printer_HeaderFile
#include <Handle_Message_Printer.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Message_OutFile_HeaderFile
#include <Handle_Message_OutFile.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Message_EndOfMsg_HeaderFile
#include <Message_EndOfMsg.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Message_OutFile;
class Message_Msg;


//! Defines a Printer which can send string onto any kind of output <br>
//!          stream. <br>
//!          Each printer for specific output should redefine its own way of <br>
//!          outputting messages (see method OwnSend). <br>
//! <br>
//!          Printer defines: <br>
//!          . trace level (for filtering messages):	if a message is sent <br>
//!            with level greater than trace level, it is not output (neither <br>
//!            on output stream nor on echo file). If a message is sent with <br>
//!            level not greater than trace level then it is output. <br>
//!            Trace level must be not less than 0. By default, 0. <br>
//!          . echo file: defines auxiliary output stream (either standard <br>
//!            cout - by default - or a file) for parallel outputting <br>
//!            messages in conjunction with main stream. Echo mode can be <br>
//!            switched on and off (by default). <br>
//! <br>
//!          Messages can be given in the form of string, integer, real and <br>
//!          message class Message_Msg. They can be sent for outputting <br>
//!          either taking into account trace level of the printer or <br>
//!          ignoring it (to ensure output anyway). <br>
class Message_Printer : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates a printer with default parameters (trace level 0, <br>
//!          echo file is cout and echo mode switched off). <br>
Standard_EXPORT Message_Printer();
//! Sets trace level. <br>
  void SetTraceLevel(const Standard_Integer level) ;
//! Returns trace level. <br>
  Standard_Integer TraceLevel() const;
//! Sets echo mode. <br>
  void SetEchoMode(const Standard_Boolean mode) ;
//! Returns echo mode. <br>
  Standard_Boolean EchoMode() const;
//! Sets output file for echo. <br>
  void SetEchoFile(const Handle(Message_OutFile)& echofile) ;
//! Returns output file for echo. <br>
  Handle_Message_OutFile EchoFile() const;
//! Specific method to return OStream to be written on. <br>
//!          By default, returns OStream of echo file. <br>
//!          This method should be redefined for each specific printer. <br>
virtual  Standard_OStream& Out() const;

//! Sends a message given as string. <br>
Standard_EXPORT   void Send(const Standard_CString string,const Standard_Integer level = 0,const Message_EndOfMsg theEnd = Message_Endl) const;

//! Sends a message given as integer. <br>
Standard_EXPORT   void Send(const Standard_Integer inumber,const Standard_Integer level = 0,const Message_EndOfMsg theEnd = Message_Endl) const;

//! Sends a message given as real. <br>
Standard_EXPORT   void Send(const Standard_Real rnumber,const Standard_Integer level = 0,const Message_EndOfMsg theEnd = Message_Endl) const;

//! Sends a message given as Message_Msg. <br>
//!          Sends resulting value from message (see Message_Msg::Value). <br>
Standard_EXPORT   void Send(const Message_Msg& message,const Standard_Integer level = 0,const Message_EndOfMsg theEnd = Message_Endl) const;

  void SendEver(const Standard_CString string,const Message_EndOfMsg theEnd = Message_Endl) const;

  void SendEver(const Standard_Integer inumber,const Message_EndOfMsg theEnd = Message_Endl) const;

  void SendEver(const Standard_Real rnumber,const Message_EndOfMsg theEnd = Message_Endl) const;

  void SendEver(const Message_Msg& message,const Message_EndOfMsg theEnd = Message_Endl) const;

//! Appends message to the resulting string <br>
Standard_EXPORT   void Append(const Standard_CString message) ;
Standard_EXPORT   Message_Printer& operator << (const Standard_CString message);

//! Appends message to the resulting string <br>
Standard_EXPORT   void Append(const Standard_Integer message) ;
Standard_EXPORT   Message_Printer& operator << (const Standard_Integer message);

//! Appends message to the resulting string <br>
Standard_EXPORT   void Append(const Standard_Real message) ;
Standard_EXPORT   Message_Printer& operator << (const Standard_Real message);

//! Appends message to the resulting string <br>
Standard_EXPORT   void Append(const Message_Msg& message) ;
Standard_EXPORT   Message_Printer& operator << (const Message_Msg& message);

//! Sends resulting string accumulated by previous Append methods. <br>
//!          Clears resulting string. <br>
Standard_EXPORT   void Append(const Message_EndOfMsg theEnd = Message_Endl) ;
Standard_EXPORT   Message_Printer& operator << (const Message_EndOfMsg theEnd);
//! Specific method to send a string to an output. <br>
//!          By default, does nothing. <br>
//!          This method should be redefined for each specific printer. <br>
virtual  void OwnSend(const Standard_CString string,const Message_EndOfMsg theEnd = Message_Endl) const;
//Standard_EXPORT ~Message_Printer();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myTraceLevel;
Standard_Boolean myEchoMode;
Handle_Message_OutFile myEchoFile;
TCollection_AsciiString myLine;


};


#include <Message_Printer.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
