// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeUpgrade_ClosedFaceDivide_HeaderFile
#define _ShapeUpgrade_ClosedFaceDivide_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeUpgrade_ClosedFaceDivide_HeaderFile
#include <Handle_ShapeUpgrade_ClosedFaceDivide.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _ShapeUpgrade_FaceDivide_HeaderFile
#include <ShapeUpgrade_FaceDivide.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TopoDS_Face;


//! Divides a Face with one or more seam edge to avoid closed faces. <br>
//!          Splitting is performed by U and V direction. The number of <br>
//!          resulting faces can be defined by user. <br>
class ShapeUpgrade_ClosedFaceDivide : public ShapeUpgrade_FaceDivide {

public:
 // Methods PUBLIC
 // 

//! Creates empty  constructor. <br>
Standard_EXPORT ShapeUpgrade_ClosedFaceDivide();

//! Initialize by a Face. <br>
Standard_EXPORT ShapeUpgrade_ClosedFaceDivide(const TopoDS_Face& F);

//! Performs splitting of surface and computes the shell <br>
//!          from source face. <br>
Standard_EXPORT virtual  Standard_Boolean SplitSurface() ;

//! Sets the number of cutting lines by which closed face <br>
//!          will be splitted. The resulting faces will be num+1. <br>
Standard_EXPORT   void SetNbSplitPoints(const Standard_Integer num) ;

//! Returns the number of splitting points <br>
Standard_EXPORT   Standard_Integer GetNbSplitPoints() const;
//Standard_EXPORT ~ShapeUpgrade_ClosedFaceDivide();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myNbSplit;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
