// File:	StepToGeom_MakeTransformation3d.cxx
// Created:	Tue Feb 16 11:18:48 1999
// Author:	Andrey BETENEV
//		<abv@doomox.nnov.matra-dtv.fr>
// sln 23.10.2001. CTS23496: If problems with creation of direction occur default direction is used (StepToGeom_MakeTransformation3d(...) function)

#include <StepToGeom_MakeTransformation3d.ixx>
#include <StepToGeom_MakeCartesianPoint.hxx>
#include <StepToGeom_MakeDirection.hxx>
#include <StepGeom_CartesianPoint.hxx>
#include <StepGeom_Direction.hxx>
#include <Geom_CartesianPoint.hxx>
#include <Geom_Direction.hxx>
#include <gp_Ax3.hxx>

//=======================================================================
//function : StepToGeom_MakeTransformation3d
//purpose  : 
//=======================================================================

StepToGeom_MakeTransformation3d::StepToGeom_MakeTransformation3d (const Handle(StepGeom_CartesianTransformationOperator3d) &CTO ) 
{
//  NB : on ne s interesse ici qu au deplacement rigide
  Handle(StepGeom_CartesianPoint) P = CTO->LocalOrigin();
  Handle(StepGeom_Direction) A1 = CTO->Axis1();
  Handle(StepGeom_Direction) A2 = CTO->Axis2();
  Handle(StepGeom_Direction) A3 = CTO->Axis3();

  StepToGeom_MakeCartesianPoint MkPoint(P);
  gp_Pnt Pgp = MkPoint.Value()->Pnt();

  gp_Dir D1,D2,D3;
  // sln 23.10.2001. CTS23496: If problems with creation of direction occur default direction is used
  Standard_Boolean isDefaultDirectionUsed = Standard_True;
  if (!A1.IsNull()) {
    StepToGeom_MakeDirection M1(A1);
    if(M1.IsDone()) {
      D1 = M1.Value()->Dir();
      isDefaultDirectionUsed = Standard_False;
    }
  }
  if(isDefaultDirectionUsed) 
    D1 = gp_Dir (1.,0.,0.);
  
  isDefaultDirectionUsed = Standard_True;
  if (!A2.IsNull()) {
    StepToGeom_MakeDirection M2(A2);
    if(M2.IsDone()) {
      D2 = M2.Value()->Dir();
      isDefaultDirectionUsed = Standard_False;
    }
  }
  if(isDefaultDirectionUsed) 
    D2 = gp_Dir (0.,1.,0.);
  
  isDefaultDirectionUsed = Standard_True;
  if (!A3.IsNull()) {
    StepToGeom_MakeDirection M3(A3);
    if(M3.IsDone()) {
      D3 = M3.Value()->Dir();
      isDefaultDirectionUsed = Standard_False;
    }
  }
  if(isDefaultDirectionUsed) 
    D3 = D1.Crossed(D2);

//  D1 en X  D2 en Y  D3 en Z

  gp_Ax3 result (Pgp,D3,D1);
  myT.SetTransformation(result);
  myT = myT.Inverted(); //:n8 abv 16 Feb 99: tr8_as2_db.stp: reverse for accordance with LV tool
  
  done = Standard_True;
}

//=======================================================================
//function : Value
//purpose  : 
//=======================================================================

const gp_Trsf &StepToGeom_MakeTransformation3d::Value () const
{
  return myT;
}
