/*
 * Copyright 2017 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */
/*****************************************************************************************
 ******************** This file was generated by sksllex. Do not edit. *******************
 *****************************************************************************************/
#include "src/sksl/SkSLLexer.h"

namespace SkSL {

using State = uint16_t;
static const uint8_t INVALID_CHAR = 18;
static const int8_t kMappings[127] = {
        0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  3,  1,  3,  3,  3,  3,  3,  3,  3,  3,
        3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  1,  4,  3,  5,  6,  7,  8,  3,  9,  10, 11, 12,
        13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 22, 22, 23, 23, 24, 25, 26, 27, 28, 29, 30, 31,
        31, 32, 33, 34, 31, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 36, 37, 35, 38, 35, 35,
        39, 35, 35, 40, 3,  41, 42, 43, 3,  44, 45, 46, 47, 48, 49, 50, 51, 52, 35, 53, 54, 55,
        56, 57, 58, 35, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
struct IndexEntry {
    uint16_t type : 2;
    uint16_t pos : 14;
};
struct FullEntry {
    State data[72];
};
struct CompactEntry {
    State v0 : 6;
    State v1 : 9;
    State v2 : 9;
    uint8_t data[18];
};
static constexpr FullEntry kFull[] = {
        {
                0,   2,   3,   4,   5,   7,   9,   14,  16,  19,  20,  21,  23,  26,  27,
                30,  35,  41,  60,  60,  60,  60,  60,  60,  62,  63,  64,  68,  70,  74,
                75,  84,  84,  84,  84,  84,  84,  84,  84,  84,  85,  86,  87,  84,  90,
                100, 105, 121, 141, 153, 169, 174, 182, 84,  206, 216, 223, 249, 254, 270,
                276, 348, 365, 381, 393, 84,  84,  84,  398, 399, 402, 403,
        },
        {
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,  42, 0, 50, 50, 50, 50, 50, 50, 51,
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 57, 58, 0, 0,  0,  0,  0,  0,  0,  0,
                52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 57, 0,  0, 58, 0,  0,  0,  0,  0,  0,
        },
        {
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,  42, 0, 50, 50, 50, 50, 50, 50, 51,
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 56, 0,  0, 0,  0,  0,  0,  0,  0,  0,
                52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 56, 0,  0, 0,  0,  0,  0,  0,  0,  0,
        },
        {
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,  42, 0, 51, 51, 51, 51, 51, 51, 51,
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 55, 0,  0, 0,  0,  0,  0,  0,  0,  0,
                52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 55, 0,  0, 0,  0,  0,  0,  0,  0,  0,
        },
        {
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,  42, 0, 61, 61, 61, 61, 61, 61, 61,
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 57, 0,  0, 0,  0,  0,  0,  0,  0,  0,
                52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 57, 0,  0, 0,  0,  0,  0,  0,  0,  0,
        },
        {
                0,   0,  0,  0,   0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  10,
                10,  10, 10, 10,  10, 10, 0,  0,  0,   0,  0,  0,  0,  10, 10, 10, 10, 10,
                10,  10, 10, 10,  0,  0,  0,  10, 106, 10, 10, 10, 10, 10, 10, 10, 10, 10,
                109, 10, 10, 112, 10, 10, 10, 10, 10,  10, 10, 10, 10, 10, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,   0,  0,  0,  0,  0,  0,   0,  0,  0,   0,  0,  0,  0,   10,
                10, 10, 10, 10,  10, 10, 0,  0,  0,  0,   0,  0,  0,   10, 10, 10, 10,  10,
                10, 10, 10, 10,  0,  0,  0,  10, 10, 10,  10, 10, 122, 10, 10, 10, 128, 10,
                10, 10, 10, 134, 10, 10, 10, 10, 10, 138, 10, 10, 10,  10, 0,  0,  0,   0,
        },
        {
                0,   0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  10,
                10,  10, 10,  10, 10, 10, 0,  0,  0,  0,  0,  0,   0,  10, 10, 10, 10, 10,
                10,  10, 10,  10, 0,  0,  0,  10, 10, 10, 10, 10,  10, 10, 10, 10, 10, 10,
                142, 10, 145, 10, 10, 10, 10, 10, 10, 10, 10, 147, 10, 10, 0,  0,  0,  0,
        },
        {
                0,   0,  0,  0,   0,  0,  0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,   10,
                10,  10, 10, 10,  10, 10, 0,  0,  0,   0,   0,  0,  0,  10, 10, 10, 10,  10,
                10,  10, 10, 10,  0,  0,  0,  10, 154, 10,  10, 10, 10, 10, 10, 10, 158, 10,
                161, 10, 10, 164, 10, 10, 10, 10, 10,  166, 10, 10, 10, 10, 0,  0,  0,   0,
        },
        {
                0,   0,  0,  0,   0,   0,  0,  0,   0,  0,   0,  0,  0,  0,  0,  0,  0,  10,
                10,  10, 10, 10,  10,  10, 0,  0,   0,  0,   0,  0,  0,  10, 10, 10, 10, 10,
                10,  10, 10, 10,  0,   0,  0,  10,  10, 10,  10, 10, 10, 10, 10, 10, 10, 10,
                185, 10, 10, 189, 192, 10, 10, 194, 10, 200, 10, 10, 10, 10, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,  0,   0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  10,
                10, 10, 10, 10, 10, 10,  0,  0,  0,   0,  0,  0,  0,  10, 10, 10, 10, 10,
                10, 10, 10, 10, 0,  0,   0,  10, 255, 10, 10, 10, 10, 10, 10, 10, 10, 10,
                10, 10, 10, 10, 10, 259, 10, 10, 266, 10, 10, 10, 10, 10, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,  0,  0,  0,   0,   0,  0,   0,  0,  0,  0,  0,  0,   10,
                10, 10, 10, 10, 10, 10, 0,  0,   0,   0,  0,   0,  0,  10, 10, 10, 10,  10,
                10, 10, 10, 10, 0,  0,  0,  10,  277, 10, 10,  10, 10, 10, 10, 10, 309, 313,
                10, 10, 10, 10, 10, 10, 10, 331, 339, 10, 343, 10, 10, 10, 0,  0,  0,   0,
        },
        {
                0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  10,
                283, 290, 301, 10, 10, 10, 0,  0,  0,  0,  0,  0,  0,  10, 306, 10, 10, 10,
                10,  10,  10,  10, 0,  0,  0,  10, 10, 10, 10, 10, 10, 10, 10,  10, 10, 10,
                10,  10,  10,  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 0,   0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,   0,  0,  0,   0,  10,
                10, 10, 10, 10, 10, 10,  0,  0,  0,  0,  0,  0,  0,   10, 10, 10,  10, 10,
                10, 10, 10, 10, 0,  0,   0,  10, 10, 10, 10, 10, 349, 10, 10, 355, 10, 10,
                10, 10, 10, 10, 10, 357, 10, 10, 10, 10, 10, 10, 360, 10, 0,  0,   0,  0,
        },
};
static constexpr CompactEntry kCompact[] = {
        {0,
         0,
         3,
         {
                 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         6,
         {
                 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         8,
         {
                 0, 0, 0, 0, 0, 0, 0, 192, 255, 255, 192, 255, 255, 255, 255, 255, 255, 0,
         }},
        {0,
         0,
         8,
         {
                 0, 0, 0, 0, 252, 255, 0, 192, 255, 255, 192, 255, 255, 255, 255, 255, 255, 0,
         }},
        {0,
         10,
         11,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         0,
         10,
         {
                 0, 0, 0, 0, 252, 255, 0, 192, 255, 255, 192, 255, 255, 255, 255, 255, 255, 0,
         }},
        {0,
         10,
         12,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {0,
         10,
         13,
         {
                 0, 0, 0, 0, 168, 171, 0, 128, 170, 170, 128, 170, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         0,
         15,
         {
                 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         17,
         18,
         {
                 0, 0, 2, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         22,
         {
                 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         24,
         25,
         {
                 0, 0, 0, 2, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         28,
         29,
         {
                 0, 0, 0, 32, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         31,
         {
                 0, 0, 0, 0, 252, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         31,
         32,
         {
                 0, 0, 0, 0, 168, 170, 0, 0, 48, 0, 0, 0, 3, 0, 0, 0, 0, 0,
         }},
        {0,
         33,
         34,
         {
                 0, 0, 0, 34, 252, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         34,
         {
                 0, 0, 0, 0, 252, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {36,
         39,
         40,
         {
                 0, 0, 64, 0, 2, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         36,
         37,
         {
                 168,
                 170,
                 234,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
         }},
        {0,
         36,
         38,
         {
                 168,
                 170,
                 170,
                 170,
                 171,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
         }},
        {0,
         0,
         39,
         {
                 204,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {0,
         43,
         47,
         {
                 0, 0, 0, 0, 168, 170, 0, 0, 48, 0, 0, 0, 3, 0, 0, 0, 0, 0,
         }},
        {0,
         43,
         44,
         {
                 0, 0, 0, 0, 168, 170, 0, 0, 48, 0, 0, 0, 3, 0, 0, 0, 0, 0,
         }},
        {0,
         45,
         46,
         {
                 0, 0, 0, 34, 252, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         46,
         {
                 0, 0, 0, 0, 252, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         48,
         49,
         {
                 0, 0, 0, 34, 252, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         49,
         {
                 0, 0, 0, 0, 252, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         53,
         54,
         {
                 0, 0, 0, 34, 252, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         54,
         {
                 0, 0, 0, 0, 252, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         59,
         {
                 0, 0, 0, 0, 252, 255, 0, 192, 63, 0, 0, 255, 15, 0, 0, 0, 0, 0,
         }},
        {0,
         57,
         59,
         {
                 0, 0, 0, 0, 252, 255, 0, 192, 63, 32, 0, 255, 15, 0, 0, 32, 0, 0,
         }},
        {0,
         65,
         67,
         {
                 0, 0, 0, 0, 0, 0, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         66,
         {
                 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         69,
         {
                 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         71,
         72,
         {
                 0, 0, 0, 0, 0, 0, 128, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         73,
         {
                 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         76,
         78,
         {
                 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 3, 0, 0,
         }},
        {0,
         0,
         77,
         {
                 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         79,
         {
                 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,
         }},
        {0,
         0,
         80,
         {
                 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0,
         }},
        {0,
         0,
         81,
         {
                 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0,
         }},
        {0,
         0,
         82,
         {
                 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0,
         }},
        {0,
         0,
         83,
         {
                 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0,
         }},
        {0,
         88,
         89,
         {
                 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0,
         }},
        {10,
         91,
         93,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 85, 85, 85, 85, 94, 85, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 234, 170, 170, 170, 0,
         }},
        {0,
         10,
         94,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         95,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         96,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         97,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 174, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         98,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         99,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         101,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         102,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         103,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         104,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 174, 170, 170, 170, 0,
         }},
        {0,
         10,
         107,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {10,
         92,
         108,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 85, 87, 85, 85, 89, 85, 0,
         }},
        {0,
         10,
         110,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         111,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {0,
         10,
         113,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 171, 170, 170, 0,
         }},
        {10,
         114,
         116,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 85, 85, 85, 85, 94, 85, 0,
         }},
        {0,
         10,
         115,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         117,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         118,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 171, 170, 170, 0,
         }},
        {0,
         10,
         119,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         120,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         123,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 174, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         124,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         125,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         126,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 186, 170, 170, 170, 0,
         }},
        {0,
         10,
         127,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         129,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {0,
         10,
         130,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         131,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         132,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         133,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 234, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         135,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         136,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 174, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         137,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 186, 170, 170, 170, 0,
         }},
        {0,
         10,
         139,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         140,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 232, 175, 0, 128, 170, 170, 128, 170, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         143,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {0,
         10,
         144,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         146,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         148,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         149,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         150,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         151,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 171, 170, 170, 0,
         }},
        {0,
         10,
         152,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 186, 170, 170, 170, 0,
         }},
        {0,
         10,
         155,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 186, 170, 170, 170, 0,
         }},
        {0,
         10,
         156,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {0,
         10,
         157,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         159,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 170, 174, 0,
         }},
        {0,
         10,
         160,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 234, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         162,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         163,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         165,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         167,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         168,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {10,
         170,
         172,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 85, 85, 101, 93, 85, 85, 0,
         }},
        {0,
         10,
         171,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 192, 170, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         0,
         171,
         {
                 0, 0, 0, 0, 252, 255, 0, 192, 255, 255, 192, 255, 255, 255, 255, 255, 255, 0,
         }},
        {0,
         10,
         173,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 174, 170, 170, 0,
         }},
        {10,
         175,
         179,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 85, 85, 86, 85, 213, 85, 0,
         }},
        {0,
         10,
         176,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 186, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         177,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 234, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         178,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 186, 170, 170, 0,
         }},
        {0,
         10,
         180,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         181,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {10,
         183,
         184,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 85, 89, 85, 87, 85, 85, 0,
         }},
        {0,
         10,
         186,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         187,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 171, 170, 170, 0,
         }},
        {0,
         10,
         188,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         190,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         191,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         193,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         195,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         196,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         197,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 174, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         198,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         199,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         201,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         202,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         203,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         204,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         205,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 171, 170, 170, 0,
         }},
        {10,
         207,
         212,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 86, 85, 85, 93, 85, 85, 0,
         }},
        {0,
         10,
         208,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 170, 186, 0,
         }},
        {0,
         10,
         209,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 174, 170, 170, 0,
         }},
        {0,
         10,
         210,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         211,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {10,
         213,
         214,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 85, 85, 85, 86, 85, 87, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 186, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         215,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 186, 170, 170, 0,
         }},
        {0,
         10,
         217,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         218,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 234, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         219,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         220,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         221,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 234, 170, 170, 170, 0,
         }},
        {0,
         10,
         222,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 186, 170, 170, 0,
         }},
        {10,
         224,
         231,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 86, 85, 85, 93, 85, 85, 0,
         }},
        {0,
         10,
         225,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 234, 170, 170, 170, 0,
         }},
        {0,
         10,
         226,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         227,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {0,
         10,
         228,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 186, 170, 170, 0,
         }},
        {0,
         10,
         229,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         230,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {10,
         232,
         238,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 85, 85, 86, 117, 85, 85, 0,
         }},
        {0,
         10,
         233,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 171, 170, 170, 0,
         }},
        {0,
         10,
         234,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 186, 170, 170, 170, 0,
         }},
        {0,
         10,
         235,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         236,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 171, 170, 170, 0,
         }},
        {0,
         10,
         237,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         239,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         240,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         241,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {0,
         10,
         242,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 186, 170, 170, 0,
         }},
        {0,
         10,
         243,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         244,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         245,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         246,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         247,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 234, 170, 0,
         }},
        {0,
         10,
         248,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         250,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         251,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         252,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 186, 170, 170, 0,
         }},
        {0,
         10,
         253,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         256,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         257,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 174, 170, 170, 170, 0,
         }},
        {0,
         10,
         258,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         260,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         261,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         262,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         263,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {0,
         10,
         264,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         265,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 174, 170, 170, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 171, 170, 170, 0,
         }},
        {0,
         10,
         267,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 174, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         268,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 186, 170, 170, 170, 0,
         }},
        {0,
         10,
         269,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         271,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         272,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         273,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         274,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         275,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 171, 170, 170, 0,
         }},
        {0,
         10,
         278,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 234, 170, 170, 170, 0,
         }},
        {0,
         10,
         279,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 186, 170, 170, 0,
         }},
        {0,
         10,
         280,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 186, 170, 170, 170, 0,
         }},
        {0,
         10,
         281,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         282,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         284,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 174, 170, 128, 170, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         285,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 174, 128, 170, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         286,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 234, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         287,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         288,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 234, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         289,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 174, 170, 170, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 170, 171, 0,
         }},
        {0,
         10,
         291,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 174, 170, 128, 170, 170, 170, 170, 170, 170, 0,
         }},
        {10,
         285,
         292,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 91, 64, 85, 85, 85, 85, 85, 85, 0,
         }},
        {0,
         10,
         293,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         294,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         295,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         296,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 174, 128, 170, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         297,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 234, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         298,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         299,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 234, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         300,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 174, 170, 170, 0,
         }},
        {0,
         10,
         302,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 174, 170, 128, 170, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         303,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 171, 128, 170, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         304,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         305,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         307,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         308,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 174, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         310,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 170, 234, 0,
         }},
        {0,
         10,
         311,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         312,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 174, 170, 170, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 174, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         314,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 192, 170, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         315,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 234, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         316,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         317,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {0,
         10,
         318,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 192, 170, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         319,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {0,
         10,
         320,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         321,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 234, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         322,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         323,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 192, 170, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         324,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         325,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 174, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         326,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 174, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         327,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         328,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         329,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         330,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 171, 170, 0,
         }},
        {10,
         332,
         335,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 86, 85, 85, 213, 85, 85, 0,
         }},
        {0,
         10,
         333,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         334,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         336,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         337,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         338,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         340,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 186, 170, 170, 0,
         }},
        {0,
         10,
         341,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         342,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         92,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 186, 170, 170, 0,
         }},
        {0,
         10,
         344,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         345,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         346,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 186, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         347,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 234, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         350,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 234, 170, 170, 170, 0,
         }},
        {0,
         10,
         351,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 186, 170, 170, 0,
         }},
        {0,
         10,
         352,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 186, 170, 170, 170, 0,
         }},
        {0,
         10,
         353,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         354,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         356,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         358,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 186, 170, 0,
         }},
        {0,
         10,
         359,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         361,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 186, 170, 170, 0,
         }},
        {0,
         10,
         362,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         363,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 234, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         364,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {10,
         366,
         378,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 85, 85, 85, 86, 87, 85, 0,
         }},
        {10,
         367,
         373,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 85, 85, 86, 85, 87, 85, 0,
         }},
        {10,
         368,
         372,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 85, 89, 85, 93, 85, 85, 0,
         }},
        {0,
         10,
         369,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 174, 170, 170, 0,
         }},
        {0,
         10,
         370,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         371,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 234, 170, 170, 170, 0,
         }},
        {0,
         10,
         374,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         375,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 186, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         376,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 171, 170, 170, 0,
         }},
        {0,
         10,
         377,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         379,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         380,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 171, 170, 170, 0,
         }},
        {10,
         382,
         387,
         {
                 0, 0, 0, 0, 84, 85, 0, 64, 85, 85, 64, 86, 85, 85, 93, 85, 85, 0,
         }},
        {0,
         10,
         383,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 234, 170, 170, 0,
         }},
        {0,
         10,
         384,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 170, 186, 0,
         }},
        {0,
         10,
         385,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         386,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 171, 170, 170, 0,
         }},
        {0,
         10,
         388,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 186, 170, 170, 170, 0,
         }},
        {0,
         10,
         389,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 171, 170, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         390,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 170, 170, 174, 170, 0,
         }},
        {0,
         10,
         391,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         392,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 186, 170, 170, 170, 0,
         }},
        {0,
         10,
         394,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 234, 170, 170, 170, 170, 0,
         }},
        {0,
         10,
         395,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 171, 170, 170, 170, 0,
         }},
        {0,
         10,
         396,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 170, 186, 170, 170, 170, 0,
         }},
        {0,
         10,
         397,
         {
                 0, 0, 0, 0, 168, 170, 0, 128, 170, 170, 128, 170, 171, 170, 170, 170, 170, 0,
         }},
        {0,
         400,
         401,
         {
                 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12,
         }},
};
static constexpr IndexEntry kIndices[] = {
        {0, 0},   {1, 0},   {2, 0},   {2, 0},   {0, 0},   {2, 1},   {0, 0},   {2, 2},   {2, 3},
        {2, 4},   {2, 5},   {2, 6},   {2, 7},   {2, 5},   {2, 8},   {0, 0},   {2, 9},   {0, 0},
        {0, 0},   {0, 0},   {0, 0},   {2, 10},  {0, 0},   {2, 11},  {0, 0},   {0, 0},   {0, 0},
        {2, 12},  {0, 0},   {0, 0},   {2, 13},  {2, 14},  {2, 15},  {2, 16},  {2, 16},  {2, 17},
        {2, 18},  {2, 19},  {0, 0},   {2, 20},  {0, 0},   {1, 1},   {2, 21},  {2, 22},  {2, 23},
        {2, 24},  {2, 24},  {2, 25},  {2, 26},  {2, 26},  {1, 2},   {1, 3},   {2, 27},  {2, 28},
        {2, 28},  {0, 0},   {0, 0},   {0, 0},   {2, 29},  {2, 30},  {1, 4},   {1, 4},   {0, 0},
        {0, 0},   {2, 31},  {2, 32},  {0, 0},   {0, 0},   {2, 33},  {0, 0},   {2, 34},  {0, 0},
        {2, 35},  {0, 0},   {0, 0},   {2, 36},  {2, 37},  {0, 0},   {2, 38},  {2, 39},  {2, 40},
        {2, 41},  {2, 42},  {0, 0},   {2, 5},   {0, 0},   {0, 0},   {2, 43},  {0, 0},   {0, 0},
        {2, 44},  {2, 45},  {2, 5},   {2, 46},  {2, 47},  {2, 48},  {2, 49},  {2, 50},  {2, 51},
        {2, 52},  {2, 53},  {2, 54},  {2, 55},  {2, 56},  {2, 5},   {1, 5},   {2, 57},  {2, 58},
        {2, 5},   {2, 59},  {2, 60},  {2, 61},  {2, 62},  {2, 63},  {2, 64},  {2, 5},   {2, 65},
        {2, 66},  {2, 67},  {2, 68},  {2, 5},   {1, 6},   {2, 69},  {2, 70},  {2, 71},  {2, 72},
        {2, 73},  {2, 5},   {2, 74},  {2, 75},  {2, 76},  {2, 77},  {2, 78},  {2, 5},   {2, 79},
        {2, 80},  {2, 81},  {2, 52},  {2, 82},  {2, 83},  {2, 84},  {1, 7},   {2, 85},  {2, 86},
        {2, 5},   {2, 87},  {2, 45},  {2, 88},  {2, 89},  {2, 90},  {2, 91},  {2, 92},  {2, 93},
        {1, 8},   {2, 94},  {2, 95},  {2, 96},  {2, 5},   {2, 97},  {2, 98},  {2, 99},  {2, 100},
        {2, 101}, {2, 5},   {2, 102}, {2, 5},   {2, 103}, {2, 104}, {2, 84},  {2, 105}, {2, 106},
        {2, 107}, {2, 108}, {2, 109}, {2, 110}, {2, 111}, {2, 112}, {2, 113}, {2, 5},   {2, 114},
        {2, 115}, {2, 84},  {2, 116}, {2, 5},   {1, 9},   {2, 117}, {2, 118}, {2, 119}, {2, 5},
        {2, 120}, {2, 121}, {2, 5},   {2, 122}, {2, 123}, {2, 124}, {2, 125}, {2, 126}, {2, 127},
        {2, 128}, {2, 52},  {2, 129}, {2, 130}, {2, 131}, {2, 132}, {2, 133}, {2, 123}, {2, 134},
        {2, 135}, {2, 136}, {2, 137}, {2, 138}, {2, 5},   {2, 139}, {2, 140}, {2, 141}, {2, 5},
        {2, 142}, {2, 143}, {2, 144}, {2, 145}, {2, 146}, {2, 147}, {2, 5},   {2, 148}, {2, 149},
        {2, 150}, {2, 151}, {2, 152}, {2, 153}, {2, 154}, {2, 52},  {2, 155}, {2, 156}, {2, 157},
        {2, 158}, {2, 159}, {2, 160}, {2, 5},   {2, 161}, {2, 162}, {2, 163}, {2, 164}, {2, 165},
        {2, 166}, {2, 167}, {2, 168}, {2, 169}, {2, 170}, {2, 5},   {2, 171}, {2, 172}, {2, 173},
        {2, 174}, {2, 123}, {1, 10},  {2, 175}, {2, 176}, {2, 177}, {2, 99},  {2, 178}, {2, 179},
        {2, 180}, {2, 181}, {2, 182}, {2, 183}, {2, 184}, {2, 185}, {2, 186}, {2, 187}, {2, 188},
        {2, 189}, {2, 190}, {2, 191}, {2, 192}, {2, 193}, {2, 5},   {1, 11},  {2, 194}, {2, 195},
        {2, 196}, {2, 197}, {2, 198}, {1, 12},  {2, 199}, {2, 200}, {2, 201}, {2, 202}, {2, 203},
        {2, 204}, {2, 205}, {2, 206}, {2, 207}, {2, 208}, {2, 209}, {2, 210}, {2, 211}, {2, 212},
        {2, 213}, {2, 214}, {2, 215}, {2, 205}, {2, 216}, {2, 217}, {2, 218}, {2, 219}, {2, 123},
        {2, 220}, {2, 221}, {2, 52},  {2, 222}, {2, 223}, {2, 224}, {2, 225}, {2, 226}, {2, 227},
        {2, 228}, {2, 229}, {2, 230}, {2, 231}, {2, 232}, {2, 233}, {2, 234}, {2, 235}, {2, 236},
        {2, 237}, {2, 238}, {2, 239}, {2, 240}, {2, 241}, {2, 242}, {2, 5},   {2, 243}, {2, 244},
        {2, 245}, {2, 188}, {2, 246}, {2, 247}, {2, 248}, {2, 5},   {2, 249}, {2, 250}, {2, 251},
        {2, 252}, {2, 253}, {2, 254}, {2, 255}, {2, 256}, {2, 5},   {1, 13},  {2, 257}, {2, 258},
        {2, 259}, {2, 260}, {2, 261}, {2, 52},  {2, 262}, {2, 61},  {2, 263}, {2, 264}, {2, 5},
        {2, 265}, {2, 266}, {2, 267}, {2, 268}, {2, 225}, {2, 269}, {2, 270}, {2, 271}, {2, 272},
        {2, 273}, {2, 274}, {2, 5},   {2, 184}, {2, 275}, {2, 276}, {2, 277}, {2, 278}, {2, 99},
        {2, 279}, {2, 280}, {2, 140}, {2, 281}, {2, 282}, {2, 283}, {2, 284}, {2, 285}, {2, 140},
        {2, 286}, {2, 287}, {2, 288}, {2, 289}, {2, 290}, {2, 52},  {2, 291}, {2, 292}, {2, 293},
        {2, 294}, {2, 5},   {0, 0},   {2, 295}, {0, 0},   {0, 0},   {0, 0},   {0, 0},
};
State get_transition(int transition, int state) {
    IndexEntry index = kIndices[state];
    if (index.type == 0) {
        return 0;
    }
    if (index.type == 1) {
        return kFull[index.pos].data[transition];
    }
    const CompactEntry& entry = kCompact[index.pos];
    int value = entry.data[transition >> 2];
    value >>= 2 * (transition & 3);
    value &= 3;
    State table[] = {0, entry.v0, entry.v1, entry.v2};
    return table[value];
}
static const int8_t kAccepts[404] = {
        -1, -1, 84, 84, 87, 63, 68, 87, 38, 37, 37, 37, 37, 35, 53, 77, 58, 62, 82, 39, 40, 51, 75,
        49, 47, 73, 46, 50, 48, 74, 45, 1,  -1, -1, 1,  52, -1, -1, 86, 85, 76, 2,  1,  1,  -1, -1,
        1,  -1, -1, 1,  2,  3,  -1, -1, 1,  3,  2,  2,  -1, 2,  2,  2,  65, 83, 70, 54, 78, 72, 66,
        67, 69, 71, 55, 79, 64, 87, -1, 7,  -1, -1, -1, -1, -1, 13, 37, 43, 44, 57, 81, 61, 37, 37,
        36, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 16, 37, 37, 37, 14, 37, 37, 37, 37, 37, 37,
        24, 37, 37, 37, 37, 17, 37, 37, 37, 37, 37, 37, 15, 37, 37, 37, 37, 37, 18, 11, 37, 37, 37,
        37, 37, 37, 37, 37, 37, 8,  37, 37, 37, 37, 37, 37, 36, 37, 37, 37, 37, 37, 5,  37, 37, 37,
        37, 37, 25, 37, 9,  37, 37, 37, 37, 37, 36, 37, 37, 37, 37, 37, 37, 32, 37, 37, 37, 37, 6,
        20, 37, 37, 37, 27, 37, 37, 22, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
        37, 37, 37, 37, 31, 37, 37, 37, 34, 37, 37, 37, 37, 37, 37, 33, 37, 37, 37, 37, 37, 37, 37,
        37, 37, 37, 37, 37, 37, 37, 28, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 26, 37, 37, 21, 37,
        37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 19,
        37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
        37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
        37, 37, 37, 37, 37, 37, 37, 37, 29, 37, 37, 37, 37, 37, 37, 37, 30, 37, 37, 37, 37, 37, 37,
        37, 37, 12, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 4,  37, 37, 37, 37, 37, 37, 37, 37,
        37, 37, 37, 23, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
        37, 37, 37, 37, 37, 37, 10, 41, 56, 80, 60, 42, 59,
};

Token Lexer::next() {
    // note that we cheat here: normally a lexer needs to worry about the case
    // where a token has a prefix which is not itself a valid token - for instance,
    // maybe we have a valid token 'while', but 'w', 'wh', etc. are not valid
    // tokens. Our grammar doesn't have this property, so we can simplify the logic
    // a bit.
    int32_t startOffset = fOffset;
    if (startOffset == (int32_t)fText.length()) {
        return Token(Token::Kind::TK_END_OF_FILE, startOffset, 0);
    }
    State state = 1;
    for (;;) {
        if (fOffset >= (int32_t)fText.length()) {
            if (kAccepts[state] == -1) {
                return Token(Token::Kind::TK_END_OF_FILE, startOffset, 0);
            }
            break;
        }
        uint8_t c = (uint8_t)fText[fOffset];
        if (c <= 8 || c >= 127) {
            c = INVALID_CHAR;
        }
        State newState = get_transition(kMappings[c], state);
        if (!newState) {
            break;
        }
        state = newState;
        ++fOffset;
    }
    Token::Kind kind = (Token::Kind)kAccepts[state];
    return Token(kind, startOffset, fOffset - startOffset);
}

}  // namespace SkSL
