use strict;
use warnings;

use RT::Test tests => undef;

my ($ticket, $ok, $msg);

note "Ticket Subject: in templates";
for my $sep ("\n", "\r\n", "\r") {
    # Create evil ticket subject
    $ticket     = RT::Ticket->new( RT->SystemUser );
    ($ok, $msg) = $ticket->Create(
        Queue       => 1,
        Subject     => "test ticket".$sep."Evil: yes",
        Requestor   => 'foo@example.com',  # provide any recipient just to generate a mail
    );
    ok $ticket->id, "Created ticket: $msg";
    unlike $ticket->Subject, qr/\n/, "Newline didn't make it into ticket subject";

    # ... sends an email
    my @email = RT::Test->fetch_caught_mails;
    is @email, 1, "Caught one email";

    ok open(my $fh, "<", \$email[0]), "Opened email"
        or diag $!;

    my $head = MIME::Head->read($fh);
    ok !$head->get("Evil"), "No Evil header"
        or diag explain $email[0];
}

done_testing;
