// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/gaming/v1beta/common.proto

package gaming

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type OperationStatus_ErrorCode int32

const (
	OperationStatus_ERROR_CODE_UNSPECIFIED OperationStatus_ErrorCode = 0
	OperationStatus_INTERNAL_ERROR         OperationStatus_ErrorCode = 1
	OperationStatus_PERMISSION_DENIED      OperationStatus_ErrorCode = 2
	OperationStatus_CLUSTER_CONNECTION     OperationStatus_ErrorCode = 3
)

var OperationStatus_ErrorCode_name = map[int32]string{
	0: "ERROR_CODE_UNSPECIFIED",
	1: "INTERNAL_ERROR",
	2: "PERMISSION_DENIED",
	3: "CLUSTER_CONNECTION",
}

var OperationStatus_ErrorCode_value = map[string]int32{
	"ERROR_CODE_UNSPECIFIED": 0,
	"INTERNAL_ERROR":         1,
	"PERMISSION_DENIED":      2,
	"CLUSTER_CONNECTION":     3,
}

func (x OperationStatus_ErrorCode) String() string {
	return proto.EnumName(OperationStatus_ErrorCode_name, int32(x))
}

func (OperationStatus_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{1, 0}
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// Output only. The time the operation was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	// Output only. List of Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,8,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
	// Output only. Operation status for gameservices API operations. Operation status is in
	// the form of key-value pairs where keys are resource IDs and the values show
	// the status of the operation. In case of failures, the value includes an
	// error code and error message.
	OperationStatus      map[string]*OperationStatus `protobuf:"bytes,9,rep,name=operation_status,json=operationStatus,proto3" json:"operation_status,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *OperationMetadata) Reset()         { *m = OperationMetadata{} }
func (m *OperationMetadata) String() string { return proto.CompactTextString(m) }
func (*OperationMetadata) ProtoMessage()    {}
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{0}
}

func (m *OperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationMetadata.Unmarshal(m, b)
}
func (m *OperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationMetadata.Marshal(b, m, deterministic)
}
func (m *OperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationMetadata.Merge(m, src)
}
func (m *OperationMetadata) XXX_Size() int {
	return xxx_messageInfo_OperationMetadata.Size(m)
}
func (m *OperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_OperationMetadata proto.InternalMessageInfo

func (m *OperationMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *OperationMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *OperationMetadata) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

func (m *OperationMetadata) GetVerb() string {
	if m != nil {
		return m.Verb
	}
	return ""
}

func (m *OperationMetadata) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *OperationMetadata) GetRequestedCancellation() bool {
	if m != nil {
		return m.RequestedCancellation
	}
	return false
}

func (m *OperationMetadata) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

func (m *OperationMetadata) GetUnreachable() []string {
	if m != nil {
		return m.Unreachable
	}
	return nil
}

func (m *OperationMetadata) GetOperationStatus() map[string]*OperationStatus {
	if m != nil {
		return m.OperationStatus
	}
	return nil
}

type OperationStatus struct {
	// Output only. Whether the operation is done or still in progress.
	Done bool `protobuf:"varint,1,opt,name=done,proto3" json:"done,omitempty"`
	// The error code in case of failures.
	ErrorCode OperationStatus_ErrorCode `protobuf:"varint,2,opt,name=error_code,json=errorCode,proto3,enum=google.cloud.gaming.v1beta.OperationStatus_ErrorCode" json:"error_code,omitempty"`
	// The human-readable error message.
	ErrorMessage         string   `protobuf:"bytes,3,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OperationStatus) Reset()         { *m = OperationStatus{} }
func (m *OperationStatus) String() string { return proto.CompactTextString(m) }
func (*OperationStatus) ProtoMessage()    {}
func (*OperationStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{1}
}

func (m *OperationStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationStatus.Unmarshal(m, b)
}
func (m *OperationStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationStatus.Marshal(b, m, deterministic)
}
func (m *OperationStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationStatus.Merge(m, src)
}
func (m *OperationStatus) XXX_Size() int {
	return xxx_messageInfo_OperationStatus.Size(m)
}
func (m *OperationStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationStatus.DiscardUnknown(m)
}

var xxx_messageInfo_OperationStatus proto.InternalMessageInfo

func (m *OperationStatus) GetDone() bool {
	if m != nil {
		return m.Done
	}
	return false
}

func (m *OperationStatus) GetErrorCode() OperationStatus_ErrorCode {
	if m != nil {
		return m.ErrorCode
	}
	return OperationStatus_ERROR_CODE_UNSPECIFIED
}

func (m *OperationStatus) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

// The label selector, used to group labels on the resources.
type LabelSelector struct {
	// Resource labels for this selector.
	Labels               map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LabelSelector) Reset()         { *m = LabelSelector{} }
func (m *LabelSelector) String() string { return proto.CompactTextString(m) }
func (*LabelSelector) ProtoMessage()    {}
func (*LabelSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{2}
}

func (m *LabelSelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSelector.Unmarshal(m, b)
}
func (m *LabelSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSelector.Marshal(b, m, deterministic)
}
func (m *LabelSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSelector.Merge(m, src)
}
func (m *LabelSelector) XXX_Size() int {
	return xxx_messageInfo_LabelSelector.Size(m)
}
func (m *LabelSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSelector.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSelector proto.InternalMessageInfo

func (m *LabelSelector) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// The Realm selector, used to match Realm resources.
type RealmSelector struct {
	// List of Realms to match.
	Realms               []string `protobuf:"bytes,1,rep,name=realms,proto3" json:"realms,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RealmSelector) Reset()         { *m = RealmSelector{} }
func (m *RealmSelector) String() string { return proto.CompactTextString(m) }
func (*RealmSelector) ProtoMessage()    {}
func (*RealmSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{3}
}

func (m *RealmSelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RealmSelector.Unmarshal(m, b)
}
func (m *RealmSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RealmSelector.Marshal(b, m, deterministic)
}
func (m *RealmSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RealmSelector.Merge(m, src)
}
func (m *RealmSelector) XXX_Size() int {
	return xxx_messageInfo_RealmSelector.Size(m)
}
func (m *RealmSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_RealmSelector.DiscardUnknown(m)
}

var xxx_messageInfo_RealmSelector proto.InternalMessageInfo

func (m *RealmSelector) GetRealms() []string {
	if m != nil {
		return m.Realms
	}
	return nil
}

// The schedule of a recurring or one time event. The event's time span is
// specified by start_time and end_time. If the scheduled event's timespan is
// larger than the cron_spec + cron_job_duration, the event will be recurring.
// If only cron_spec + cron_job_duration are specified, the event is effective
// starting at the local time specified by cron_spec, and is recurring.
//
//   start_time|-------[cron job]-------[cron job]-------[cron job]---|end_time
//   cron job: cron spec start time + duration
type Schedule struct {
	// The start time of the event.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time of the event.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The duration for the cron job event. The duration of the event is effective
	// after the cron job's start time.
	CronJobDuration *duration.Duration `protobuf:"bytes,3,opt,name=cron_job_duration,json=cronJobDuration,proto3" json:"cron_job_duration,omitempty"`
	// The cron definition of the scheduled event. See
	// https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as
	// defined by the Realm.
	CronSpec             string   `protobuf:"bytes,4,opt,name=cron_spec,json=cronSpec,proto3" json:"cron_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Schedule) Reset()         { *m = Schedule{} }
func (m *Schedule) String() string { return proto.CompactTextString(m) }
func (*Schedule) ProtoMessage()    {}
func (*Schedule) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{4}
}

func (m *Schedule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Schedule.Unmarshal(m, b)
}
func (m *Schedule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Schedule.Marshal(b, m, deterministic)
}
func (m *Schedule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Schedule.Merge(m, src)
}
func (m *Schedule) XXX_Size() int {
	return xxx_messageInfo_Schedule.Size(m)
}
func (m *Schedule) XXX_DiscardUnknown() {
	xxx_messageInfo_Schedule.DiscardUnknown(m)
}

var xxx_messageInfo_Schedule proto.InternalMessageInfo

func (m *Schedule) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Schedule) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *Schedule) GetCronJobDuration() *duration.Duration {
	if m != nil {
		return m.CronJobDuration
	}
	return nil
}

func (m *Schedule) GetCronSpec() string {
	if m != nil {
		return m.CronSpec
	}
	return ""
}

// Encapsulates Agones fleet spec and Agones autoscaler spec sources.
type SpecSource struct {
	// The Game Server Config resource. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment_id}/configs/{config_id}`.
	GameServerConfigName string `protobuf:"bytes,1,opt,name=game_server_config_name,json=gameServerConfigName,proto3" json:"game_server_config_name,omitempty"`
	// The name of the Agones leet config or Agones scaling config used to derive
	// the Agones fleet or Agones autoscaler spec.
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpecSource) Reset()         { *m = SpecSource{} }
func (m *SpecSource) String() string { return proto.CompactTextString(m) }
func (*SpecSource) ProtoMessage()    {}
func (*SpecSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{5}
}

func (m *SpecSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpecSource.Unmarshal(m, b)
}
func (m *SpecSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpecSource.Marshal(b, m, deterministic)
}
func (m *SpecSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpecSource.Merge(m, src)
}
func (m *SpecSource) XXX_Size() int {
	return xxx_messageInfo_SpecSource.Size(m)
}
func (m *SpecSource) XXX_DiscardUnknown() {
	xxx_messageInfo_SpecSource.DiscardUnknown(m)
}

var xxx_messageInfo_SpecSource proto.InternalMessageInfo

func (m *SpecSource) GetGameServerConfigName() string {
	if m != nil {
		return m.GameServerConfigName
	}
	return ""
}

func (m *SpecSource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Details about the Agones resources.
type TargetDetails struct {
	// The Game Server Cluster name. Uses the form:
	//
	// `projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}`.
	GameServerClusterName string `protobuf:"bytes,1,opt,name=game_server_cluster_name,json=gameServerClusterName,proto3" json:"game_server_cluster_name,omitempty"`
	// The Game Server Deployment name. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment_id}`.
	GameServerDeploymentName string `protobuf:"bytes,2,opt,name=game_server_deployment_name,json=gameServerDeploymentName,proto3" json:"game_server_deployment_name,omitempty"`
	// Agones fleet details for Game Server Clusters and Game Server Deployments.
	FleetDetails         []*TargetDetails_TargetFleetDetails `protobuf:"bytes,3,rep,name=fleet_details,json=fleetDetails,proto3" json:"fleet_details,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *TargetDetails) Reset()         { *m = TargetDetails{} }
func (m *TargetDetails) String() string { return proto.CompactTextString(m) }
func (*TargetDetails) ProtoMessage()    {}
func (*TargetDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{6}
}

func (m *TargetDetails) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TargetDetails.Unmarshal(m, b)
}
func (m *TargetDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TargetDetails.Marshal(b, m, deterministic)
}
func (m *TargetDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetDetails.Merge(m, src)
}
func (m *TargetDetails) XXX_Size() int {
	return xxx_messageInfo_TargetDetails.Size(m)
}
func (m *TargetDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetDetails.DiscardUnknown(m)
}

var xxx_messageInfo_TargetDetails proto.InternalMessageInfo

func (m *TargetDetails) GetGameServerClusterName() string {
	if m != nil {
		return m.GameServerClusterName
	}
	return ""
}

func (m *TargetDetails) GetGameServerDeploymentName() string {
	if m != nil {
		return m.GameServerDeploymentName
	}
	return ""
}

func (m *TargetDetails) GetFleetDetails() []*TargetDetails_TargetFleetDetails {
	if m != nil {
		return m.FleetDetails
	}
	return nil
}

// Details of the target Agones fleet.
type TargetDetails_TargetFleetDetails struct {
	// Reference to target Agones fleet.
	Fleet *TargetDetails_TargetFleetDetails_TargetFleet `protobuf:"bytes,1,opt,name=fleet,proto3" json:"fleet,omitempty"`
	// Reference to target Agones fleet autoscaling policy.
	Autoscaler           *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler `protobuf:"bytes,2,opt,name=autoscaler,proto3" json:"autoscaler,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                `json:"-"`
	XXX_unrecognized     []byte                                                  `json:"-"`
	XXX_sizecache        int32                                                   `json:"-"`
}

func (m *TargetDetails_TargetFleetDetails) Reset()         { *m = TargetDetails_TargetFleetDetails{} }
func (m *TargetDetails_TargetFleetDetails) String() string { return proto.CompactTextString(m) }
func (*TargetDetails_TargetFleetDetails) ProtoMessage()    {}
func (*TargetDetails_TargetFleetDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{6, 0}
}

func (m *TargetDetails_TargetFleetDetails) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TargetDetails_TargetFleetDetails.Unmarshal(m, b)
}
func (m *TargetDetails_TargetFleetDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TargetDetails_TargetFleetDetails.Marshal(b, m, deterministic)
}
func (m *TargetDetails_TargetFleetDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetDetails_TargetFleetDetails.Merge(m, src)
}
func (m *TargetDetails_TargetFleetDetails) XXX_Size() int {
	return xxx_messageInfo_TargetDetails_TargetFleetDetails.Size(m)
}
func (m *TargetDetails_TargetFleetDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetDetails_TargetFleetDetails.DiscardUnknown(m)
}

var xxx_messageInfo_TargetDetails_TargetFleetDetails proto.InternalMessageInfo

func (m *TargetDetails_TargetFleetDetails) GetFleet() *TargetDetails_TargetFleetDetails_TargetFleet {
	if m != nil {
		return m.Fleet
	}
	return nil
}

func (m *TargetDetails_TargetFleetDetails) GetAutoscaler() *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler {
	if m != nil {
		return m.Autoscaler
	}
	return nil
}

// Target Agones fleet specification.
type TargetDetails_TargetFleetDetails_TargetFleet struct {
	// The name of the Agones fleet.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Encapsulates the source of the Agones fleet spec.
	// The Agones fleet spec source.
	SpecSource           *SpecSource `protobuf:"bytes,2,opt,name=spec_source,json=specSource,proto3" json:"spec_source,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *TargetDetails_TargetFleetDetails_TargetFleet) Reset() {
	*m = TargetDetails_TargetFleetDetails_TargetFleet{}
}
func (m *TargetDetails_TargetFleetDetails_TargetFleet) String() string {
	return proto.CompactTextString(m)
}
func (*TargetDetails_TargetFleetDetails_TargetFleet) ProtoMessage() {}
func (*TargetDetails_TargetFleetDetails_TargetFleet) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{6, 0, 0}
}

func (m *TargetDetails_TargetFleetDetails_TargetFleet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TargetDetails_TargetFleetDetails_TargetFleet.Unmarshal(m, b)
}
func (m *TargetDetails_TargetFleetDetails_TargetFleet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TargetDetails_TargetFleetDetails_TargetFleet.Marshal(b, m, deterministic)
}
func (m *TargetDetails_TargetFleetDetails_TargetFleet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetDetails_TargetFleetDetails_TargetFleet.Merge(m, src)
}
func (m *TargetDetails_TargetFleetDetails_TargetFleet) XXX_Size() int {
	return xxx_messageInfo_TargetDetails_TargetFleetDetails_TargetFleet.Size(m)
}
func (m *TargetDetails_TargetFleetDetails_TargetFleet) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetDetails_TargetFleetDetails_TargetFleet.DiscardUnknown(m)
}

var xxx_messageInfo_TargetDetails_TargetFleetDetails_TargetFleet proto.InternalMessageInfo

func (m *TargetDetails_TargetFleetDetails_TargetFleet) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TargetDetails_TargetFleetDetails_TargetFleet) GetSpecSource() *SpecSource {
	if m != nil {
		return m.SpecSource
	}
	return nil
}

// Target Agones autoscaler policy reference.
type TargetDetails_TargetFleetDetails_TargetFleetAutoscaler struct {
	// The name of the Agones autoscaler.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Encapsulates the source of the Agones fleet spec.
	// Details about the Agones autoscaler spec.
	SpecSource           *SpecSource `protobuf:"bytes,2,opt,name=spec_source,json=specSource,proto3" json:"spec_source,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) Reset() {
	*m = TargetDetails_TargetFleetDetails_TargetFleetAutoscaler{}
}
func (m *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) String() string {
	return proto.CompactTextString(m)
}
func (*TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) ProtoMessage() {}
func (*TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{6, 0, 1}
}

func (m *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TargetDetails_TargetFleetDetails_TargetFleetAutoscaler.Unmarshal(m, b)
}
func (m *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TargetDetails_TargetFleetDetails_TargetFleetAutoscaler.Marshal(b, m, deterministic)
}
func (m *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetDetails_TargetFleetDetails_TargetFleetAutoscaler.Merge(m, src)
}
func (m *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) XXX_Size() int {
	return xxx_messageInfo_TargetDetails_TargetFleetDetails_TargetFleetAutoscaler.Size(m)
}
func (m *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetDetails_TargetFleetDetails_TargetFleetAutoscaler.DiscardUnknown(m)
}

var xxx_messageInfo_TargetDetails_TargetFleetDetails_TargetFleetAutoscaler proto.InternalMessageInfo

func (m *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) GetSpecSource() *SpecSource {
	if m != nil {
		return m.SpecSource
	}
	return nil
}

// Encapsulates the Target state.
type TargetState struct {
	// Details about Agones fleets.
	Details              []*TargetDetails `protobuf:"bytes,1,rep,name=details,proto3" json:"details,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *TargetState) Reset()         { *m = TargetState{} }
func (m *TargetState) String() string { return proto.CompactTextString(m) }
func (*TargetState) ProtoMessage()    {}
func (*TargetState) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{7}
}

func (m *TargetState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TargetState.Unmarshal(m, b)
}
func (m *TargetState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TargetState.Marshal(b, m, deterministic)
}
func (m *TargetState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetState.Merge(m, src)
}
func (m *TargetState) XXX_Size() int {
	return xxx_messageInfo_TargetState.Size(m)
}
func (m *TargetState) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetState.DiscardUnknown(m)
}

var xxx_messageInfo_TargetState proto.InternalMessageInfo

func (m *TargetState) GetDetails() []*TargetDetails {
	if m != nil {
		return m.Details
	}
	return nil
}

// Details of the deployed Agones fleet.
type DeployedFleetDetails struct {
	// Information about the Agones fleet.
	DeployedFleet *DeployedFleetDetails_DeployedFleet `protobuf:"bytes,1,opt,name=deployed_fleet,json=deployedFleet,proto3" json:"deployed_fleet,omitempty"`
	// Information about the Agones autoscaler for that fleet.
	DeployedAutoscaler   *DeployedFleetDetails_DeployedFleetAutoscaler `protobuf:"bytes,2,opt,name=deployed_autoscaler,json=deployedAutoscaler,proto3" json:"deployed_autoscaler,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                      `json:"-"`
	XXX_unrecognized     []byte                                        `json:"-"`
	XXX_sizecache        int32                                         `json:"-"`
}

func (m *DeployedFleetDetails) Reset()         { *m = DeployedFleetDetails{} }
func (m *DeployedFleetDetails) String() string { return proto.CompactTextString(m) }
func (*DeployedFleetDetails) ProtoMessage()    {}
func (*DeployedFleetDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{8}
}

func (m *DeployedFleetDetails) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployedFleetDetails.Unmarshal(m, b)
}
func (m *DeployedFleetDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployedFleetDetails.Marshal(b, m, deterministic)
}
func (m *DeployedFleetDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployedFleetDetails.Merge(m, src)
}
func (m *DeployedFleetDetails) XXX_Size() int {
	return xxx_messageInfo_DeployedFleetDetails.Size(m)
}
func (m *DeployedFleetDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployedFleetDetails.DiscardUnknown(m)
}

var xxx_messageInfo_DeployedFleetDetails proto.InternalMessageInfo

func (m *DeployedFleetDetails) GetDeployedFleet() *DeployedFleetDetails_DeployedFleet {
	if m != nil {
		return m.DeployedFleet
	}
	return nil
}

func (m *DeployedFleetDetails) GetDeployedAutoscaler() *DeployedFleetDetails_DeployedFleetAutoscaler {
	if m != nil {
		return m.DeployedAutoscaler
	}
	return nil
}

// Agones fleet specification and details.
type DeployedFleetDetails_DeployedFleet struct {
	// The name of the Agones fleet.
	Fleet string `protobuf:"bytes,1,opt,name=fleet,proto3" json:"fleet,omitempty"`
	// The fleet spec retrieved from the Agones fleet.
	FleetSpec string `protobuf:"bytes,2,opt,name=fleet_spec,json=fleetSpec,proto3" json:"fleet_spec,omitempty"`
	// The source spec that is used to create the Agones fleet.
	// The GameServerConfig resource may no longer exist in the system.
	SpecSource *SpecSource `protobuf:"bytes,3,opt,name=spec_source,json=specSource,proto3" json:"spec_source,omitempty"`
	// The current status of the Agones fleet.
	// Includes count of game servers in various states.
	Status               *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus `protobuf:"bytes,5,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                `json:"-"`
	XXX_unrecognized     []byte                                                  `json:"-"`
	XXX_sizecache        int32                                                   `json:"-"`
}

func (m *DeployedFleetDetails_DeployedFleet) Reset()         { *m = DeployedFleetDetails_DeployedFleet{} }
func (m *DeployedFleetDetails_DeployedFleet) String() string { return proto.CompactTextString(m) }
func (*DeployedFleetDetails_DeployedFleet) ProtoMessage()    {}
func (*DeployedFleetDetails_DeployedFleet) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{8, 0}
}

func (m *DeployedFleetDetails_DeployedFleet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployedFleetDetails_DeployedFleet.Unmarshal(m, b)
}
func (m *DeployedFleetDetails_DeployedFleet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployedFleetDetails_DeployedFleet.Marshal(b, m, deterministic)
}
func (m *DeployedFleetDetails_DeployedFleet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployedFleetDetails_DeployedFleet.Merge(m, src)
}
func (m *DeployedFleetDetails_DeployedFleet) XXX_Size() int {
	return xxx_messageInfo_DeployedFleetDetails_DeployedFleet.Size(m)
}
func (m *DeployedFleetDetails_DeployedFleet) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployedFleetDetails_DeployedFleet.DiscardUnknown(m)
}

var xxx_messageInfo_DeployedFleetDetails_DeployedFleet proto.InternalMessageInfo

func (m *DeployedFleetDetails_DeployedFleet) GetFleet() string {
	if m != nil {
		return m.Fleet
	}
	return ""
}

func (m *DeployedFleetDetails_DeployedFleet) GetFleetSpec() string {
	if m != nil {
		return m.FleetSpec
	}
	return ""
}

func (m *DeployedFleetDetails_DeployedFleet) GetSpecSource() *SpecSource {
	if m != nil {
		return m.SpecSource
	}
	return nil
}

func (m *DeployedFleetDetails_DeployedFleet) GetStatus() *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// DeployedFleetStatus has details about the Agones fleets such as how many
// are running, how many allocated, and so on.
type DeployedFleetDetails_DeployedFleet_DeployedFleetStatus struct {
	// The number of GameServer replicas in the READY state in this fleet.
	ReadyReplicas int64 `protobuf:"varint,1,opt,name=ready_replicas,json=readyReplicas,proto3" json:"ready_replicas,omitempty"`
	// The number of GameServer replicas in the ALLOCATED state in this fleet.
	AllocatedReplicas int64 `protobuf:"varint,2,opt,name=allocated_replicas,json=allocatedReplicas,proto3" json:"allocated_replicas,omitempty"`
	// The number of GameServer replicas in the RESERVED state in this fleet.
	// Reserved instances won't be deleted on scale down, but won't cause
	// an autoscaler to scale up.
	ReservedReplicas int64 `protobuf:"varint,3,opt,name=reserved_replicas,json=reservedReplicas,proto3" json:"reserved_replicas,omitempty"`
	// The total number of current GameServer replicas in this fleet.
	Replicas             int64    `protobuf:"varint,4,opt,name=replicas,proto3" json:"replicas,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) Reset() {
	*m = DeployedFleetDetails_DeployedFleet_DeployedFleetStatus{}
}
func (m *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) String() string {
	return proto.CompactTextString(m)
}
func (*DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) ProtoMessage() {}
func (*DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{8, 0, 0}
}

func (m *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployedFleetDetails_DeployedFleet_DeployedFleetStatus.Unmarshal(m, b)
}
func (m *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployedFleetDetails_DeployedFleet_DeployedFleetStatus.Marshal(b, m, deterministic)
}
func (m *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployedFleetDetails_DeployedFleet_DeployedFleetStatus.Merge(m, src)
}
func (m *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) XXX_Size() int {
	return xxx_messageInfo_DeployedFleetDetails_DeployedFleet_DeployedFleetStatus.Size(m)
}
func (m *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployedFleetDetails_DeployedFleet_DeployedFleetStatus.DiscardUnknown(m)
}

var xxx_messageInfo_DeployedFleetDetails_DeployedFleet_DeployedFleetStatus proto.InternalMessageInfo

func (m *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) GetReadyReplicas() int64 {
	if m != nil {
		return m.ReadyReplicas
	}
	return 0
}

func (m *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) GetAllocatedReplicas() int64 {
	if m != nil {
		return m.AllocatedReplicas
	}
	return 0
}

func (m *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) GetReservedReplicas() int64 {
	if m != nil {
		return m.ReservedReplicas
	}
	return 0
}

func (m *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) GetReplicas() int64 {
	if m != nil {
		return m.Replicas
	}
	return 0
}

// Details about the Agones autoscaler.
type DeployedFleetDetails_DeployedFleetAutoscaler struct {
	// The name of the Agones autoscaler.
	Autoscaler string `protobuf:"bytes,1,opt,name=autoscaler,proto3" json:"autoscaler,omitempty"`
	// The source spec that is used to create the autoscaler.
	// The GameServerConfig resource may no longer exist in the system.
	SpecSource *SpecSource `protobuf:"bytes,4,opt,name=spec_source,json=specSource,proto3" json:"spec_source,omitempty"`
	// The autoscaler spec retrieved from Agones.
	FleetAutoscalerSpec  string   `protobuf:"bytes,3,opt,name=fleet_autoscaler_spec,json=fleetAutoscalerSpec,proto3" json:"fleet_autoscaler_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeployedFleetDetails_DeployedFleetAutoscaler) Reset() {
	*m = DeployedFleetDetails_DeployedFleetAutoscaler{}
}
func (m *DeployedFleetDetails_DeployedFleetAutoscaler) String() string {
	return proto.CompactTextString(m)
}
func (*DeployedFleetDetails_DeployedFleetAutoscaler) ProtoMessage() {}
func (*DeployedFleetDetails_DeployedFleetAutoscaler) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b2e69f5b15a0cad, []int{8, 1}
}

func (m *DeployedFleetDetails_DeployedFleetAutoscaler) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployedFleetDetails_DeployedFleetAutoscaler.Unmarshal(m, b)
}
func (m *DeployedFleetDetails_DeployedFleetAutoscaler) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployedFleetDetails_DeployedFleetAutoscaler.Marshal(b, m, deterministic)
}
func (m *DeployedFleetDetails_DeployedFleetAutoscaler) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployedFleetDetails_DeployedFleetAutoscaler.Merge(m, src)
}
func (m *DeployedFleetDetails_DeployedFleetAutoscaler) XXX_Size() int {
	return xxx_messageInfo_DeployedFleetDetails_DeployedFleetAutoscaler.Size(m)
}
func (m *DeployedFleetDetails_DeployedFleetAutoscaler) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployedFleetDetails_DeployedFleetAutoscaler.DiscardUnknown(m)
}

var xxx_messageInfo_DeployedFleetDetails_DeployedFleetAutoscaler proto.InternalMessageInfo

func (m *DeployedFleetDetails_DeployedFleetAutoscaler) GetAutoscaler() string {
	if m != nil {
		return m.Autoscaler
	}
	return ""
}

func (m *DeployedFleetDetails_DeployedFleetAutoscaler) GetSpecSource() *SpecSource {
	if m != nil {
		return m.SpecSource
	}
	return nil
}

func (m *DeployedFleetDetails_DeployedFleetAutoscaler) GetFleetAutoscalerSpec() string {
	if m != nil {
		return m.FleetAutoscalerSpec
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.gaming.v1beta.OperationStatus_ErrorCode", OperationStatus_ErrorCode_name, OperationStatus_ErrorCode_value)
	proto.RegisterType((*OperationMetadata)(nil), "google.cloud.gaming.v1beta.OperationMetadata")
	proto.RegisterMapType((map[string]*OperationStatus)(nil), "google.cloud.gaming.v1beta.OperationMetadata.OperationStatusEntry")
	proto.RegisterType((*OperationStatus)(nil), "google.cloud.gaming.v1beta.OperationStatus")
	proto.RegisterType((*LabelSelector)(nil), "google.cloud.gaming.v1beta.LabelSelector")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.gaming.v1beta.LabelSelector.LabelsEntry")
	proto.RegisterType((*RealmSelector)(nil), "google.cloud.gaming.v1beta.RealmSelector")
	proto.RegisterType((*Schedule)(nil), "google.cloud.gaming.v1beta.Schedule")
	proto.RegisterType((*SpecSource)(nil), "google.cloud.gaming.v1beta.SpecSource")
	proto.RegisterType((*TargetDetails)(nil), "google.cloud.gaming.v1beta.TargetDetails")
	proto.RegisterType((*TargetDetails_TargetFleetDetails)(nil), "google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails")
	proto.RegisterType((*TargetDetails_TargetFleetDetails_TargetFleet)(nil), "google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails.TargetFleet")
	proto.RegisterType((*TargetDetails_TargetFleetDetails_TargetFleetAutoscaler)(nil), "google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler")
	proto.RegisterType((*TargetState)(nil), "google.cloud.gaming.v1beta.TargetState")
	proto.RegisterType((*DeployedFleetDetails)(nil), "google.cloud.gaming.v1beta.DeployedFleetDetails")
	proto.RegisterType((*DeployedFleetDetails_DeployedFleet)(nil), "google.cloud.gaming.v1beta.DeployedFleetDetails.DeployedFleet")
	proto.RegisterType((*DeployedFleetDetails_DeployedFleet_DeployedFleetStatus)(nil), "google.cloud.gaming.v1beta.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus")
	proto.RegisterType((*DeployedFleetDetails_DeployedFleetAutoscaler)(nil), "google.cloud.gaming.v1beta.DeployedFleetDetails.DeployedFleetAutoscaler")
}

func init() {
	proto.RegisterFile("google/cloud/gaming/v1beta/common.proto", fileDescriptor_1b2e69f5b15a0cad)
}

var fileDescriptor_1b2e69f5b15a0cad = []byte{
	// 1211 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xdf, 0x72, 0xdb, 0xc4,
	0x17, 0xfe, 0x29, 0x4a, 0xdc, 0xe8, 0xb8, 0x4e, 0x93, 0x6d, 0x92, 0xfa, 0xa7, 0x42, 0xc9, 0x18,
	0x4a, 0x03, 0x1d, 0xec, 0x21, 0x4c, 0x07, 0x5a, 0xfe, 0x4c, 0x53, 0x47, 0xa5, 0x66, 0x1a, 0xa7,
	0xb3, 0x76, 0x61, 0x86, 0x0b, 0x34, 0x6b, 0xe9, 0x58, 0x55, 0x90, 0xb5, 0x66, 0xb5, 0xf6, 0x4c,
	0x1e, 0x83, 0x4b, 0xde, 0x82, 0x0b, 0x06, 0xde, 0x81, 0xa7, 0x28, 0x33, 0x3c, 0x08, 0xa3, 0x5d,
	0x49, 0x96, 0x13, 0x37, 0x4d, 0x5b, 0xb8, 0x8a, 0xf6, 0x3b, 0xdf, 0xf9, 0xce, 0xee, 0x9e, 0x4f,
	0x27, 0x32, 0xdc, 0x0a, 0x38, 0x0f, 0x22, 0x6c, 0x79, 0x11, 0x9f, 0xf8, 0xad, 0x80, 0x8d, 0xc2,
	0x38, 0x68, 0x4d, 0x3f, 0x1e, 0xa0, 0x64, 0x2d, 0x8f, 0x8f, 0x46, 0x3c, 0x6e, 0x8e, 0x05, 0x97,
	0x9c, 0xd8, 0x9a, 0xd8, 0x54, 0xc4, 0xa6, 0x26, 0x36, 0x35, 0xd1, 0x7e, 0x27, 0x13, 0x61, 0xe3,
	0xb0, 0x35, 0x0c, 0x31, 0xf2, 0xdd, 0x01, 0x3e, 0x63, 0xd3, 0x90, 0x0b, 0x9d, 0x6c, 0xdf, 0xc8,
	0x08, 0x6a, 0x35, 0x98, 0x0c, 0x5b, 0xfe, 0x44, 0x30, 0x19, 0xe6, 0xe2, 0x85, 0x40, 0x11, 0x97,
	0xe1, 0x08, 0x13, 0xc9, 0x46, 0xe3, 0x8c, 0xf0, 0x56, 0xa9, 0x02, 0x8b, 0x63, 0x2e, 0x55, 0x76,
	0xa2, 0xa3, 0x8d, 0xbf, 0x96, 0x61, 0xe3, 0x68, 0x8c, 0x5a, 0xf2, 0x10, 0x25, 0xf3, 0x99, 0x64,
	0xe4, 0x3e, 0x54, 0x3d, 0x81, 0x4c, 0xa2, 0x9b, 0xaa, 0xd5, 0x8d, 0x1d, 0x63, 0xb7, 0xba, 0x67,
	0x37, 0xb3, 0x73, 0xe4, 0xa5, 0x9a, 0xfd, 0xbc, 0xd4, 0x03, 0xf3, 0xf9, 0xbe, 0x49, 0x41, 0xe7,
	0xa4, 0x28, 0xb9, 0x07, 0xab, 0x18, 0xfb, 0x3a, 0x7d, 0xe9, 0x62, 0xe9, 0x97, 0x30, 0xf6, 0x55,
	0xee, 0x75, 0xa8, 0x48, 0x26, 0x02, 0x94, 0x75, 0x73, 0xc7, 0xd8, 0xb5, 0x74, 0x34, 0x83, 0xc8,
	0x35, 0x58, 0x9e, 0xa2, 0x18, 0xd4, 0x97, 0x67, 0x21, 0x05, 0x90, 0x0f, 0x61, 0x2d, 0x91, 0x4c,
	0x4e, 0x12, 0x77, 0x84, 0x49, 0xc2, 0x02, 0xac, 0xaf, 0xcc, 0x28, 0x35, 0x1d, 0x3a, 0xd4, 0x11,
	0x72, 0x0f, 0xb6, 0x05, 0xfe, 0x34, 0xc1, 0x44, 0xa2, 0xef, 0x7a, 0x2c, 0xf6, 0x30, 0x8a, 0xd4,
	0x0d, 0xd4, 0x2b, 0x3b, 0xc6, 0xee, 0xaa, 0xce, 0xd9, 0x2a, 0x28, 0xed, 0x12, 0x83, 0xbc, 0x07,
	0x55, 0x36, 0x0e, 0xdd, 0x29, 0x8a, 0x24, 0x4d, 0xb8, 0x34, 0x2b, 0x02, 0x6c, 0x1c, 0x7e, 0xab,
	0x61, 0x72, 0x13, 0xaa, 0x93, 0x58, 0x20, 0xf3, 0x9e, 0xb1, 0x41, 0x84, 0xf5, 0xd5, 0x1d, 0x33,
	0x67, 0x95, 0x71, 0x22, 0x60, 0x9d, 0xe7, 0xb7, 0xef, 0xea, 0x3d, 0xd6, 0xad, 0x1d, 0x73, 0xb7,
	0xba, 0xf7, 0xa0, 0xf9, 0x62, 0xd7, 0x34, 0xcf, 0x74, 0x6c, 0x86, 0xf4, 0x94, 0x88, 0x13, 0x4b,
	0x71, 0xa2, 0xeb, 0x5d, 0xe1, 0xf3, 0x21, 0x9b, 0xc3, 0xe6, 0x22, 0x36, 0x59, 0x07, 0xf3, 0x47,
	0x3c, 0x51, 0xcd, 0xb6, 0x68, 0xfa, 0x48, 0xf6, 0x61, 0x65, 0xca, 0xa2, 0x49, 0xde, 0xc1, 0xdb,
	0x17, 0xda, 0x92, 0x96, 0xa4, 0x3a, 0xf3, 0xde, 0xd2, 0x67, 0x46, 0xe3, 0xe7, 0x25, 0xb8, 0x72,
	0x2a, 0x9c, 0xb6, 0xd1, 0xe7, 0xb1, 0xb6, 0x56, 0x76, 0xdf, 0x0a, 0x20, 0x7d, 0x00, 0x14, 0x82,
	0x0b, 0xd7, 0xe3, 0xbe, 0x2e, 0xbc, 0xb6, 0x77, 0xe7, 0x15, 0x0a, 0x37, 0x9d, 0x34, 0xbb, 0xcd,
	0x7d, 0xa4, 0x16, 0xe6, 0x8f, 0xe4, 0x5d, 0xa8, 0x69, 0xd5, 0xdc, 0x1b, 0xca, 0x59, 0xf4, 0xb2,
	0x02, 0x33, 0x57, 0x34, 0x8e, 0xc1, 0x2a, 0x92, 0x89, 0x0d, 0xdb, 0x0e, 0xa5, 0x47, 0xd4, 0x6d,
	0x1f, 0x1d, 0x38, 0xee, 0xd3, 0x6e, 0xef, 0x89, 0xd3, 0xee, 0x3c, 0xec, 0x38, 0x07, 0xeb, 0xff,
	0x23, 0x04, 0xd6, 0x3a, 0xdd, 0xbe, 0x43, 0xbb, 0xfb, 0x8f, 0x5d, 0x45, 0x5a, 0x37, 0xc8, 0x16,
	0x6c, 0x3c, 0x71, 0xe8, 0x61, 0xa7, 0xd7, 0xeb, 0x1c, 0x75, 0xdd, 0x03, 0xa7, 0x9b, 0x52, 0x97,
	0xc8, 0x36, 0x90, 0xf6, 0xe3, 0xa7, 0xbd, 0xbe, 0x93, 0x0a, 0x75, 0xbb, 0x4e, 0xbb, 0xdf, 0x39,
	0xea, 0xae, 0x9b, 0x8d, 0x5f, 0x0c, 0xa8, 0x3d, 0x66, 0x03, 0x8c, 0x7a, 0x18, 0xa1, 0x27, 0xb9,
	0x20, 0x87, 0x50, 0x89, 0x52, 0x20, 0xa9, 0x1b, 0xca, 0x00, 0xe7, 0x1e, 0x7a, 0x2e, 0x55, 0xaf,
	0x74, 0x17, 0x69, 0x26, 0x62, 0xdf, 0x85, 0x6a, 0x09, 0x5e, 0xd0, 0xdc, 0xcd, 0x72, 0x73, 0xad,
	0x72, 0xbf, 0x6e, 0x41, 0x8d, 0x22, 0x8b, 0x46, 0xc5, 0xd6, 0xb6, 0xa1, 0x22, 0x52, 0x40, 0x6f,
	0xcd, 0xa2, 0xd9, 0xaa, 0xf1, 0xdc, 0x80, 0xd5, 0x9e, 0xf7, 0x0c, 0xfd, 0x49, 0x84, 0xe4, 0x2e,
	0x40, 0x22, 0x99, 0x90, 0x17, 0x1c, 0x19, 0xd4, 0x52, 0x6c, 0xf5, 0xc2, 0xdf, 0x79, 0x95, 0x61,
	0x31, 0x9b, 0x13, 0x0e, 0x6c, 0x78, 0x82, 0xc7, 0xee, 0x31, 0x1f, 0xb8, 0xf9, 0x54, 0x54, 0x8d,
	0xad, 0xee, 0xfd, 0xff, 0x4c, 0xfe, 0x41, 0x46, 0xa0, 0x57, 0xd2, 0x9c, 0x6f, 0xf8, 0x20, 0x07,
	0xc8, 0x75, 0xb0, 0x94, 0x4c, 0x32, 0x46, 0x4f, 0x8f, 0x15, 0xba, 0x9a, 0x02, 0xbd, 0x31, 0x7a,
	0x8d, 0xef, 0x00, 0xd2, 0xbf, 0x3d, 0x3e, 0x11, 0x5e, 0xba, 0xd1, 0x6b, 0x01, 0x1b, 0xa1, 0x9b,
	0xa0, 0x98, 0x62, 0x6a, 0xd1, 0x78, 0x18, 0x06, 0x6e, 0xcc, 0xb2, 0x03, 0x5b, 0x74, 0x33, 0x0d,
	0xf7, 0x54, 0xb4, 0xad, 0x82, 0x5d, 0x36, 0x42, 0x42, 0x60, 0x59, 0x71, 0xf4, 0x4d, 0xab, 0xe7,
	0xc6, 0x1f, 0x2b, 0x50, 0xeb, 0xab, 0x91, 0x76, 0x80, 0x92, 0x85, 0x51, 0x42, 0x3e, 0x85, 0xfa,
	0x9c, 0x78, 0x34, 0x49, 0x24, 0x8a, 0xb2, 0xfa, 0x56, 0x49, 0x5d, 0x47, 0x95, 0xfc, 0x97, 0x70,
	0xbd, 0x9c, 0xe8, 0xe3, 0x38, 0xe2, 0x27, 0x23, 0x8c, 0xa5, 0x5b, 0xaa, 0x5a, 0x9f, 0xe5, 0x1e,
	0x14, 0x04, 0x95, 0xce, 0xa0, 0x36, 0x8c, 0x10, 0xa5, 0xeb, 0xeb, 0x8d, 0xd4, 0x4d, 0xe5, 0xbf,
	0x2f, 0xce, 0xf3, 0xdf, 0xdc, 0xce, 0xb3, 0xd5, 0xc3, 0x54, 0x24, 0x83, 0xe8, 0xe5, 0x61, 0x69,
	0x65, 0xff, 0x69, 0x02, 0x39, 0x4b, 0x22, 0x3f, 0xc0, 0x8a, 0xa2, 0x65, 0x6e, 0x79, 0xf4, 0x26,
	0x15, 0xcb, 0x10, 0xd5, 0xb2, 0x44, 0x00, 0xb0, 0x89, 0xe4, 0x89, 0xc7, 0x22, 0x14, 0x99, 0xb3,
	0xe8, 0xbf, 0x55, 0x64, 0xbf, 0x50, 0xa6, 0xa5, 0x2a, 0xf6, 0x31, 0x54, 0x4b, 0xa4, 0xa2, 0xf5,
	0xc6, 0xac, 0xf5, 0xe4, 0x6b, 0xa8, 0xa6, 0x5e, 0x73, 0x13, 0x65, 0xaa, 0x6c, 0x5f, 0xef, 0x9f,
	0xb7, 0xaf, 0x99, 0x05, 0x29, 0x24, 0xc5, 0xb3, 0x2d, 0x61, 0x6b, 0xe1, 0x86, 0xfe, 0xd3, 0xaa,
	0x0d, 0x9a, 0x9f, 0x30, 0x1d, 0xb8, 0x48, 0xda, 0x70, 0x29, 0x37, 0x8e, 0x1e, 0x5c, 0x1f, 0x5c,
	0xf8, 0x86, 0x69, 0x9e, 0xd9, 0xf8, 0xbb, 0x02, 0x9b, 0xda, 0x96, 0xe8, 0xcf, 0x59, 0x04, 0x61,
	0xcd, 0xcf, 0x70, 0xb7, 0xec, 0x95, 0xaf, 0xce, 0x2b, 0xb2, 0x48, 0x69, 0x1e, 0xa4, 0x35, 0xbf,
	0xbc, 0x24, 0x27, 0x70, 0xb5, 0x28, 0x73, 0xc6, 0x32, 0x8f, 0xde, 0xac, 0x56, 0xc9, 0x28, 0x24,
	0x2f, 0x32, 0xc3, 0xec, 0x5f, 0x4d, 0xa8, 0xcd, 0xf1, 0xd3, 0xc9, 0x3c, 0x3b, 0xaa, 0x95, 0x9b,
	0xf9, 0x6d, 0x00, 0xfd, 0x9a, 0xaa, 0x39, 0xa5, 0x5f, 0x6a, 0x4b, 0x21, 0x69, 0x9f, 0x4e, 0xb7,
	0xd7, 0x7c, 0xdd, 0xf6, 0x92, 0x63, 0xa8, 0x64, 0x1f, 0x22, 0x2b, 0x2f, 0x7f, 0x61, 0x5e, 0x7e,
	0xfa, 0xf9, 0x55, 0xf6, 0x71, 0x90, 0x55, 0xb0, 0x7f, 0x33, 0xe0, 0xea, 0x82, 0x38, 0xb9, 0x09,
	0x6b, 0x02, 0x99, 0x7f, 0xe2, 0x0a, 0x1c, 0x47, 0xa1, 0xc7, 0x12, 0x75, 0x15, 0x26, 0xad, 0x29,
	0x94, 0x66, 0x20, 0xf9, 0x08, 0x08, 0x8b, 0x22, 0xee, 0xb1, 0xf4, 0x33, 0xae, 0xa0, 0x2e, 0x29,
	0xea, 0x46, 0x11, 0x29, 0xe8, 0xb7, 0x61, 0x43, 0xa0, 0x1a, 0x92, 0x25, 0xb6, 0xa9, 0xd8, 0xeb,
	0x79, 0xa0, 0x20, 0xdb, 0xb0, 0x5a, 0x70, 0x96, 0x15, 0xa7, 0x58, 0xdb, 0xbf, 0x1b, 0x70, 0xed,
	0x05, 0x2d, 0x26, 0x37, 0xe6, 0x66, 0x8e, 0xee, 0x60, 0x09, 0x39, 0xdd, 0xa7, 0xe5, 0xd7, 0xee,
	0xd3, 0x1e, 0x6c, 0x69, 0x3f, 0xcc, 0xc4, 0xb5, 0x35, 0xf4, 0xa7, 0xcd, 0xd5, 0xe1, 0xfc, 0xc6,
	0x52, 0x95, 0x07, 0x3e, 0xdc, 0xf0, 0xf8, 0xe8, 0x9c, 0x62, 0x4f, 0x8c, 0xef, 0xef, 0x67, 0xd1,
	0x80, 0x47, 0x2c, 0x0e, 0x9a, 0x5c, 0x04, 0xad, 0x00, 0x63, 0xf5, 0x7f, 0xb4, 0xa5, 0x43, 0x6c,
	0x1c, 0x26, 0x8b, 0x7e, 0xf5, 0x7c, 0xae, 0x57, 0x83, 0x8a, 0x22, 0x7f, 0xf2, 0x4f, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x8e, 0x4d, 0x21, 0xa3, 0x21, 0x0d, 0x00, 0x00,
}
