# AFL++ Examples

Here's a quick overview of the stuff you can find in this directory:

  - aflpp_driver         - easily instrument LLVMFuzzerTestOneInput()
                           harnesses.

  - afl_network_proxy    - fuzz a target over the network: afl-fuzz on
                           a host, target on an embedded system.

  - plot_ui              - simple UI window utility to display the
                           plots generated by afl-plot

  - afl_proxy            - skeleton file example to show how to fuzz
                           something where you gather coverage data via
                           different means, e.g., hw debugger

  - afl_untracer         - fuzz binary-only libraries much faster but with
                           less coverage than QEMU mode

  - analysis_scripts     - random -o out analysis scripts

  - argv_fuzzing         - a simple wrapper to allow cmdline to be fuzzed
                           (e.g., to test setuid programs).

  - asan_cgroups         - a contributed script to simplify fuzzing ASAN
                           binaries with robust memory limits on Linux.

  - autodict_ql          - generate dictionary files from source code.

  - bash_shellshock      - a simple hack used to find a bunch of
                           post-Shellshock bugs in bash.

  - canvas_harness       - a test harness used to find browser bugs with a
                           corpus generated using simple image parsing
                           binaries & afl-fuzz.

  - clang_asm_normalize  - a script that makes it easy to instrument
                           hand-written assembly, provided that you have clang.

  - crash_triage         - a very rudimentary example of how to annotate crashes
                           with additional gdb metadata.

  - custom_mutators      - examples for the AFL++ custom mutator interface in
                           C and Python. Note: They were moved to
                           ../custom_mutators/examples/

  - defork               - intercept fork() in targets

  - distributed_fuzzing  - a sample script for synchronizing fuzzer instances
                           across multiple machines.

  - libdislocator        - like ASAN but lightweight.

  - libtokencap          - collect string tokens for a dictionary.

  - libpng_no_checksum   - a sample patch for removing CRC checks in libpng.

  - mutation_chain       - a tool that backtraces the mutation chain of AFL 
                           crash files based on the crash/queue file naming
                           standards and outputs this in a json format.

  - persistent_mode      - an example of how to use the LLVM persistent process
                           mode to speed up certain fuzzing jobs.

  - qemu_persistent_hook - persistent mode support module for qemu.

  - socket_fuzzing       - a LD_PRELOAD library 'redirects' a socket to stdin
                           for fuzzing access with AFL++

Note that the minimize_corpus.sh tool has graduated from the utils/
directory and is now available as ../afl-cmin. The LLVM mode has likewise
graduated to ../instrumentation/*.

Most of the tools in this directory are meant chiefly as examples that need to
be tweaked for your specific needs. They come with some basic documentation,
but are not necessarily production-grade.
