---
id: Text input
section: components
subsection: forms
cssPrefix: pf-v6-c-form-control
propComponents: ['TextInput', 'TextInputExpandedObj']
---

import { useRef, useState } from 'react';
import CalendarIcon from '@patternfly/react-icons/dist/esm/icons/calendar-icon';
import ClockIcon from '@patternfly/react-icons/dist/esm/icons/clock-icon';

## Examples

### Basic

```ts file="./TextInputBasic.tsx"

```

### Disabled

```ts file="./TextInputDisabled.tsx"

```

### Truncated at start

```ts file="./TextInputStartTruncated.tsx"

```

### Read only

```ts file="./TextInputReadOnly.tsx"

```

### Invalid

```ts file="./TextInputInvalid.tsx"

```

### Select text using ref

```ts file="./TextInputSelectUsingRef.tsx"

```

### Custom icon

```ts file="./TextInputCustomIcon.tsx"

```

### Custom icon and invalid

```ts file="./TextInputCustomIconInvalid.tsx"

```
