#include "parser.h"
#include "printer.h"
#include "saturation.h"
#include "gfanapplication.h"
#include "lp.h"

class IdealProductApplication : public GFanApplication
{
  FieldOption theFieldOption;
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  const char *helpText()
  {
    return "This program computes the product IJ of ideals generated by sets of polynomials given in the input.\n";
  }
  IdealProductApplication()
  {
    registerOptions();
  }

  const char *name()
  {
    return "_idealproduct";
  }

  int main()
  {
    LpSolver::printList(Stderr);
    lpSetSolver("cddgmp");

    FileParser P(Stdin);

    PolynomialRing theRing=P.parsePolynomialRing();
    PolynomialSet a=P.parsePolynomialSet(theRing);
    PolynomialSet b=P.parsePolynomialSet(theRing);

    PolynomialSet ret(theRing);
    for(PolynomialSet::const_iterator i=a.begin();i!=a.end();i++)
      for(PolynomialSet::const_iterator j=b.begin();j!=b.end();j++)
	{
	  ret.push_back(*i * *j);
	}
    pout<<ret;

    return 0;
  }
};

static IdealProductApplication theApplication;
