/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// ConsoleConfig struct for ConsoleConfig
type ConsoleConfig struct {
	File  *string `json:"file,omitempty"`
	Mode  string  `json:"mode"`
	Iommu *bool   `json:"iommu,omitempty"`
}

// NewConsoleConfig instantiates a new ConsoleConfig object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewConsoleConfig(mode string) *ConsoleConfig {
	this := ConsoleConfig{}
	this.Mode = mode
	var iommu bool = false
	this.Iommu = &iommu
	return &this
}

// NewConsoleConfigWithDefaults instantiates a new ConsoleConfig object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewConsoleConfigWithDefaults() *ConsoleConfig {
	this := ConsoleConfig{}
	var iommu bool = false
	this.Iommu = &iommu
	return &this
}

// GetFile returns the File field value if set, zero value otherwise.
func (o *ConsoleConfig) GetFile() string {
	if o == nil || o.File == nil {
		var ret string
		return ret
	}
	return *o.File
}

// GetFileOk returns a tuple with the File field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ConsoleConfig) GetFileOk() (*string, bool) {
	if o == nil || o.File == nil {
		return nil, false
	}
	return o.File, true
}

// HasFile returns a boolean if a field has been set.
func (o *ConsoleConfig) HasFile() bool {
	if o != nil && o.File != nil {
		return true
	}

	return false
}

// SetFile gets a reference to the given string and assigns it to the File field.
func (o *ConsoleConfig) SetFile(v string) {
	o.File = &v
}

// GetMode returns the Mode field value
func (o *ConsoleConfig) GetMode() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Mode
}

// GetModeOk returns a tuple with the Mode field value
// and a boolean to check if the value has been set.
func (o *ConsoleConfig) GetModeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Mode, true
}

// SetMode sets field value
func (o *ConsoleConfig) SetMode(v string) {
	o.Mode = v
}

// GetIommu returns the Iommu field value if set, zero value otherwise.
func (o *ConsoleConfig) GetIommu() bool {
	if o == nil || o.Iommu == nil {
		var ret bool
		return ret
	}
	return *o.Iommu
}

// GetIommuOk returns a tuple with the Iommu field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ConsoleConfig) GetIommuOk() (*bool, bool) {
	if o == nil || o.Iommu == nil {
		return nil, false
	}
	return o.Iommu, true
}

// HasIommu returns a boolean if a field has been set.
func (o *ConsoleConfig) HasIommu() bool {
	if o != nil && o.Iommu != nil {
		return true
	}

	return false
}

// SetIommu gets a reference to the given bool and assigns it to the Iommu field.
func (o *ConsoleConfig) SetIommu(v bool) {
	o.Iommu = &v
}

func (o ConsoleConfig) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.File != nil {
		toSerialize["file"] = o.File
	}
	if true {
		toSerialize["mode"] = o.Mode
	}
	if o.Iommu != nil {
		toSerialize["iommu"] = o.Iommu
	}
	return json.Marshal(toSerialize)
}

type NullableConsoleConfig struct {
	value *ConsoleConfig
	isSet bool
}

func (v NullableConsoleConfig) Get() *ConsoleConfig {
	return v.value
}

func (v *NullableConsoleConfig) Set(val *ConsoleConfig) {
	v.value = val
	v.isSet = true
}

func (v NullableConsoleConfig) IsSet() bool {
	return v.isSet
}

func (v *NullableConsoleConfig) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableConsoleConfig(val *ConsoleConfig) *NullableConsoleConfig {
	return &NullableConsoleConfig{value: val, isSet: true}
}

func (v NullableConsoleConfig) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableConsoleConfig) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
