/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "setupvolume.h"
#include "ui_setupvolume.h"

#include "global/global.h"

using namespace Global;

SetupVolume::SetupVolume(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::SetupVolume)
{
    ui->setupUi(this);

    QFont f("Noto Sans CJK SC Regular");
    f.setPixelSize(16);
    ui->label->setFont(f);
    ui->label_2->setFont(f);
    f.setPixelSize(14);
    ui->cb_AudioOutDevice->setFont(f);
    ui->cb_GlobalV->setFont(f);
    ui->cb_StandardV->setFont(f);

    // 全局音量和标准化功能先隐藏
    ui->label_2->hide();
    ui->cb_GlobalV->hide();
    ui->cb_StandardV->hide();

    QStringList items;
    //  音频输出默认先设置这几个，具体怎么拿到硬件输出后面需要加上
    items << "pulse" << "alsa";
    ui->cb_AudioOutDevice->addItems(items);

    initConnect();
}

SetupVolume::~SetupVolume()
{
    delete ui;
}

void SetupVolume::initData()
{
    // 初始化输出设备
    QString audio_out = gsetup->audioOut.first;
    ui->cb_AudioOutDevice->setCurrentText(audio_out);

    ui->cb_GlobalV->setChecked(gsetup->globalVolume.first);
    ui->cb_StandardV->setChecked(gsetup->standardVolume.first);
}

void SetupVolume::setBlackTheme()
{
    ui->label->setStyleSheet(QString("color:rgb(255,255,255);"));
    ui->label_2->setStyleSheet(QString("color:rgb(255,255,255);"));

    ui->cb_AudioOutDevice->setStyleSheet(QString("color:rgb(249,249,249);background-color:rgb(64,64,64);"));
    ui->cb_GlobalV->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->cb_StandardV->setStyleSheet(QString("color:rgb(249,249,249);"));
}

void SetupVolume::setLightTheme()
{
    ui->label->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->label_2->setStyleSheet(QString("color:rgb(38,38,38);"));

    ui->cb_AudioOutDevice->setStyleSheet(QString("color:rgb(38,38,38);background-color:rgb(240,240,240);"));
    ui->cb_GlobalV->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->cb_StandardV->setStyleSheet(QString("color:rgb(38,38,38);"));
}

void SetupVolume::setWidgetFont(QString family, int size)
{
    QFont f(family);
    f.setPointSize(size + 2);
    ui->label->setFont(f);
    ui->label_2->setFont(f);
    f.setPointSize(size);
    ui->cb_AudioOutDevice->setFont(f);
    ui->cb_GlobalV->setFont(f);
    ui->cb_StandardV->setFont(f);
}

void SetupVolume::initConnect()
{
    connect(ui->cb_AudioOutDevice, &QComboBox::currentTextChanged, [&](QString dev){gsetup->audioOut.second = dev;});
    connect(ui->cb_GlobalV, &QCheckBox::toggled, [&](bool checked){gsetup->globalVolume.second = checked;});
    connect(ui->cb_StandardV, &QCheckBox::toggled, [&](bool checked){gsetup->standardVolume.second = checked;});
}
