# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy

from . import models as _models
from ._configuration import DevCenterMgmtClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AttachedNetworksOperations,
    CatalogsOperations,
    CheckNameAvailabilityOperations,
    CheckScopedNameAvailabilityOperations,
    DevBoxDefinitionsOperations,
    DevCentersOperations,
    EnvironmentDefinitionsOperations,
    EnvironmentTypesOperations,
    GalleriesOperations,
    ImageVersionsOperations,
    ImagesOperations,
    NetworkConnectionsOperations,
    OperationStatusesOperations,
    Operations,
    PoolsOperations,
    ProjectAllowedEnvironmentTypesOperations,
    ProjectCatalogEnvironmentDefinitionsOperations,
    ProjectCatalogsOperations,
    ProjectEnvironmentTypesOperations,
    ProjectsOperations,
    SchedulesOperations,
    SkusOperations,
    UsagesOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class DevCenterMgmtClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """DevCenter Management API.

    :ivar dev_centers: DevCentersOperations operations
    :vartype dev_centers: azure.mgmt.devcenter.operations.DevCentersOperations
    :ivar projects: ProjectsOperations operations
    :vartype projects: azure.mgmt.devcenter.operations.ProjectsOperations
    :ivar attached_networks: AttachedNetworksOperations operations
    :vartype attached_networks: azure.mgmt.devcenter.operations.AttachedNetworksOperations
    :ivar project_catalogs: ProjectCatalogsOperations operations
    :vartype project_catalogs: azure.mgmt.devcenter.operations.ProjectCatalogsOperations
    :ivar environment_definitions: EnvironmentDefinitionsOperations operations
    :vartype environment_definitions:
     azure.mgmt.devcenter.operations.EnvironmentDefinitionsOperations
    :ivar project_catalog_environment_definitions: ProjectCatalogEnvironmentDefinitionsOperations
     operations
    :vartype project_catalog_environment_definitions:
     azure.mgmt.devcenter.operations.ProjectCatalogEnvironmentDefinitionsOperations
    :ivar galleries: GalleriesOperations operations
    :vartype galleries: azure.mgmt.devcenter.operations.GalleriesOperations
    :ivar images: ImagesOperations operations
    :vartype images: azure.mgmt.devcenter.operations.ImagesOperations
    :ivar image_versions: ImageVersionsOperations operations
    :vartype image_versions: azure.mgmt.devcenter.operations.ImageVersionsOperations
    :ivar catalogs: CatalogsOperations operations
    :vartype catalogs: azure.mgmt.devcenter.operations.CatalogsOperations
    :ivar environment_types: EnvironmentTypesOperations operations
    :vartype environment_types: azure.mgmt.devcenter.operations.EnvironmentTypesOperations
    :ivar project_allowed_environment_types: ProjectAllowedEnvironmentTypesOperations operations
    :vartype project_allowed_environment_types:
     azure.mgmt.devcenter.operations.ProjectAllowedEnvironmentTypesOperations
    :ivar project_environment_types: ProjectEnvironmentTypesOperations operations
    :vartype project_environment_types:
     azure.mgmt.devcenter.operations.ProjectEnvironmentTypesOperations
    :ivar dev_box_definitions: DevBoxDefinitionsOperations operations
    :vartype dev_box_definitions: azure.mgmt.devcenter.operations.DevBoxDefinitionsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.devcenter.operations.Operations
    :ivar operation_statuses: OperationStatusesOperations operations
    :vartype operation_statuses: azure.mgmt.devcenter.operations.OperationStatusesOperations
    :ivar usages: UsagesOperations operations
    :vartype usages: azure.mgmt.devcenter.operations.UsagesOperations
    :ivar check_name_availability: CheckNameAvailabilityOperations operations
    :vartype check_name_availability:
     azure.mgmt.devcenter.operations.CheckNameAvailabilityOperations
    :ivar check_scoped_name_availability: CheckScopedNameAvailabilityOperations operations
    :vartype check_scoped_name_availability:
     azure.mgmt.devcenter.operations.CheckScopedNameAvailabilityOperations
    :ivar skus: SkusOperations operations
    :vartype skus: azure.mgmt.devcenter.operations.SkusOperations
    :ivar pools: PoolsOperations operations
    :vartype pools: azure.mgmt.devcenter.operations.PoolsOperations
    :ivar schedules: SchedulesOperations operations
    :vartype schedules: azure.mgmt.devcenter.operations.SchedulesOperations
    :ivar network_connections: NetworkConnectionsOperations operations
    :vartype network_connections: azure.mgmt.devcenter.operations.NetworkConnectionsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2024-02-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = DevCenterMgmtClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=base_url, policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.dev_centers = DevCentersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.projects = ProjectsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.attached_networks = AttachedNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.project_catalogs = ProjectCatalogsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.environment_definitions = EnvironmentDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.project_catalog_environment_definitions = ProjectCatalogEnvironmentDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.galleries = GalleriesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.images = ImagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.image_versions = ImageVersionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.catalogs = CatalogsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.environment_types = EnvironmentTypesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.project_allowed_environment_types = ProjectAllowedEnvironmentTypesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.project_environment_types = ProjectEnvironmentTypesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.dev_box_definitions = DevBoxDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.operation_statuses = OperationStatusesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.usages = UsagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.check_name_availability = CheckNameAvailabilityOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.check_scoped_name_availability = CheckScopedNameAvailabilityOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.skus = SkusOperations(self._client, self._config, self._serialize, self._deserialize)
        self.pools = PoolsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.schedules = SchedulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.network_connections = NetworkConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> "DevCenterMgmtClient":
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
