% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTranscripts.R
\name{plotTranscripts}
\alias{plotTranscripts}
\title{visualize structure of assembled transcripts}
\usage{
plotTranscripts(
  gene,
  gown,
  samples = NULL,
  colorby = "transcript",
  meas = "FPKM",
  legend = TRUE,
  labelTranscripts = FALSE,
  main = NULL,
  blackBorders = TRUE,
  log = FALSE,
  logbase = 2,
  customCol = NULL,
  customOrder = NULL
)
}
\arguments{
\item{gene}{name of gene whose transcripts will be plotted.  When using 
Cufflinks output, usually of the form \code{"XLOC_######"}}

\item{gown}{ballgown object containing experimental and phenotype data}

\item{samples}{vector of sample(s) to plot. Can be \code{'none'} if only one 
plot (showing transcript structure in gray) is desired. Use 
\code{sampleNames(gown)} to see sample names for \code{gown}. Defaults to 
\code{sampleNames(gown)[1]}.}

\item{colorby}{one of \code{"transcript"}, \code{"exon"}, or \code{"none"}, 
indicating which feature's abundances should dictate plot coloring.  If 
\code{"none"}, all transcripts are drawn in gray.}

\item{meas}{which expression measurement to color features by, if any. Must 
match an available measurement for whatever feature you're plotting.}

\item{legend}{if \code{TRUE} (as it is by default), a color legend is drawn
on top of the plot indicating scales for feature abundances.}

\item{labelTranscripts}{if \code{TRUE}, transcript ids are labeled on the 
left side of the plot. Default \code{FALSE}.}

\item{main}{optional string giving the desired plot title.}

\item{blackBorders}{if \code{TRUE}, exon borders are drawn in black. 
Otherwise, they are drawn in the same color as their transcript or exon. 
Switching blackBorders to FALSE can be useful for visualizing abundances 
for skinny exons and/or smaller plots, which can be the case when 
\code{length(samples)} is large.}

\item{log}{if \code{TRUE}, color transcripts on the log scale. Default 
\code{FALSE}. To account for expression values of 0, we add 1 to all 
expression values before taking the log.}

\item{logbase}{log base to use if \code{log = TRUE}. Default 2.}

\item{customCol}{an optional vector of custom colors to color transcripts by.
There must be the same number of colors as transcripts in the gene being 
plotted.}

\item{customOrder}{an optional vector of transcript ids (matching ids in 
\code{texpr(gown, 'all')$t_id}), indicating which order transcripts will 
appear in the plot. All transcripts in \code{gene} must appear in the 
vector exactly once.}
}
\value{
produces a plot of the transcript structure for the specified gene in
  the current graphics device.
}
\description{
visualize structure of assembled transcripts
}
\examples{
\donttest{
data(bg)

# plot one gene for one sample:
plotTranscripts(gene='XLOC_000454', gown=bg, samples='sample12', meas='FPKM',
    colorby='transcript', 
    main='transcripts from gene XLOC_000454: sample 12, FPKM')

# plot one gene for many samples:
plotTranscripts('XLOC_000454', bg, 
    samples=c('sample01', 'sample06', 'sample12', 'sample19'), 
    meas='FPKM', colorby='transcript')

}
}
\seealso{
\code{\link{plotMeans}}, \code{\link{plotLatentTranscripts}}
}
\author{
Alyssa Frazee
}
