% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_dmSQTLdata.R
\name{dmSQTLdata}
\alias{dmSQTLdata}
\title{Create dmSQTLdata object}
\usage{
dmSQTLdata(counts, gene_ranges, genotypes, snp_ranges, samples, window = 5000,
  BPPARAM = BiocParallel::SerialParam())
}
\arguments{
\item{counts}{Data frame with counts. Rows correspond to features, for
example, transcripts or exons. This data frame has to contain a
\code{gene_id} column with gene IDs, \code{feature_id} column with feature
IDs and columns with counts for each sample. Column names corresponding to
sample IDs must be the same as in the \code{sample} data frame.}

\item{gene_ranges}{\code{\linkS4class{GRanges}} object with gene location. It
must contain gene names when calling names().}

\item{genotypes}{Data frame with genotypes. Rows correspond to SNPs. This 
data frame has to contain a \code{snp_id} column with SNP IDs and columns 
with genotypes for each sample. Column names corresponding to sample IDs 
must be the same as in the \code{sample} data frame. The genotype of each 
sample is coded in the following way: 0 for ref/ref, 1 for ref/not ref, 2 
for not ref/not ref, -1 or \code{NA} for missing value.}

\item{snp_ranges}{\code{\linkS4class{GRanges}} object with SNP location. It 
must contain SNP names when calling names().}

\item{samples}{Data frame with column \code{sample_id} corresponding to 
unique sample IDs}

\item{window}{Size of a down and up stream window, which is defining the 
surrounding for a gene. Only SNPs that are located within a gene or its 
surrounding are considered in the sQTL analysis.}

\item{BPPARAM}{Parallelization method used by 
\code{\link[BiocParallel]{bplapply}}.}
}
\value{
Returns a \code{\linkS4class{dmSQTLdata}} object.
}
\description{
Constructor functions for a \code{\linkS4class{dmSQTLdata}} object. 
dmSQTLdata assignes to a gene all the SNPs that are located in a given
surrounding (\code{window}) of this gene.
}
\details{
It is quite common that sample grouping defined by some of the SNPs is 
identical. Compare \code{dim(genotypes)} and \code{dim(unique(genotypes))}. 
In our QTL analysis, we do not repeat tests for the SNPs that define the 
same grouping of samples. Each grouping is tested only once. SNPs that define
such unique groupings are aggregated into blocks. P-values and adjusted 
p-values are estimated at the block level, but the returned results are 
extended to a SNP level by repeating the block statistics for each SNP that 
belongs to a given block.
}
\examples{
# --------------------------------------------------------------------------
# Create dmSQTLdata object
# --------------------------------------------------------------------------
# Use subsets of data defined in the GeuvadisTranscriptExpr package

library(GeuvadisTranscriptExpr)
\donttest{
geuv_counts <- GeuvadisTranscriptExpr::counts
geuv_genotypes <- GeuvadisTranscriptExpr::genotypes
geuv_gene_ranges <- GeuvadisTranscriptExpr::gene_ranges
geuv_snp_ranges <- GeuvadisTranscriptExpr::snp_ranges

colnames(geuv_counts)[c(1,2)] <- c("feature_id", "gene_id")
colnames(geuv_genotypes)[4] <- "snp_id"
geuv_samples <- data.frame(sample_id = colnames(geuv_counts)[-c(1,2)])

d <- dmSQTLdata(counts = geuv_counts, gene_ranges = geuv_gene_ranges,  
  genotypes = geuv_genotypes, snp_ranges = geuv_snp_ranges, 
  samples = geuv_samples, window = 5e3)
}
}
\seealso{
\code{\link{plotData}}
}
\author{
Malgorzata Nowicka
}
