% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkNames.R
\name{checkNames}
\alias{checkNames}
\alias{check_names}
\alias{assertNames}
\alias{assert_names}
\alias{testNames}
\alias{test_names}
\alias{expect_names}
\title{Check names to comply to specific rules}
\usage{
checkNames(
  x,
  type = "named",
  subset.of = NULL,
  must.include = NULL,
  permutation.of = NULL,
  identical.to = NULL,
  disjunct.from = NULL,
  what = "names"
)

check_names(
  x,
  type = "named",
  subset.of = NULL,
  must.include = NULL,
  permutation.of = NULL,
  identical.to = NULL,
  disjunct.from = NULL,
  what = "names"
)

assertNames(
  x,
  type = "named",
  subset.of = NULL,
  must.include = NULL,
  permutation.of = NULL,
  identical.to = NULL,
  disjunct.from = NULL,
  what = "names",
  .var.name = vname(x),
  add = NULL
)

assert_names(
  x,
  type = "named",
  subset.of = NULL,
  must.include = NULL,
  permutation.of = NULL,
  identical.to = NULL,
  disjunct.from = NULL,
  what = "names",
  .var.name = vname(x),
  add = NULL
)

testNames(
  x,
  type = "named",
  subset.of = NULL,
  must.include = NULL,
  permutation.of = NULL,
  identical.to = NULL,
  disjunct.from = NULL,
  what = "names"
)

test_names(
  x,
  type = "named",
  subset.of = NULL,
  must.include = NULL,
  permutation.of = NULL,
  identical.to = NULL,
  disjunct.from = NULL,
  what = "names"
)

expect_names(
  x,
  type = "named",
  subset.of = NULL,
  must.include = NULL,
  permutation.of = NULL,
  identical.to = NULL,
  disjunct.from = NULL,
  what = "names",
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{[\code{character} || \code{NULL}]\cr
Names to check using rules defined via \code{type}.}

\item{type}{[character(1)]\cr
Type of formal check(s) to perform on the names.
\describe{
\item{unnamed:}{Checks \code{x} to be \code{NULL}.}
\item{named:}{Checks \code{x} for regular names which excludes names to be \code{NA} or empty (\code{""}).}
\item{unique:}{Performs checks like with \dQuote{named} and additionally tests for non-duplicated names.}
\item{strict:}{Performs checks like with \dQuote{unique} and additionally fails for names with UTF-8 characters and names which do not comply to R's variable name restrictions. As regular expression, this is \dQuote{^[.]*[a-zA-Z]+[a-zA-Z0-9._]*$}.}
\item{ids:}{Same as \dQuote{strict}, but does not enforce uniqueness.}
}
Note that for zero-length \code{x}, all these name checks evaluate to \code{TRUE}.}

\item{subset.of}{[\code{character}]\cr
Names provided in \code{x} must be subset of the set \code{subset.of}.}

\item{must.include}{[\code{character}]\cr
Names provided in \code{x} must be a superset of the set \code{must.include}.}

\item{permutation.of}{[\code{character}]\cr
Names provided in \code{x} must be a permutation of the set \code{permutation.of}.
Duplicated names in \code{permutation.of} are stripped out and duplicated names in \code{x}
thus lead to a failed check.
Use this argument instead of \code{identical.to} if the order of the names is not relevant.}

\item{identical.to}{[\code{character}]\cr
Names provided in \code{x} must be identical to the vector \code{identical.to}.
Use this argument instead of \code{permutation.of} if the order of the names is relevant.}

\item{disjunct.from}{[\code{character}]\cr
Names provided in \code{x} must may not be present in the vector \code{identical.to}.}

\item{what}{[\code{character(1)}]\cr
Type of name vector to check, e.g. \dQuote{names} (default), \dQuote{colnames} or \dQuote{rownames}.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertNamed}/\code{assert_named} return 
 \code{x} invisibly, whereas
 \code{checkNamed}/\code{check_named} and 
 \code{testNamed}/\code{test_named} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertNamed}/\code{assert_named}
 throws an error message, 
 \code{testNamed}/\code{test_named}
 returns \code{FALSE},
 and \code{checkNamed} returns a string with the error message.
 The function \code{expect_named} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Performs various checks on character vectors, usually names.
}
\examples{
x = 1:3
testNames(x, "unnamed")
names(x) = letters[1:3]
testNames(x, "unique")

cn = c("Species", "Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")
assertNames(names(iris), permutation.of = cn)
}
\seealso{
Other attributes: 
\code{\link{checkClass}()},
\code{\link{checkMultiClass}()},
\code{\link{checkNamed}()}
}
\concept{attributes}
