% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers.R
\name{tidy_fixed}
\alias{tidy_fixed}
\alias{tidy_fixed.gam}
\alias{tidy_fixed.coxph}
\title{Extract fixed coefficient table from model object}
\usage{
tidy_fixed(x, ...)

\method{tidy_fixed}{gam}(x, intercept = FALSE, ...)

\method{tidy_fixed}{coxph}(x, ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Currently not used.}

\item{intercept}{Should intercept also be returned? Defaults to \code{FALSE}.}
}
\description{
Given a model object, returns a data frame with columns \code{variable},
\code{coef} (coefficient), \code{ci_lower} (lower 95\\% CI) and
\code{ci_upper} (upper 95\\% CI).
}
\examples{
library(survival)
gc <- coxph(Surv(days, status)~age + sex, data = tumor)
tidy_fixed(gc)
}
\keyword{internal}
