% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onevent.R
\name{removeEvent}
\alias{removeEvent}
\title{Remove an event that was added to an element}
\usage{
removeEvent(event, id, asis = FALSE)
}
\arguments{
\item{event}{Either an event type (see below for a list of event types) or
an event ID (the return value from
\code{\link[shinyjs]{onclick}} or \code{\link[shinyjs]{onevent}}).
If an event type is provided (eg. "hover"), then all events of this type
attached to the given element will be removed. If an event ID is provided,
then only that specific event will be removed.
See examples for clarification.}

\item{id}{The ID of the element/Shiny tag. Must match the ID used in
\code{\link[shinyjs]{onclick}} or \code{\link[shinyjs]{onevent}}.}

\item{asis}{If \code{TRUE}, use the ID as-is even when inside a module
(instead of adding the namespace prefix to the ID).}
}
\description{
This function can be used to revert the action of
\code{\link[shinyjs]{onclick}} or \code{\link[shinyjs]{onevent}}.
}
\section{Event types}{

Any standard \href{https://api.jquery.com/category/events/mouse-events/}{mouse} or
\href{https://api.jquery.com/category/events/keyboard-events/}{keyboard} events
that are supported by JQuery can be used. The standard list of events that can be used is:
\code{click}, \code{dblclick}, \code{hover}, \code{mousedown}, \code{mouseenter},
\code{mouseleave}, \code{mousemove}, \code{mouseout}, \code{mouseover}, \code{mouseup},
\code{keydown}, \code{keypress}, \code{keyup}. You can also use any other non
standard events that your browser supports or with the use of plugins (for
example, there is a \href{https://github.com/jquery/jquery-mousewheel}{mousewheel}
plugin that you can use to listen to mousewheel events).
}

\examples{
if (interactive()) {
  library(shiny)

  shinyApp(
    ui = fluidPage(
      useShinyjs(),  # Set up shinyjs
      p(id = "myel", "Hover over me to see the date, the time, and a random integer"),
      actionButton("remove_date", "Remove date hover event"),
      actionButton("remove_all", "Remove all hover events")
    ),
    server = function(input, output) {
      onevent("hover", "myel", print(format(Sys.time(), "\%H:\%M:\%S")))
      onevent("hover", "myel", print(sample(100, 1)), add = TRUE)
      date_event_id <- onevent("hover", "myel", print(as.character(Sys.Date())), add = TRUE)

      observeEvent(input$remove_all, {
        removeEvent("hover", "myel")
      })
      observeEvent(input$remove_date, {
        removeEvent(date_event_id, "myel")
      })
    }
  )
}
}
\seealso{
\code{\link[shinyjs]{onclick}},
\code{\link[shinyjs]{onevent}}
}
