% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_breaks.R
\name{find_breaks}
\alias{find_breaks}
\title{Breakpoints to be passed to a Histogram}
\usage{
find_breaks(x, nbins = "Scott", h, x0 = -h/1000)
}
\arguments{
\item{x}{numeric. A vector.}

\item{nbins}{integer or character. The suggested number of bins. 
Either a positive integer, or a character string naming a rule: 
\code{"Scott"} (the default) or \code{"Freedman-Diaconis"} or \code{"FD"}. 
(Case is ignored.)}

\item{h}{numeric. The bin width, a strictly positive number 
(takes precedence over nbins).}

\item{x0}{numeric. Shift for the bins - 
the breaks are at \code{x0 + h * (..., -1, 0, 1, ...)}.}
}
\value{
A numeric vector.
}
\description{
The function \code{find_breaks()} isolates a piece of code of 
the function \code{\link[MASS]{truehist}()} from package \pkg{MASS} 
that is used to compute the set of breakpoints to be applied for the 
construction of the histogram.
}
\seealso{
\code{\link[statip]{histo}()} in this package; 
\code{\link[MASS]{truehist}()} from package \pkg{MASS};
\code{\link[graphics]{hist}()} from package \pkg{graphics}.
}
