/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.bristol.star.cdf.CdfReader;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.CdfDescriptorRecord;
import uk.ac.bristol.star.cdf.record.CdfField;
import uk.ac.bristol.star.cdf.record.GlobalDescriptorRecord;
import uk.ac.bristol.star.cdf.record.OffsetField;
import uk.ac.bristol.star.cdf.record.Record;
import uk.ac.bristol.star.cdf.record.RecordFactory;
import uk.ac.bristol.star.cdf.util.LogUtil;

public class CdfDump {
    private final CdfReader crdr_;
    private final PrintStream out_;
    private final boolean writeFields_;
    private final boolean html_;

    public CdfDump(CdfReader cdfReader, PrintStream printStream, boolean bl, boolean bl2) {
        this.crdr_ = cdfReader;
        this.out_ = printStream;
        this.writeFields_ = bl;
        this.html_ = bl2;
    }

    public void run() throws IOException {
        long l;
        long l2;
        Buf buf = this.crdr_.getBuf();
        RecordFactory recordFactory = this.crdr_.getRecordFactory();
        long l3 = 8L;
        long l4 = l2 = buf.getLength();
        CdfDescriptorRecord cdfDescriptorRecord = null;
        GlobalDescriptorRecord globalDescriptorRecord = null;
        long l5 = -1L;
        if (this.html_) {
            this.out_.println("<html><body><pre>");
        }
        int n = 0;
        while (l3 < l4) {
            Record record = recordFactory.createRecord(buf, l3);
            this.dumpRecord(n, record, l3);
            if (cdfDescriptorRecord == null && record instanceof CdfDescriptorRecord) {
                cdfDescriptorRecord = (CdfDescriptorRecord)record;
                l5 = cdfDescriptorRecord.gdrOffset;
            }
            if (l3 == l5 && record instanceof GlobalDescriptorRecord) {
                globalDescriptorRecord = (GlobalDescriptorRecord)record;
                l4 = globalDescriptorRecord.eof;
            }
            l3 += record.getRecordSize();
            ++n;
        }
        if (this.html_) {
            this.out_.println("<hr />");
        }
        if ((l = l2 - l4) > 0L) {
            this.out_.println(" + " + l + " bytes after final record");
        }
        if (this.html_) {
            this.out_.println("</pre></body></html>");
        }
    }

    private void dumpRecord(int n, Record record, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.html_) {
            stringBuffer.append("<hr /><strong>");
        }
        stringBuffer.append(n).append(":\t").append(record.getRecordTypeAbbreviation()).append("\t").append(record.getRecordType()).append("\t").append(record.getRecordSize()).append("\t").append(this.formatOffsetId(l));
        if (this.html_) {
            stringBuffer.append("</strong>");
        }
        this.out_.println(stringBuffer.toString());
        if (this.writeFields_) {
            Field[] fieldArray = record.getClass().getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Object object;
                Field field = fieldArray[i];
                if (!this.isCdfRecordField(field)) continue;
                String string = field.getName();
                try {
                    object = field.get(record);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("Reflection error", illegalAccessException);
                }
                this.out_.println(this.formatFieldValue(string, object, this.isOffsetField(field)));
            }
        }
    }

    private boolean isCdfRecordField(Field field) {
        if (field.getAnnotation(CdfField.class) != null) {
            int n = field.getModifiers();
            assert (Modifier.isFinal(n) && Modifier.isPublic(n) && !Modifier.isStatic(n));
            return true;
        }
        return false;
    }

    private boolean isOffsetField(Field field) {
        return field.getAnnotation(OffsetField.class) != null;
    }

    private String formatFieldValue(String string, Object object, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CdfDump.spaces(4));
        stringBuffer.append(string).append(":");
        stringBuffer.append(CdfDump.spaces(28 - stringBuffer.length()));
        if (object != null) {
            if (object.getClass().isArray()) {
                int n = Array.getLength(object);
                if (bl) {
                    assert (object instanceof long[]);
                    long[] lArray = (long[])object;
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(this.formatOffsetRef(lArray[i]));
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(Array.get(object, i));
                    }
                }
            } else if (bl) {
                assert (object instanceof Long);
                stringBuffer.append(this.formatOffsetRef((Long)object));
            } else {
                stringBuffer.append(object.toString());
            }
        }
        return stringBuffer.toString();
    }

    private String formatOffsetId(long l) {
        String string = "0x" + Long.toHexString(l);
        return this.html_ ? "<a name='" + string + "'>" + string + "</a>" : string;
    }

    private String formatOffsetRef(long l) {
        String string = "0x" + Long.toHexString(l);
        return this.html_ && l > 0L ? "<a href='#" + string + "'>" + string + "</a>" : string;
    }

    static String spaces(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static int runMain(String[] stringArray) throws IOException {
        String string = new StringBuffer().append("\n   Usage:").append(CdfDump.class.getName()).append(" [-help]").append(" [-verbose]").append(" [-fields]").append(" [-html]").append(" <cdf-file>").append("\n").toString();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        int n = 0;
        File file = null;
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.equals("-html")) {
                iterator.remove();
                bl2 = true;
                continue;
            }
            if (string2.startsWith("-h")) {
                iterator.remove();
                System.out.println(string);
                return 0;
            }
            if (string2.equals("-v") || string2.equals("-verbose")) {
                iterator.remove();
                ++n;
                continue;
            }
            if (string2.equals("+v") || string2.equals("+verbose")) {
                iterator.remove();
                --n;
                continue;
            }
            if (string2.startsWith("-field")) {
                iterator.remove();
                bl = true;
                continue;
            }
            if (file != null) continue;
            iterator.remove();
            file = new File(string2);
        }
        if (!arrayList.isEmpty()) {
            System.err.println("Unused args: " + arrayList);
            System.err.println(string);
            return 1;
        }
        if (file == null) {
            System.err.println(string);
            return 1;
        }
        LogUtil.setVerbosity(n);
        new CdfDump(new CdfReader(file), System.out, bl, bl2).run();
        return 0;
    }

    public static void main(String[] stringArray) throws IOException {
        int n = CdfDump.runMain(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }
}

