/*
** Datei: dvix.c
** Autor: Ingo Eichenseher
*/      

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <stdlib.h>
#include <stdarg.h>
#include "dvi.h"    
#include "dvihdcp.h"
#include "dviframe.h"

int stop_key(void)
{
    return 0;
}

void install(void)
{
}

void destall(void)
{
}

int getch(void)
{
    fflush(stdout);
	return getchar();
}

void prbyte(int c)
{
}

static char *argv[] = {"DVI"};
static int argc = 1;
static char hello[] = "Dvi";
static Display *mydisplay;
static Window mywindow;
static XSizeHints myhint;
static GC mygc;
static unsigned long myforeground, mybackground;

int screen(void)
{
    XEvent myevent;
    XImage *myimage;
    KeySym mykey;

    int myscreen;
    int i, ret, lastx = 0, lasty = 0, srcx=0, srcy=0, xw, yw, xr, yr, keys_buttons;
    Window rw, cw;
    char text[10];
    int done;

    mydisplay = XOpenDisplay("");
    myscreen = DefaultScreen(mydisplay);
    mybackground = WhitePixel(mydisplay,myscreen);
    myforeground = BlackPixel(mydisplay,myscreen);
    if (myhint.width==0)
    {
	myhint.x = 100; myhint.y = 100;
	myhint.width = frame_width*8; myhint.height = frame_height;
    }
    myhint.flags = PPosition | PSize;
    mywindow = XCreateSimpleWindow(mydisplay,DefaultRootWindow(mydisplay),
	myhint.x, myhint.y, myhint.width, myhint.height,
	5, myforeground, mybackground);
    XSetStandardProperties(mydisplay,mywindow,hello,hello,None,argv,argc,&myhint);
    mygc = XCreateGC(mydisplay, mywindow,0,0);
    XSetBackground(mydisplay, mygc, mybackground);
    XSetForeground(mydisplay, mygc, myforeground);
    XSelectInput(mydisplay, mywindow, ButtonPressMask | KeyPressMask | ExposureMask |
	PointerMotionHintMask | ButtonMotionMask | StructureNotifyMask );
    XMapRaised(mydisplay, mywindow);
    myimage = XCreateImage(mydisplay,DefaultVisual(mydisplay,myscreen),1,XYBitmap,
    0,frame_buffer,frame_width*8,frame_height,16,frame_width);
    if (myimage==NULL)
	halt("Cannot Create Image");
    done = 0;

    while(done==0)
    {
	XNextEvent(mydisplay, &myevent);
	switch(myevent.type)
	{
	    case MappingNotify:
		XRefreshKeyboardMapping(&myevent);
		break;

	    case ConfigureNotify:
		myhint.x = myevent.xconfigure.x;
		myhint.y = myevent.xconfigure.y;
		myhint.width = myevent.xconfigure.width;
		myhint.height = myevent.xconfigure.height;
		break;

	    case ButtonPress:
		srcx = lastx+myevent.xbutton.x;
		srcy = lasty+myevent.xbutton.y;
		break;

	    case MotionNotify:
		XQueryPointer(mydisplay,myevent.xmotion.window,
		    &rw, &cw, &xr, &yr, &xw, &yw, &keys_buttons);
		lastx = srcx-xw;
		lasty = srcy-yw;
		if (lastx<0) lastx = 0;
		if (lasty<0) lasty = 0;
		if (lasty>=frame_height) lasty = frame_height-1;
		if (lastx>=frame_width*8) lastx = frame_width*8-1;
		XPutImage(mydisplay,mywindow,mygc,myimage,lastx,lasty,
		    0,0,frame_width*8,frame_height);
		if (myhint.width>frame_width*8-lastx)
		    XClearArea(mydisplay, mywindow, frame_width*8-lastx, 0, 
			myhint.width-frame_width*8+lastx,frame_height,0);
		if (myhint.height>frame_height-lasty)
		    XClearArea(mydisplay, mywindow, 0, frame_height-lasty, 
			frame_width*8, myhint.height-frame_height+lasty,0);
		break;

	    case Expose:
		if(myevent.xexpose.count == 0)
		XPutImage(mydisplay,mywindow,mygc,myimage,lastx,lasty,
		    0,0,frame_width*8,frame_height);
		if (myhint.width>frame_width*8-lastx)
		    XClearArea(mydisplay, mywindow, frame_width*8-lastx, 0, 
			myhint.width-frame_width*8+lastx,frame_height,0);
		if (myhint.height>frame_height-lasty)
		    XClearArea(mydisplay, mywindow, 0, frame_height-lasty, 
			frame_width*8, myhint.height-frame_height+lasty,0);
		break;

	    case KeyPress:
		i = XLookupString(&myevent, text, 10, &mykey, 0);
		if (i==1 && text[0]=='q') done=1, ret=1;
		if (i==1 && text[0]=='n') done=1, ret=0;
		break;
	}
    }
    XFreeGC(mydisplay,mygc);
    XDestroyWindow(mydisplay, mywindow);
    XCloseDisplay(mydisplay);

    return ret;
}
