/*
 *		Routine to use scalable/downloaded font of LIPS3 (dviprt)
 *								30 June	1992, written by SHIMA
 *      modifed for ESC/Page by H.Tomiie, 18 August 1992
 *      slightly modifed by OkI 14 Nov. 1992
 */

#ifdef MSVC
#define M_PI 3.14159265
#endif

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#define _DEF_DOS_H_
#include "dd.h"
#include "prtout.h"
#include "err.h"
#include "prtctl.h"
#include "escpage.h"
/* escpage.c local */
/* static void pr_attr(int flag); */
static int KetaSuu(PIXEL num);

/* p_out.c function */
static void escpage_init(void);
static void escpage_init2(int ff_rotate, int f_copy);
static void escpage_end();
static void set_escpage_font(FONT_INFO *fontc, KFONT *kf, int fg, int weight, int face);
static void move_cap(PIXEL v, PIXEL h);
static void move_homepoint(PIXEL v, PIXEL h);
static void pre_put_char(FONT_INFO *, PREAMBLE *, uint *, PIXEL *, PIXEL *);
static void put_jis_font(uint code);
static void put_dl_font(uint code);
static long get_dlhsize(int NumOfFonts);
static void pre_download(FONT_INFO *, DL_INFO *, int, int);
static void download_rastor(FONT_INFO *, DL_INFO *, uint, int);
static void post_download(FONT_INFO *dfont, DL_INFO *dl);
static void escpage_drawbox(PIXEL hs, PIXEL vs, PIXEL width, PIXEL height, int gray);
static void escpage_font_rotate(int);	/* tHg] (Deg.) */
static void tate_yoko(int);				/* cEtHg؊ */

static int j_lbp_font = -1;	/* current font in G1 */
static int HomePointBase;
static int MarginMaxPoint;

static int ass_f;
static int knjwidth;
/* static int last_d = -1; */
static int font_angle = 0;
static int last_angle = 0;
static int jfont_mode = 0;

extern BOOL f_rotate; /* Landscape?  */
extern long ptex_dpi_adj;
extern int on_edge_font;	/* ʂ炬肬͂ݏojis font*/
extern PIXEL vert_divide;

/* externals from prtinit.c */
extern char *youshi;	/* pwpR}h */
extern int length_to_dot(char *, int *, int);


#ifdef FDOWN
extern int maxdwidth;	/* download font width limit */
extern int maxdheight;	/* download font height limit */
extern int maxdfont;	/* num of kinds of download limit*/
#endif

#ifdef	JDWN
extern int calc_realsize(PREAMBLE *, struct REAL_SIZE *);
extern int f_gaiji;
#endif

/* escpage_init  p_out ̕ϐ̃ftHgZbg */
extern int weight_org;
extern int k_base_l;
extern int k_base_d;
extern int k_scale_l;
extern int lbp_orig_dpi;	/* ESCPAGE{ dpi l */
#define	str_exp	tmp_buf
/* extern char str_exp[];	*/ /* o͕Ɨp */

/* externals from pret.c */
extern int g_font;

PREAMBLE *get_font(uint *, FONT_INFO *);
void pr_putsc(char *, int);

/* p_out.c routine call */
void pr_putnc(char *, int);
void pr_puts(char *);
void pr_putsn(char *, int);
void pr_putc(char);
void pr_int2(uint num);
void pr_int2n(uint num, int count);
void pr_int4(ulong num);

int AtoI(char **);

static struct LIPS_LFONT escpage_data[] =
{
	{"Mincho.J83", 10},
	{"Gothic.J83", 9},
	{"User", 10}
};
LBP_FUNC escpage_func =
{
	escpage_init,	/* [` */
	escpage_init2,	/* [`2*/
	escpage_end,	/* I[` */
	set_escpage_font,	/* tHg̐ݒ */
	move_cap,	/* CAP̐Έړ */
	move_homepoint,	/* `挴_̈ړ */
	pre_put_char,	/* put_char O */
	put_jis_font,	/* put_char:jiso */
	put_dl_font,	/* put_char:downloadtHgo*/
	get_dlhsize,	/* dl data  wb_TCY */
	pre_download,	/* download ̑O */
	download_rastor,	/* X^C[Wdownload */
	post_download,	/* download ㏈ */
	escpage_drawbox,	/* box ` -box IvVp */
	escpage_font_rotate,	/* LN^]R}h */
	tate_yoko,	/* cEtHgI */
	escpage_data	/* lipstHgf[^ */
};

/* tOɎĂ郂[hɂ*/
/*
static void pr_attr(int flag)
{
	if (flag & F_GOTH)
		pr_puts(BOLD);
	if (flag & F_GGOTH)
		pr_puts(BBOLD);
}
*/

static void escpage_init(void)
{
	char buf[256];
	char *s;
	int paper, yoko, tate, houkou, kyuushi, bin, c, landscape;

	if (lbp_orig_dpi == 0)
		lbp_orig_dpi = LBP_ORIG_DPI;	/* LIPS3{dpil300 */
	if (k_base_l >= 10000) {/* 600bpi  k_base_l ́A팩L̒ 300bpi Ɠł邻ł */
		k_base_l = (lbp_orig_dpi != 240) ? K_BASE_L300 : K_BASE_L240;
	}
	if (k_scale_l == 10000)
		k_scale_l = K_SCALE_L;

	k_base_d = K_BASE_D;

	ass_f = font_angle = last_angle = jfont_mode = 0;
	j_lbp_font = -1;

	/*	weight_org=WEIGHT; */

#ifdef FDOWN
	maxdwidth = MAXDWIDTH;		/* maximal width of download font cell */
	maxdheight = MAXDHEIGHT;	/* maximal height of download font cell */
	maxdfont = MAXDFONT;		/* maximal number of download font sets */
#ifdef JGAIJI
	if (f_gaiji) return;
#endif
#endif

/* NetWare ESC/P ==> ESC/Page */
	pr_puts("\x1b" "z");
	pr_putc('\0');
	pr_putc('\0');

	sprintf(buf
			,"\x1d" "rhE"
			"\x1d" "0;%fmuE"
			"\x1d" "0;%u;%udrE"
			"\x1d" "1;%u;%udrE"
			"\x1d" "2;%u;%udrE"
			"\x1d" "0cmE"
			/* "\x1d" "8;0lpP" */
			"\x1d" "%u;0lpP"
			"\x1d" "0alfP"
			"\x1d" "0affP"
			"\x1d" "0;0;1clfP"
			"\x1d" "1pmP"
			"\x1d" "0;0pP"
			"\x1d" "0;0coP"
			"\x1d" "0boP"
			"\x1d" "1abP"
			"\x1d" "0spF"		/* ꉞĂ */
			"\x1d" "511iaF"
			"\x1d" "511ifF"
			"\x1d" "1mmE"
			,72.0 / lbp_orig_dpi
			,lbp_orig_dpi, lbp_orig_dpi
			,lbp_orig_dpi, lbp_orig_dpi
			,lbp_orig_dpi, lbp_orig_dpi
			,vert_divide	/*  8 OɃR[fBOĂƂ낪̂Œ */
		);

	pr_puts(buf);

	/*************************************************************
	-y wɂpw
*/
	s = youshi;
init:
	paper = kyuushi = bin = 0;
	houkou = 0;
	landscape = f_rotate;
	if(s != NULL){
	  while (*s) {
		switch (toupper(*(s++))) {
		  case '/':
			  goto init;
		  case 'A':
			  if ((c = *(s++)) == '5')
				  paper = 15;
			  else if (c == '3')
				  paper = 13;
			  else
				  paper = 14;
			  goto skip_num;
		  case 'B':
			  if (*(s++) == '4')
				  paper = 24;
			  else
				  paper = 25;
			  goto skip_num;
		  case 'H':
			  paper = 38;
skip_num:
		  	  landscape=f_rotate;
			  while (isdigit(*s))
				  s++;
			  houkou = 1;
			  break;
		  case 'T':
		  	  landscape=f_rotate;
			  paper = AtoI(&s);
			  houkou = 1;
			  break;
		  case 'F':
		  	  landscape=f_rotate;
			  paper = -1;
			  s += length_to_dot(s, &yoko, 0);
			  if (*s == ':' || *s == ';'){
				  s++;
				  s += length_to_dot(s, &tate, 1);
			  }
			  else {
				  tate = yoko;
			  }
			  houkou = 1;
			  break;
		  case 'L':
			  landscape=TRUE;
			  goto skip1;
		  case 'P':
		  	  landscape=FALSE;
skip1:
			  houkou = 1;
			  kyuushi = AtoI(&s);
			  if (*s == ':' || *s == ';') {
				  s++;
				  bin = AtoI(&s);
			  }
			  break;
		}
	  }
	}

	if (paper != 0) {
		if (paper != -1)
			sprintf(buf, "\x1d" "%upsE", paper);
		else
			sprintf(buf, "\x1d" "-1;%u;%upsE", yoko, tate);
		pr_puts(buf);
	}
	if (houkou != 0){
		pr_putsn("\x1d" "%upoE", (landscape==TRUE)?1:0);
	}
	if (bin == 0)
		bin = 1;
	if (kyuushi != 0 && lbp_orig_dpi != 240) {
		pr_putsn("\x1d" "%u;", kyuushi);
		pr_putsn("%uiuE", bin);
	}
	/*************************************************************
	pTeX ̏c̈󎚈ʒu␳vZp
*/
	ptex_dpi_adj = (long)lbp_orig_dpi *100L;

	/*************************************************************
	z[|Cg̕W
		p̒[0.2C`̈ʒu
		CgA{g}[Wݒ\lőɂ
*/
	HomePointBase = (lbp_orig_dpi * 2) / 10;
	MarginMaxPoint = 50 * lbp_orig_dpi;	/* ESC/Page t@g}jAQł */

	move_homepoint(0, 0);

}

static void escpage_end()
{
#if 1/* NetWare ESC/Page ==> ESC/P */
pr_puts("\x1d" "1pmE");/* for NetWare */
#endif
}

/* tHgt */
static void set_escpage_font(FONT_INFO *fontc, KFONT *kf, int fg, int weight, int face)
{

	int width, height;

	ENTER("set_escpage_font");

	/* AEgCł́AQhbgg */
	if (fg & F_OUTLINE)
		kf->width -= 2;
	g_font = (fontc->f_goth & (F_ATTR | F_LBP));	/*tHgŎg𓾂*/

	if ( fontc->f_goth & F_TATE ){
		width = kf->height;
		height = kf->width;
	}
	else{
		width = kf->width;
		height = kf->height;
	}
	pr_putsn(CHR_SIZE, height);	/* ̐ݒ select point */
	pr_putsn(CHR_PITCH, width);	/* ̐ݒ   select point */
	pr_putsn(FACE, face);		/* tHgԍ̐ݒ  select face */
/*
/#ifndef NOTATEGAKI
	if (tategaki)
		pr_puts(TATEGAKI);
	else
#endif
*/
		pr_puts(YOKO);			/* ̂̐ݒ */
	if (fg & F_GOTH)
		pr_puts(BOLD);
	else if (fg & F_GGOTH)
		pr_puts(BBOLD);
	else
		pr_puts(NO_BOLD);
#ifndef NO_NTTRPL
	if (fontc->code_offset >= 0)
		pr_putsn(ASSIGN_G1, fontc->family_code);
	else
#endif
	pr_putsn(ASSIGN_G1, fontc->font_code);
	j_lbp_font = -1;
}

static int KetaSuu(PIXEL num)
{
	int Keta;

	if (num >= 0)
		Keta = 0;
	else {
		Keta = 1;
		num = (-num);
	}
	if (num < 10)
		return Keta + 1;
	else if (num < 100)
		return Keta + 2;
	else if (num < 1000)
		return Keta + 3;
	else if (num < 10000)
		return Keta + 4;
	return Keta + 5;
}

static void move_cap(PIXEL v, PIXEL h)
{
	static PIXEL last_v, last_h;
	PIXEL sub;

	if (v == -1 && !on_edge_font) {				/* reset last CAP position */
		last_v = last_h = -1;
		return;
	}
	if (last_v != v) {
		sub = v - last_v;
		if (KetaSuu(v) <= KetaSuu(sub) || last_v == -1)
			pr_putsn(SET_Y, v);
		else
			pr_putsn(MOVE_BELOW, sub);
		last_v = v;
	}
	if (last_h != h) {
		sub = h - last_h;
		if (KetaSuu(h) <= KetaSuu(sub) || last_h == -1)
			pr_putsn(SET_X, h);
		else
			pr_putsn(MOVE_RIGHT, sub);
		last_h = h;
	}
}

static void move_homepoint(PIXEL v, PIXEL h)
{
	pr_putsn("\x1d" "%u;", h + HomePointBase);	/* __̐ݒ */
	pr_putsn("%uloE", v + HomePointBase);
	pr_putsn("\x1d" "0tmE" "\x1d" "%ubmE", MarginMaxPoint);
	pr_putsn("\x1d" "0lmE" "\x1d" "%urmE", MarginMaxPoint);
	move_cap(-1, -1);
}

#define	PUSH_POS	pr_puts("\x1d" "1ppP");
#define	POP_POS		pr_puts("\x1d" "2ppP");

static void MoveWrite(uint code, PIXEL h, PIXEL v)
{
	if (h != 0)
		pr_putsn("\x1d" "%dH", h);
	if (v != 9)
		pr_putsn("\x1d" "%dV", v);
	pr_int2(code);				/* output JIS code */
}


static void pre_put_char(FONT_INFO *font, PREAMBLE *pxl, uint *code, PIXEL *h, PIXEL *v)
{
#ifndef NO_NTTRPL
	if (font->code_offset >= 0) ass_f = font->family_code;
		else
#endif
	ass_f = font->font_code;
	knjwidth = pxl->width;
	return;
}

static void escpage_font_rotate(int angle)
{
	font_angle = angle;
}

static void tate_yoko(int mode)
{
	/* mode : 0 = tHg 1 = ctHg */
	jfont_mode = mode;
}

static void put_jis_font(uint code)
{

	static int last_jfont_mode = 0;

	/* nhɂKȃR[fBOłD
	 * ʂȕȂ肠Ǝv̂ŁC`[jOKvłD */
	if (ass_f != j_lbp_font) {
		/* change G1 font */
		pr_putsn(CHANGE_G1, j_lbp_font = ass_f);
		goto label1; /* tHg^CvςΊpxĐݒ */
	}
	if (last_angle != font_angle){
		label1:
		pr_putsn(KAITEN, last_angle = font_angle);
		goto label2; /* tHg̊pxݒ肵Ƃ͕KcĐݒ */
	}

	if (last_jfont_mode != jfont_mode){
		label2:
		pr_puts( ((last_jfont_mode = jfont_mode) == 0)? YOKO : TATE);
	}

	if ((g_font & (F_SHADOW | F_OUTLINE)) == (F_SHADOW | F_OUTLINE)) {
		int Kage;

		PUSH_POS;
		MoveWrite(code, 0, -1);
		MoveWrite(code, 1, -1);
		MoveWrite(code, 1, 1);
		MoveWrite(code, -1, 1);
		MoveWrite(code, 0, 1);
		for (Kage = knjwidth >> 4; Kage > 0; Kage--)
			MoveWrite(code, 1, 1);	/* e 1,0 Ήe 1,1 */
		POP_POS;
	}
	else if (g_font & F_SHADOW) {
		int Kage;

		PUSH_POS;
		for (Kage = knjwidth >> 4; Kage > 0; Kage--)
			MoveWrite(code, 1, 1);	/* e 1,0 Ήe 1,1 */
		POP_POS;
	}
	else if (g_font & F_OUTLINE) {
		PUSH_POS;
		MoveWrite(code, 0, -1);
		MoveWrite(code, 1, -1);
		MoveWrite(code, 1, 1);
		MoveWrite(code, -1, 1);
		POP_POS;
	}
	if (g_font & (F_SHADOW | F_OUTLINE | F_FILL)) {
		if (g_font & F_FILL) {
			pr_puts("\x1d" "1tsE" "\x1d" "1;0;20spE" "\x1d" "1owE");
		}
		else {
			pr_puts("\x1d" "1tsE" "\x1d" "1;0;0spE" "\x1d" "1owE");
		}
		if (g_font & F_OUTLINE) {
			PUSH_POS;
			MoveWrite(code, 1, -1);
			POP_POS;
		}
		else
			pr_int2(code);		/* output JIS code */
		pr_puts("\x1d" "0tsE");
	}
	else {
		if (g_font & F_OUTLINE) {
			PUSH_POS;
			MoveWrite(code, 1, -1);
			POP_POS;
		}
		else
			pr_int2(code);		/* output JIS code */
	}
}

/*@ESC/Page ł code 128 ȏ̕_E[hł邪A\[X̏C
@Ȃ邽߂ɁA128 PʂŃ_EB
@@LP7000 Rg[LN^̃R[h󎚏oȂ̂ŁAR[h
@VtgBi128PʂŃ_E[hĂ̂ŉ\łj
*/
/* ESC/Pagfe [ߖ̂ŃMMɊt */
#define	SHIFT_ASSIGN 0x100
/* LP7000 Rg[LłȂ̂ŃVtg */
#define	SHIFT_CHAR 0x20

static void put_dl_font(uint code)
{
	if (code & 0x80) {
		ass_f += SHIFT_ASSIGN;
	}
	if (ass_f != j_lbp_font) {	/* change G0 font */
		pr_putsn(CHANGE_G1, j_lbp_font = ass_f);
		goto label3;
	}

	if (last_angle != font_angle){
		label3:
		pr_putsn(KAITEN, last_angle = font_angle);
	}

	pr_putc((uchar)((code & 0x7f) + SHIFT_CHAR));	/* output ASC code */
}

static long get_dlhsize(int NumOfFonts)
{
	return (long)NumOfFonts *D_CHAR + D_HEAD;
}

static void pre_download(FONT_INFO *dfont, DL_INFO *dl, int num_dfont, int flag)
{
	if (flag)
		dl->assign_num += SHIFT_ASSIGN;

	pr_putsn("\x1d" "134;%udh{F", dl->assign_num);	/*}*/
	/* assign a number to FONT */
	pr_int2(2);					/* @_E[htH[}bg */
	pr_int2(0x86);				/* @f[^ */
	pr_int2(USER_SYMBOLBASE + dl->assign_num);	/* V{Zbg */
	pr_int2(0);					/* @Xy[VO*/
	pr_int4((long)dl->maxwidth);	/* @ */
	pr_int4((long)(dl->maxheight));	/*  */
	pr_int2(USER_TYPEFACEBASE + dl->assign_num);	/* @ */
	pr_int2n(0, 3);				/* @ */
								/* @] */
								/* @X */
	pr_int2(dl->maxcharcode + SHIFT_CHAR);	/* őLN^[R[h */
	pr_int2(dl->mincharcode + SHIFT_CHAR);	/* ŏLN^[R[h */
	pr_int2n(0, 6);				/* @A_[CItZbg */
								/* @A_[C */
								/* @I[o[CItZbg */
								/* @I[o[C */
								/* @XgCNAEgItZbg */
								/* @XgCNAEg */
	pr_int2(dl->maxwidth);		/* LN^Z */
	pr_int2(dl->maxheight);		/* LN^Z */
	pr_int2(0);					/* @LN^ZItZbg */
	pr_int2(dl->maxheight);		/* LN^ZAZ_ */
	pr_int4((long)(dl->maxwidth));	/* Œsb` */
	pr_putsc(dfont->name, 54);	/* tHg */
	pr_putsc("TexFonts", 28);	/* V{Zbg */
	pr_putsn("\035%udcF", dl->assign_num);	/* select download font for later use*/
}

#if 0
/* tHg̃rbgC[Ŵ܂܃_E[h */
static void download_rastor(FONT_INFO *dfont, DL_INFO *dl, uint code, int flag)
{
	PREAMBLE *preamble;
	int bytesize;
	uint tmp;
	BUFFER *pat;

	tmp = flag + code;
	preamble = get_font(&tmp, dfont);
	bytesize = preamble->byte_width * preamble->height;
	sprintf(str_exp, "\x1d" "%udcF" "\x1d" "%u;%usc{F"	/* } */
			,dl->assign_num, 16 + bytesize, (code & 0x7f) + SHIFT_CHAR);
	pr_puts((char *)str_exp);
	pr_putc(0x1);				/* @tH[}bg */
	pr_putc(0x10);				/* @f[^fBNg */
	pr_int2(0);					/* @LN^[R[h */
	pr_int2(preamble->width);	/* rbg}bv */
	pr_int2(preamble->height);	/* rbg}bv */
	pr_int2(0);					/* @rbg}bvItZbg */
	pr_int2(preamble->height);	/* rbg}bvAZ_ */
	pr_int4((long)preamble->width);	/*  */
	pat = preamble->raster;
	while (bytesize--)
		pr_putc(*pat++);
}
#else
/* tHg̗]ă_E[h */
static void download_rastor(FONT_INFO *dfont, DL_INFO *dl, uint code, int flag)
{
	PREAMBLE *preamble;
	uint tmp;
	BUFFER *pat;
	BUFFER *pat0;
	struct REAL_SIZE size;
	int width, height, bit_off, bit_get, i;

	tmp = flag + code;
	preamble = get_font(&tmp, dfont);
	calc_realsize(preamble, &size);

	width = size.right - size.left;
	height = size.bottom - size.top;

	sprintf(str_exp, "\x1d" "%udcF" "\x1d" "%u;%usc{F"
			, dl->assign_num, 16 + (((width + 7)>>3) * height)
			, (code & 0x7f) + SHIFT_CHAR);
	pr_puts((char *)str_exp);
	pr_putc(0x1);							/* @tH[}bg */
	pr_putc(0x10);							/* @f[^fBNg */
	pr_int2(0);								/* @LN^[R[h */
	pr_int2(width);							/* rbg}bv */
	pr_int2(height);						/* rbg}bv */
	pr_int2(size.left);						/* rbg}bvItZbg */
	pr_int2(preamble->height - size.top);	/*rbg}bvAZ_ */
	pr_int4((long)preamble->width);			/*  */

	bit_off = size.left & 7;
	bit_get = 8 - bit_off;
	pat0 = preamble->raster + size.top*preamble->byte_width + size.left/8;
	while (height--){
		pat = pat0;
		for(i = width; i > 0; i -= 8){
			tmp = *pat++;
			if (bit_off){
				tmp <<= bit_off;
				if(i > bit_get) tmp |= ((uchar)*pat >> bit_get);
			}
			pr_putc((uchar)(tmp & 0xff));
		}
		pat0 += preamble->byte_width;
	}
}
#endif

static void post_download(FONT_INFO *dfont, DL_INFO *dl)
{

	pr_putsn("\x1d" "%u;0ssF", USER_SYMBOLBASE + dl->assign_num);
	/*symbol set number*/
	pr_puts(NO_BOLD);			/* stroke weight */
	pr_putsn(KAITEN, 0);		/* rotation */
	pr_putsn(CHR_PITCH, dl->maxwidth);	/* character width */
	pr_putsn(CHR_SIZE, dl->maxheight);	/* character hight */
	pr_putsn("\x1d" "%utfF", USER_TYPEFACEBASE + dl->assign_num);
	/*style set */

	pr_putsn(ASSIGN_G1, dl->assign_num);

}

static void escpage_init2(int ff_rotate, int f_copy)
{
	if (ff_rotate) {
		pr_puts(ROTATE);
	}
	if (f_copy)
		pr_putsn(COPYS, f_copy);
}

static int graytab[] =
{0,	   /* ^HigĂȂj */
 20,   /* O[(20%)			*/
 40,   /* O[(40%)				*/
 100,  /* ^HigĂȂj */
};

static void escpage_drawbox(PIXEL vs, PIXEL hs, PIXEL height, PIXEL width, int gray)
{
	int graylevel;
/*	int ve, he; */

#define SWAP(A,B)	{int tmp;tmp = A;A = B;B = tmp;}

	graylevel = graytab[gray];
	switch(font_angle){
	case   0:
		vs += (1 - height);
		break;
	case 270:
		SWAP(height,width);
		break;
#ifndef NOTPIC_EXTENSION
	case 90:
		SWAP(height,width);
		vs += (1 - height);
		hs += (1 - width);
		break;
	case 180:
		hs += (1 - width);
		break;
	default:
		{
			double angle;
			int sh,ch,sw,cw;

			angle = (double)font_angle * M_PI / 180.0;
			sh = (int)(sin(angle)*height);
			ch = (int)(cos(angle)*height);
			sw = (int)(sin(angle)*width);
			cw = (int)(cos(angle)*width);

			pr_puts("\x1d" "1tsE");

			/*  }``惂[hI */
			pr_puts("\x1d" "1dmG");
			/* XN[p^[̑I*/
			pr_putsn("\x1d" "0;0;%uspE", graylevel);
			/* p`` */
			pr_putsn("\x1d" "1;4;%u;",  hs);
			pr_putsn("%u;",				vs);
			pr_putsn("%u;",				hs - sh );
			pr_putsn("%u;",				vs - ch);
			pr_putsn("%u;",				hs + cw - sh);
			pr_putsn("%u;",				vs - sw - ch);
			pr_putsn("%u;",				hs + cw);
			pr_putsn("%upG",			vs - sw);
			pr_puts("\x1d" "0tsE");

		/*  }``惂[hI */
			pr_puts("\x1d" "0dmG");
			/* I */
			pr_puts("\x1d" "0;0lpG");
			/* p`` */
			pr_putsn("\x1d" "1;4;%u;",	hs);
			pr_putsn("%u;",				vs);
			pr_putsn("%u;",				hs - sh );
			pr_putsn("%u;",				vs - ch);
			pr_putsn("%u;",				hs + cw - sh);
			pr_putsn("%u;",				vs - sw - ch);
			pr_putsn("%u;",				hs + cw);
			pr_putsn("%upG",			vs - sw);

			move_cap(-1, -1);
			return ;

		}
#endif
	}

	pr_puts("\x1d" "1tsE");

	/*  }``惂[hI */
	pr_puts("\x1d" "1dmG");
	/* XN[p^[̑I*/
	pr_putsn("\x1d" "0;0;%uspE", graylevel);
	/*	`` */
	pr_putsn("\x1d" "%u;", hs);
	pr_putsn("%u;", vs);
	pr_putsn("%u;", hs + width - 1);
	pr_putsn("%u;0rG", vs + height - 1);

	pr_puts("\x1d" "0tsE");

	/*  }``惂[hI */
	pr_puts("\x1d" "0dmG");
	/* I */
	pr_puts("\x1d" "0;0lpG");
	/*	`` */
	pr_putsn("\x1d" "%u;", hs);
	pr_putsn("%u;", vs);
	pr_putsn("%u;", hs + width - 1);
	pr_putsn("%u;0rG", vs + height - 1);

	move_cap(-1, -1);
}
