#This file belongs to the TOIL package : Ten plik nale/zy do pakietu TOIL
#This package is public domain         : Pakiet stanowi dobro powszechne
#For more info see `0TOILENG.LIC'      : Wi/ecej informacji w ,,0TOILPOL.LIC''
#============================================================================
#                            GOVERNING FILE
# ==========================================================================
# PARMETERS:
# CLP -- an auxiliary file containing in the first line a comment,
#        in the second one -- the font name, and then a list of options ensues
# No input is expected
# ==========================================================================
BEGIN {
# FIX BASIC CONSTANTS
  fix_const()

# WRITE A BANNER
  mess("This is a configurable Type One Install utiLity (TOIL), ver.", VER_NO)

# INSPECT CONFIG FILE AND ANALYSE COMMAND LINE
  clear(Q_COND); list_files(ENV_CFG, "", CFG_PAT, Q_COND, cfg_lst)
  CFG=cfg_lst[1]; if (cfg_lst[1]=="") errmess(1, CFG_PAT " file not found")
  get_config(cfg_lst[1])
  analyse_command_line_parameters(CLP)
  if (err_par!="") errmess(2, "Offending parameter:", err_par)

# CHECK WHETHER THE REMAINING AWK PROGRAMS EXIST
  clear(Q_COND); Q_COND[AWK1_PAT]=1; Q_COND[AWK2_PAT]=1
  list_files(ENV_CFG, "", AWK_PAT, Q_COND, awk_lst)
  AWK1=first_fit(awk_lst, AWK1_PAT)
  AWK2=first_fit(awk_lst, AWK2_PAT)
  if ((AWK1=="") || (AWK2=="")) errmess(4, "AWK program(s) not found")

# CHECK WHETHER THE COMPONENT MF FILES EXIST
  clear(Q_COND); Q_COND[MF1_PAT]=1; Q_COND[MF2_PAT]=1; Q_COND[MF3_PAT]=1
  list_files(ENV_CFG, "", MF_PAT, Q_COND, mf_lst)
  MF1=first_fit(mf_lst, MF1_PAT)
  MF2=first_fit(mf_lst, MF2_PAT)
  MF3=first_fit(mf_lst, MF3_PAT)
  if ((MF1=="")||(MF2=="")||(MF3=="")) errmess(5,"MF component(s) not found")

# FIX BASIC NAMES
  if ((MF=="") && ((X_SCALE!="") || (IT_ANGLE!=""))) {
    warn("It is advisable to use an alternate name (option `-M')",
         "if you rescale or slant a font (options `-X' or `-I')")
  }
  if (MF=="") MF=FONT
  TFM=MF
  MF_MF=MF ".mf"
  if (ENC_NAME=="") ENC_NAME=MF
  if (ENC_GVN!="") {
    clear(Q_COND)
    list_files(".;" ENV_CFG,
      sys_hull_dir(ENC_GVN), sys_hull_namex(ENC_GVN), Q_COND, enc_lst)
    ENC_ACT=enc_lst[1]
  }
  if (LIG_GVN!="") {
    clear(Q_COND)
    list_files(".;" ENV_CFG,
      sys_hull_dir(LIG_GVN), sys_hull_namex(LIG_GVN), Q_COND, lig_lst)
    LIG_ACT=lig_lst[1]
  }

# FIND AFM AND PFB/PFA FILES
  mess("Seeking for " FONT ".afm and " FONT ".pfa or " FONT ".pfb")
  clear(Q_COND); Q_COND[AFM_PAT]=1; Q_COND[PSF_PAT]=1
  list_files(CV["T1PSTREE"],
    sys_hull_dir(FONT_GVN), FONT T1_PAT, Q_COND, t1_lst)
  AFM_FILE=first_fit(t1_lst, AFM_PAT)
  PSF_FILE=unix_name(first_fit(t1_lst, PSF_PAT))
  if (AFM_FILE=="") errmess(6, FONT ".afm not found")
  if (PSF_FILE=="") warn("Neither " FONT ".pfb nor " FONT ".pfa not found")

# RESOLVE INTERNAL REFERENCES
  AFM_DIR=sys_hull_dir(AFM_FILE)
  PSF_DIR=sys_hull_dir(PSF_FILE)
  CV["ENC_XNAME"]=sys_conc(CV["RES_ENC_PFX"], ENC_NAME CV["RES_ENC_EXT"])
  CV["PSF_XNAME"]=sys_conc(CV["RES_PSF_PFX"], sys_hull_namex(PSF_FILE))
  for (v in CV) {
    if (CV[v] ~ /\*(((AFM|PSF)_DIR)|((ENC|FONT|MF)_NAME))\*/) {
      gsub(/\*AFM_DIR\*/, AFM_DIR, CV[v]); CV[v]=sys_name(CV[v])
      gsub(/\*PSF_DIR\*/, PSF_DIR, CV[v]); CV[v]=sys_name(CV[v])
      gsub(/\*ENC_NAME\*/, ENC_NAME, CV[v]); CV[v]=sys_name(CV[v])
      gsub(/\*FONT_NAME\*/, FONT, CV[v]); CV[v]=sys_name(CV[v])
      gsub(/\*MF_NAME\*/, MF, CV[v]); CV[v]=sys_name(CV[v])
    }
  }
  CV["ENC_XNAME"]=unix_name(CV["ENC_XNAME"])
  CV["PSF_XNAME"]=unix_name(CV["PSF_XNAME"])

# FIND FONT MAP FILE
  clear(Q_COND)
  list_files(CV["RES_MAP_DIR"], "", CV["USER_MAP"], Q_COND, loc_lst)
  MAP=loc_lst[1]
  if ((MAP=="") && CV["USE_GLB_MAP"]) {# MAP doesn't exist yet, use global one
    clear(Q_COND)
    list_files(".;" CV["DVIPS_PATH"], "", CV["DVIPS_MAP"], Q_COND, glb_lst)
    MAP=glb_lst[1]
  }

# PERFORM (UPPER|LOWER)CASING, DEPENDING ON CONFIG FILE SETTINGS
  if (CV["LC_PSF_NAME"]) {
    CV["ENC_XNAME"]=lc(CV["ENC_XNAME"]); CV["PSF_XNAME"]=lc(CV["PSF_XNAME"])
    ENC_NAME=lc(ENC_NAME)
  }
  if (CV["UC_TFM_NAME"]) TFM=uc(TFM)

# WRITE TEMPORARY CONFIG FILE (EXTEND THE USER'S CONFIG)
  for (v in CV) print v, CV[v] > TMP_CFG
  print "FONT", FONT > TMP_CFG
  print "MF1", MF1 > TMP_CFG
  print "MF2", MF2 > TMP_CFG
  print "MF3", MF3 > TMP_CFG
  print "MF",  MF > TMP_CFG
  print "MF_MF",  MF_MF > TMP_CFG
  print "LIG_GVN", LIG_GVN > TMP_CFG
  print "LIG_ACT", LIG_ACT > TMP_CFG
  print "ENC_GVN", ENC_GVN > TMP_CFG
  print "ENC_ACT", ENC_ACT > TMP_CFG
  print "ENC_NAME", ENC_NAME > TMP_CFG
  print "AFM", AFM_FILE > TMP_CFG
  print "TFM", TFM > TMP_CFG
  print "MAP", MAP > TMP_CFG
  print "AFM_DIR", AFM_DIR > TMP_CFG
  print "PSF_DIR", PSF_DIR > TMP_CFG
  print "TMP_ENC", TMP_ENC > TMP_CFG
  print "TMP_MAP", TMP_MAP > TMP_CFG
  print "TMP_TMP", TMP_TMP > TMP_CFG
  print "PPI", PPI > TMP_CFG
  print "VER_NO",  VER_NO > TMP_CFG
  print "B_CHAR",  B_CHAR > TMP_CFG

# WRITE SYSTEM SCRIPTS
   # BAT1:
#  print sys_copy(TMP_TMP) > BAT1
  print sys_del(TMP_MAP) > BAT1
  print sys_del(TMP_ENC) > BAT1
  print sys_del(TMP_TMP) > BAT1
  print sys_name(AWK_CALL) " -f" AWK1 > BAT1
   # BAT2:
  MF_opt="\\batchmode;"
  if (X_SCALE!="") {MF_opt=MF_opt "XS=" X_SCALE ";"}
  if (IT_ANGLE!="") {MF_opt=MF_opt "IA=" IT_ANGLE ";"}
  print sys_name(MF_CALL) " " MF_opt "input " MF > BAT2
   # BAT3:
  if (MAP!="") {
    print sys_copy(MAP, TMP_MAP) > BAT3
    print "echo Using", MAP > BAT3
  }
  print sys_name(AWK_CALL) " -f" AWK2 " " MF ".log" > BAT3
   # BAT4: LOG and MF files should rather be kept in the case of MF crash
  if (CV["DEL_MF_LOG"]) print sys_del(MF ".log") > BAT4
  if (CV["DEL_MF_FILE"]) print sys_del(MF ".mf")  > BAT4
  print sys_del(MF ".ps")  > BAT4
   # BAT5:
  print sys_del(MF "." PPI "GF") > BAT5
  print sys_del(MF "." substr(PPI "GF",1,3)) > BAT5
  if (CV["RES_TFM_DIR"]!="\.") {
    print sys_copy(MF ".tfm", sys_conc(CV["RES_TFM_DIR"], MF ".tfm")) > BAT5
    print sys_del(MF ".tfm") > BAT5
  }
  print sys_copy(TMP_ENC,
    sys_conc(CV["RES_ENC_DIR"], ENC_NAME CV["RES_ENC_EXT"])) > BAT5
  print sys_copy(TMP_MAP,
    sys_conc(CV["RES_MAP_DIR"], CV["USER_MAP"])) > BAT5
  print sys_del(TMP_MAP) > BAT5
  print sys_del(TMP_ENC) > BAT5
  print sys_del(TMP_TMP) > BAT5
  print sys_del(TMP_CFG) > BAT5
}

# ==========================================================================

function uc(s, i) {
  for (i=1; i<=length(s); ++i) {
    if (substr(s,i,1) in UC)
      s=substr(s,1,i-1) UC[substr(s,i,1)] substr(s,i+1) 
  }
  return s
}

function lc(s, i) {
  for (i=1; i<=length(s); ++i) {
    if (substr(s,i,1) in LC)
      s=substr(s,1,i-1) LC[substr(s,i,1)] substr(s,i+1) 
  }
  return s
}

function analyse_command_line_parameters(CLP_FILE, glb_map, p, i) {
  # CLP_FILE -- command line parameter file
  getline FONT_GVN < CLP_FILE # get font name
  FONT=sys_hull_name(FONT_GVN)
  if (FONT=="") errmess(3, "Invalid font name", FONT_GVN)
  while (getline < CLP_FILE > 0) p[++p[0]]=$0 # get options
  i=1
  while ((i<=p[0]) && (p[i]!="") && (err_par=="")) {
    if (p[i] ~ /^[-\/][BbEeGgIiLlMmNnXx]$/) {
      if (p[i+1]=="") {err_par=p[i]}
      else {
        if (p[i] ~ /^[-\/][Bb]$/) B_CHAR=p[++i]
        if (p[i] ~ /^[-\/][Ee]$/) ENC_GVN=p[++i]
        if (p[i] ~ /^[-\/][Gg]$/) glb_map=p[++i]+0
        if (p[i] ~ /^[-\/][Ii]$/) IT_ANGLE=p[++i]+0
        if (p[i] ~ /^[-\/][Ll]$/) LIG_GVN=p[++i]
        if (p[i] ~ /^[-\/][Mm]$/) MF=sys_hull_name(p[++i])
        if (p[i] ~ /^[-\/][Nn]$/) ENC_NAME=sys_hull_name(p[++i])
        if (p[i] ~ /^[-\/][Xx]$/) X_SCALE=p[++i]+0
      }
    } else if (p[i] ~ /^[-\/][BbEeGgIiLlMmNnXx]/) {
      if (p[i] ~ /^[-\/][Bb]/) B_CHAR=substr(p[i],3)
      if (p[i] ~ /^[-\/][Ee]/) ENC_GVN=substr(p[i],3)
      if (p[i] ~ /^[-\/][Gg]/) glb_map=substr(p[i],3)+0
      if (p[i] ~ /^[-\/][Ii]/) IT_ANGLE=substr(p[i],3)+0
      if (p[i] ~ /^[-\/][Ll]/) LIG_GVN=substr(p[i],3)
      if (p[i] ~ /^[-\/][Mm]/) MF=sys_hull_name(substr(p[i],3))
      if (p[i] ~ /^[-\/][Nn]/) ENC_NAME=sys_hull_name(substr(p[i],3))
      if (p[i] ~ /^[-\/][Xx]/) X_SCALE=substr(p[i],3)+0
    } else {err_par=p[i]}
    ++i
  }
  B_CHAR=(B_CHAR !~ /[\+\-]?[0-9]+/ ? -1 : B_CHAR+0)
  if (LIG_GVN ~ /[\?\*]/) LIG_GVN=""
  if (ENC_GVN ~ /[\?\*]/) ENC_GVN=""
  if (MF ~ /[\?\*]/) MF=""
  if (ENC_NAME ~ /[\?\*]/) ENC_NAME=""
  gsub(/\.[Ee][Nn][Cc]$/, "", ENC_NAME)
  if (glb_map!="") CV["USE_GLB_MAP"]=glb_map
}

function errmess(e,s1,s2,s3) {# at most three parts may occur
  mess("TOIL ERROR:",s1, s2, s3); exit(e)
}

function mess(s1,s2,s3,s4, s) {# at most four parts may occur
  s=s1; if (s2!="") s=s " " s2; if (s3!="") s=s " " s3; if (s4!="") s=s " " s4
  if (length(s)<=max_line) {
    if (!CV["QUIET"]) print s > "CON"; if (LOG!="") print s > LOG
  } else {
    if ((!CV["QUIET"]) && (s1!="")) print s1 > "CON"
    if ((LOG!="") && (s1!="")) print s1 > LOG
    if ((!CV["QUIET"]) && (s2!="")) print s2 > "CON"
    if ((LOG!="") && (s2!="")) print s2 > LOG
    if ((!CV["QUIET"]) && (s3!="")) print s3 > "CON"
    if ((LOG!="") && (s3!="")) print s3 > LOG
    if ((!CV["QUIET"]) && (s4!="")) print s4 > "CON"
    if ((LOG!="") && (s4!="")) print s4 > LOG
  }
}

function warn(s1,s2,s3,s4, s) {# at most four parts may occur
  s="WARNING: " s1
  if (s2!="") s=s " " s2; if (s3!="") s=s " " s3; if (s4!="") s=s " " s4
  if (length(s)<=max_line) {
    if (!CV["QUIET"]) print s > "CON"; if (LOG!="") print s > LOG
  } else {
    if ((!CV["QUIET"]) && (s1!="")) print "WARNING:", s1 > "CON"
    if ((LOG!="") && (s1!="")) print "WARNING:", s1 > LOG
    if ((!CV["QUIET"]) && (s2!="")) print "        ", s2 > "CON"
    if ((LOG!="") && (s2!="")) print "        ", s2 > LOG
    if ((!CV["QUIET"]) && (s3!="")) print "        ", s3 > "CON"
    if ((LOG!="") && (s3!="")) print "        ", s3 > LOG
    if ((!CV["QUIET"]) && (s4!="")) print "        ", s4 > "CON"
    if ((LOG!="") && (s4!="")) print "        ", s4 > LOG
  }
}

function clear(t, i) {for (i in t) delete t[i]}
function entries(t, i,j) {for (i in t) ++j; return j}

function first_fit(list, item_pat, i, r) {
  for (i=1; i<=list[0]; ++i) {if (list[i] ~ item_pat) {r=list[i]; break}}
  return r
}

function list_files(tree, dir_pfx, file_pat, q_cond, res, q, r, s, t) {
  do_sys_del(TMP_TMP)
  t[0]=split(tree,t,";");
  for (s=1; s<=t[0]; ++s) {
    r=sys_conc_dir(t[s], dir_pfx)
    if (r ~ /[^!]!!$/) {
      r=substr(r,1,length(r)-2)
      if (sys_is_dir(r)) lst_all_lev(r, file_pat, res)
    } else if (r ~ /[^!]!$/) {
      r=substr(r,1,length(r)-1)
      if (sys_is_dir(r)) lst_one_lev(r, file_pat, res)
    } else {
      if (sys_is_dir(r)) lst_cur_lev(r, file_pat, res)
    }
    for (q in q_cond)
      for (r=1; r<=res[0]; ++r)
        if (res[r] ~ q) delete q_cond[q]
    if ((res[0]>0) && (entries(q_cond)==0)) break
  }
}

function lst_all_lev(dir, file_pat, res) {
  do_sys_call(sys_lst("-d /s") sys_conc(dir, file_pat) ">" TMP_TMP)
  while (getline < TMP_TMP > 0) res[++res[0]]=$0
  do_sys_del(TMP_TMP)
}

function lst_cur_lev(dir, file_pat, res) {
  do_sys_call(sys_lst("-d") sys_conc(dir, file_pat) ">" TMP_TMP)
  while (getline < TMP_TMP > 0) res[++res[0]]=sys_conc(dir, $0)
  do_sys_del(TMP_TMP)
}

function lst_one_lev(dir, file_pat, res, d, i) {
  lst_cur_lev(dir, file_pat, res)
  do_sys_call(sys_lst("d") sys_name(dir) ">" TMP_TMP)
  while (getline < TMP_TMP > 0) d[++d[0]]=$0
  for (i=1; i<=d[0]; ++i) {
    do_sys_del(TMP_TMP)
    do_sys_call(sys_lst("-d") "\"" sys_conc(sys_conc(dir, d[i]), file_pat) "\">" TMP_TMP)
    while (getline < TMP_TMP > 0)
      res[++res[0]]=sys_conc(sys_conc(dir, d[i]), $0)
    do_sys_del(TMP_TMP)
  }
}

function sys_is_dir(dir, s_n, f) {
# checks if a directory exists; introduced to avoid message ``path not found''
  s_n=sys_conc((dir=="" ? "." : dir), "nul")
  do_sys_call("if exist " s_n " echo FOUND > " TMP_TMP)
  getline f < TMP_TMP
  do_sys_del(TMP_TMP)
  return (f ~ "FOUND")
}

function sys_hull_dir(n) {# n -- a file name
  return (match(n,/[^:\\\/]*$/) ? substr(n,1,RSTART-1) : "")
}

function sys_hull_namex(n) {# n -- a file name
  return (match(n,/[^:\\\/]*$/) ? substr(n,RSTART) : n)
}

function sys_hull_name(n) {# n -- a file name
  gsub(/^.*[:\\\/]/, "", n) # truncate directory
  gsub(/\.+[^\.]*$/, "", n) # truncate extension (and malformed names)
  return n
}
function sys_conc(a, b) {# a -- directory, b -- file name
  if ((a=="") || (b ~ /:/)) return b
  else if (b=="") return a
  else return sys_name(a (a ~ /:$/ ? "" : "/" ) b)
}
function sys_conc_dir(a, b) {# a and b directories, perhaps from a tree (path)
  if ((a=="") || (b ~ /:/)) return b
  else if ((b=="") || (a ~ /[^!]!!?$/)) return a
  else return sys_name(a (a ~ /:$/ ? "" : "/" ) b)
}
function sys_name(n) {gsub(/\\+/,"/",n); gsub(/\/+/,"\\",n); return n}
function unix_name(n) {gsub(/\\+/,"/",n); return n}
function sys_lst(opt) {return "dir /on /b /a" opt " "}
function sys_del(what) {return "if exist " what " del " what}
function do_sys_del(what) {close(what); do_sys_call(sys_del(what))}
# ---
# ATTENTION: A DISCREPANCY DUE TO M$'S CRAZY LOCALIZATION!
# Uncomment the following declaration of `sys_copy' if the English
# MS DOS system is used (also see below):
# function sys_copy(i, o) {return "if exist " i " echo F|xcopy " i " " o ">" TMP_TMP}
# Uncomment the following declaration of `sys_copy' if the Polish
# MS DOS from Win95/98 system is used (`P' stands for Plik, while
# `F' stands for File):
function sys_copy(i, o) {return "if exist " i " echo P|xcopy " i " " o ">" TMP_TMP}
# ---
function do_sys_call(s) {system(s)} # print s > "ZZZ"

function get_cfg_item(item_name, item) {
  if ($1==item_name) {
    item=$0
    gsub("^[ \t]*" item_name "[ \t]+","",item)
    gsub(/[ \t]*(\|.*)?$/,"",item)
    CV[item_name]=item
  }
}

function get_config (CFG, v,w) {
  # list of actually recognized config variables:
  in_CV["T1PSTREE"]=1
  in_CV["USE_DIGIT_KPX"]=1
  in_CV["LC_PSF_NAME"]=1
  in_CV["UC_TFM_NAME"]=1
  in_CV["RES_MAP_DIR"]=1
  in_CV["RES_TFM_DIR"]=1
  in_CV["RES_ENC_DIR"]=1
  in_CV["RES_ENC_PFX"]=1
  in_CV["RES_ENC_EXT"]=1
  in_CV["RES_PSF_PFX"]=1
  in_CV["DVIPS_MAP"]=1
  in_CV["DVIPS_PATH"]=1
  in_CV["USER_MAP"]=1
  in_CV["USE_GLB_MAP"]=1
  in_CV["DEL_MF_FILE"]=1
  in_CV["DEL_MF_LOG"]=1
  in_CV["QUIET"]=1
  in_CV["MATHEMATIZE"]=1
  while (getline < CFG > 0) for (v in in_CV) get_cfg_item(v)
  
  if (CV["MATHEMATIZE"]=="") CV["MATHEMATIZE"]=1
  if (CV["RES_MAP_DIR"]=="") CV["RES_MAP_DIR"]="."
  if (CV["RES_TFM_DIR"]=="") CV["RES_TFM_DIR"]="."
  if (CV["RES_ENC_DIR"]=="") CV["RES_ENC_DIR"]="."
  for (w in in_CV)
    while (match(CV[w],/<[^>]+>/)) {
      v=substr(CV[w],RSTART+1,RLENGTH-2)
      # references to non-existant environment variables are replaced by
      # an empty string:
      CV[w]=substr(CV[w],1,RSTART-1)\
            (v in ENVIRON ? ENVIRON[v] : "")\
            substr(CV[w],RSTART+RLENGTH)
    }
#  for (w in CV) printf("%20s %s\n",w, CV[w])
}

function fix_const() {
# GENERAL CONSTANTS (used also in toilb.awk and toilc.awk)
  QQ="\""
  max_line=79      # screen limit
  max_sys_line=127 # MSDOS limit
  TMP_CFG="~t~m~p~.cfg"
# VERSION
  VER_NO="1.07"
# PATHS, FILE NAMES AND NAME PATTERNS
  ENV_CFG=("TOILPATH" in ENVIRON ? ENVIRON["TOILPATH"] : "")
  MF_CALL="mpost &mfplain"
  AWK_CALL=ARGV[0]
  TMP_NAME="_t_m_p_"
  TMP_TMP=TMP_NAME ".tmp"; TMP_ENC=TMP_NAME ".enc"; TMP_MAP=TMP_NAME ".map"
  CFG_PAT="toil.cfg"; T1_PAT="\.?f?"; AWK_PAT="toil?\.awk"
  AFM_PAT="\.(afm|AFM)$"; PSF_PAT="\.(pf[ab]|PF[AB])$";
  AWK1_PAT="(toilb|TOILB)\.(awk|AWK)"
  AWK2_PAT="(toilc|TOILC)\.(awk|AWK)"
  MF_PAT="toil.mf?"; MF1_PAT="1$"; MF2_PAT="2$"; MF3_PAT="3$"
  BAT1="toiltmp1.bat"; BAT2="toiltmp2.bat"; BAT3="toiltmp3.bat";
  BAT4="toiltmp4.bat"; BAT5="toiltmp5.bat"
  PPI=999
# INITIALIZE lc AND uc FUNCTION:
  for (i=97; i<=122; ++i) LC[sprintf("%c",i-32)]=sprintf("%c",i)
  for (i=65; i<=90; ++i) UC[sprintf("%c",i+32)]=sprintf("%c",i)
}
