/***************************************************************************
** Although considerable effort has been expended to make this software   **
** correct and reliable, no warranty is implied; the author disclaims any **
** obligation or liability for damages, including but not limited to      **
** special, indirect, or consequential damages arising out of or in       **
** connection with the use or performance of this software.               **
***************************************************************************/

/*
 *	This file contains VMS timing functions.
 */

#include descrip
#include psldef
#include "ast.h"

/*
 *	Routine Delay stops execution for a certain period of time:
 */

Delay (Milliseconds)
unsigned long Milliseconds;
{
	auto   unsigned long Sys_Status;
	static long Time_Value[2] = { 0, -1 };
	static unsigned long Timer_Event_Flag = 0;
	extern unsigned long Sys$SeTimr(), Sys$WaitFr(), Lib$Get_EF();
	extern int Check_System_Status();
/*
 *	Get an event flag if not already done:
 */
	if (Timer_Event_Flag == 0) {
		Sys_Status = Lib$Get_EF (&Timer_Event_Flag);
		if (Check_System_Status (Sys_Status) == 0)
			Timer_Event_Flag = 0;
	}
/*
 *	Calculate delta time value in 100 nanosecond slices:
 */
	if (Timer_Event_Flag != 0) {
		Time_Value[0] = - (long) Milliseconds * 10000;
/*
 *	Set up timer entry; wait for event flag:
 */
		Sys_Status = Sys$SeTimr (Timer_Event_Flag, Time_Value, 0, 0);
		if (Check_System_Status (Sys_Status) != 0) {
			Sys_Status = Sys$WaitFr (Timer_Event_Flag);
			Check_System_Status (Sys_Status);
		}
	}
}

/*
 *	Routine Set_Timer sets up a time entry, with an AST specified
 *	to execute upon completion:
 */

unsigned long Set_Timer (Milliseconds, AST_Arg)
unsigned long Milliseconds, AST_Arg;
{
	static long Time_Value[2] = { 0, -1 };
	extern unsigned long Sys$SeTimr(), Timer_AST_Handler();

	Time_Value[0] = - (long) Milliseconds * 10000;
	return (Sys$SeTimr (0, Time_Value, &Timer_AST_Handler, AST_Arg));
}

unsigned long Timer_AST_Handler (Arg, R0, R1, PC, PSL)
unsigned long Arg, R0, R1, PC, PSL;
{
	extern unsigned long Sys$Wake();
	globalvalue SS$_NORMAL;

	EnQueue_AST (AST_TIMER, Arg, 0, PRI_TIMER);
	Sys$Wake (0, 0);
	return (SS$_NORMAL);
}

Cancel_Timer (AST_Arg)
unsigned long AST_Arg;
{
	extern unsigned long Sys$CanTim();

	Sys$CanTim (AST_Arg, PSL$C_USER);
}
