import java.util.*;
import java.io.*;
import javax.swing.*;

/*
 * PrefSlideCommands.java
 *
 * Created on 6. December 2006, 17:10
 */

/**
 *
 *  This class provides access to  the list of the preferred
 *  slide defining commands sorted by popularity.
 * 
 *  The user can manage this list with the PrefSlideCommandsGUI.
 *
 * @author  Olle Nebendahl
 */

class PrefSlideCommands 
{
    static
    {
        loadThem();
//        preferredCommands=new DefaultListModel();
        System.out.println("preferred slidecommands loaded");
    }
    private static DefaultListModel preferredCommands;
    
    private static TreeSet tree;
    
    public static CommandRepresentation getFirst()
    {
        if(preferredCommands.getSize()==0)return new CommandRepresentation("createslide[2]{title}{body}");
        return (CommandRepresentation)preferredCommands.firstElement();
    }
    
    public static CommandRepresentation getWithTargets(CommandRepresentation cr)
    {
        Iterator it = tree.iterator();
        CommandRepresentation crt;
        while(it.hasNext())
        {
            crt=(CommandRepresentation)it.next();
            if(crt.equals(cr))return crt;
        }
        return cr;
    }
    
    public static DefaultListModel getThem() { return preferredCommands; }
    
    public static synchronized void update(DefaultListModel updateList)
    {
        preferredCommands = updateList;
        saveThem();
    }
    
    private static synchronized void loadThem()
    {
        try
        {
            preferredCommands = new DefaultListModel();
            BufferedReader in = new BufferedReader(new FileReader("PrefSlideCommands.ini"));
        
            StringBuffer result=new StringBuffer();

            String zeile=in.readLine();
            String[] splitted;
            
            while(zeile!=null)
            {
                preferredCommands.addElement(new CommandRepresentation(zeile));
                zeile=in.readLine();
            }
            in.close();
            
            arrangeThem();
        }
        catch(java.io.IOException e){ System.out.println(e); System.out.println("PrefSlideCommands.loadThem");};
    }

    static synchronized void saveThem()
    {
        arrangeThem();
        try
        {
            BufferedWriter out = new BufferedWriter(new FileWriter("PrefSlideCommands.ini"));
            
            String zeile;
        
            int preferredCommandsSize=preferredCommands.getSize();
            
            int i = 0;
            
            while(i<preferredCommandsSize)
            {
                zeile=((CommandRepresentation)preferredCommands.get(i++)).toString();
                out.write(zeile,0,zeile.length());
                out.newLine();
            }
            out.close();
        }
        catch(java.io.IOException e){ System.out.println(e); System.out.println("PrefSlideCommands.saveThem");};
    }
    
    static synchronized DefaultListModel checkForSlideCommands(OLL toBeChecked)
    {
        TreeSet checkCommands = new TreeSet();
        toBeChecked.reset();
        while(toBeChecked.hasNext())
        {
            checkCommands.add(toBeChecked.getNext());
        }
        return checkForSlideCommands(checkCommands);
    }
    
    static void arrangeThem()
    {
        tree=new TreeSet();
        int preferredCommandsSize=preferredCommands.getSize();
        
        int i = 0;
        
        while(i<preferredCommandsSize)
        {
            tree.add((CommandRepresentation)preferredCommands.get(i++));
        }
    }
    
    static synchronized DefaultListModel checkForSlideCommands(TreeSet toBeChecked)
    {

        arrangeThem();
        
        
        TreeSet result =new TreeSet(toBeChecked);

        result.retainAll(tree);
        
        DefaultListModel result2 = new DefaultListModel();
        
        CommandRepresentation cr;
        
        while(result.size()>0)
        {
            cr =(CommandRepresentation)result.first();
            result.remove(cr);
            result2.addElement(cr);
        }
        
        return result2;
    }
    
    public static void main(String[] a)
    {
        CommandRepresentation cr = new CommandRepresentation("createslide[2]{title}{body}");
        CommandRepresentation br = new CommandRepresentation("createslide[2]{body}{...}");
        System.out.println(cr);
        System.out.println(br);
        System.out.println(cr.equals(br));
    }
}
