/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.variable;

import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.variable.ValueImpl;
import com.izforge.izpack.util.IoHelper;
import java.io.Serializable;

public class EnvironmentValue
extends ValueImpl
implements Serializable {
    private static final long serialVersionUID = -658114236595736672L;
    public String variable;

    public EnvironmentValue(String variable) {
        this.variable = variable;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    @Override
    public void validate() throws Exception {
        if (this.variable == null || this.variable.length() <= 0) {
            throw new Exception("No or empty environment variable name");
        }
    }

    @Override
    public String resolve() {
        return IoHelper.getenv(this.variable);
    }

    @Override
    public String resolve(VariableSubstitutor ... substitutors) throws Exception {
        String _variable_ = this.variable;
        for (VariableSubstitutor substitutor : substitutors) {
            _variable_ = substitutor.substitute(_variable_);
        }
        return IoHelper.getenv(_variable_);
    }
}

