/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.os.FileQueueOperation;
import com.izforge.izpack.util.os.SystemErrorException;
import com.izforge.izpack.util.os.WinSetupDefaultCallbackHandler;
import com.izforge.izpack.util.os.WinSetupFileQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileQueue {
    private List<FileQueueOperation> operations = new ArrayList<FileQueueOperation>();
    protected WinSetupFileQueue filequeue;
    private final Librarian librarian;

    public FileQueue(Librarian librarian) {
        this.librarian = librarian;
    }

    public void add(FileQueueOperation op) {
        this.operations.add(op);
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public void execute() throws IOException {
        WinSetupDefaultCallbackHandler handler = new WinSetupDefaultCallbackHandler();
        try {
            this.filequeue = new WinSetupFileQueue(this.librarian, handler);
        }
        catch (IOException ioe) {
            throw new IOException("Failed to open a file queue due to " + ioe.getMessage());
        }
        try {
            for (FileQueueOperation operation : this.operations) {
                operation.addTo(this.filequeue);
            }
            this.filequeue.commit();
            List<SystemErrorException> exceptions = handler.getExceptions();
            if (exceptions != null) {
                StringBuilder buf = new StringBuilder();
                buf.append("The following system errors occured during committing the file queue:\n");
                for (SystemErrorException exception : exceptions) {
                    buf.append('\t');
                    buf.append(exception.toString());
                    buf.append('\n');
                }
                throw new IOException(buf.toString());
            }
        }
        catch (IOException ioe) {
            throw new IOException("File queue operation failed due to " + ioe.getMessage());
        }
        finally {
            this.filequeue.close();
        }
    }

    public boolean isRebootNecessary() {
        return this.filequeue != null && this.filequeue.isRebootNecessary();
    }

    public List<FileQueueOperation> getOperations() {
        return this.operations;
    }
}

