/***************************/
/* texgen.h                */
/***************************/

char *romans[MAXTRACKS] =
	{ "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix", "x", "xi", "xii", "xiii", "xiv", "xv", "xvi",
	  "xvii", "xviii", "xix", "xx", "xxi", "xxii", "xxiii", "xxiv", "xxv", "xxvi", "xxvii", "xxviii", "xxix",
	  "xxx" };

/* basically it is possiple to increase this value up to MAXTRACKS if a new version of	*/
/* tex will support that								*/
int CURRENTMAXTRACKS = 9;	/* because of tex there is no possibility to generate	*/
				/* notes of more than 9 tracks				*/

char *notecode[7] = { "cccc", "ccc", "cc", "c", "q", "h", "wh" };
char *restcode[7] = { "qqs", "hs", "qs", "ds", "qp", "hpause", "pause" };
char *static_loudness[8] = { "ppp", "pp", "p", "mp", "mf", "f", "ff", "fff" };
char *dynamic_loudness[8] = { "cresc", "Cresc", "CResc", "CREsc", "dimin", "Dimin", "DImin", "DIMin" };

short INTERFACTEUR = 17;        /* space between two instruments */
short BOTTOMFACTEUR = 14;       /* space between the lines */
short MUSICSIZE = 16;           /* size of music may also be set to 20 */
short PAGENUMBERS = 1;          /* print page numbers (not -> 0) */
short MEASURENUMBERS = 0;       /* print measure numbers (not -> 0; yes -> 1) */
short LINEBREAKER = 15;         /* force a line breaking after more than LINEBREAKER notes or rests */
short INNERBARMAX = 8;          /* force a line breaking after a bar longer than INNERBARMAX */
short INNERBARZ = 18;		/* allow line breaking in the middle of a takt because of many events */ 

/* the following constants specify the position of their events */
char *BASSLYRICPOSITION = "L";
char *VIOLINELYRICPOSITION = "!g";
char *BASSLOUDNESSPOSITION = "I";
char *VIOLINELOUDNESSPOSITION = "!j";

extern struct bind *begin[MAXTRACKS], *akt[MAXTRACKS], *dynhelp;
extern struct KeySig *ks;
extern struct Lyric *ly;
extern struct TimeSig *ts;
extern struct Note *not;
extern struct Rest *re;
extern struct Loudness *lo;

extern char Staffs[MAXTRACKS][100];
extern char texfilename[50];
extern char region[MAXTRACKS];
extern FILE *tfp;
extern char TrackName[MAXTRACKS][80];
extern char positions[42];
extern char UPPLOWSHIFT;

static char Inst[MAXTRACKS][180];

