/****************************************************************************
  PROJECT: MusixTeX PreProcessor
  FILE   : slope.h
  AUTHOR : J. C. Nieuwenhuizen

  copyright (c) FlowerSoft 1995
--*/

#ifndef __SLOPE_H
#define __SLOPE_H

#ifndef __MACRO_H
#include "macro.h"
#endif

#ifndef __NOTE_H               // Style
#include "note.h"
#endif

/****************************************************************************
  class MusicStyle
--*/

class MusicStyle : public Macro 
{
    NESTED_IN(Note)Style style;

 public:
    void MusicStyle::execute( StringList&, Staff& staff );
    
    MusicStyle( const char* name, const char* substitute, NESTED_IN(Note)Style s );
    ~MusicStyle();
};

//-- class MusicStyle //

/****************************************************************************
  class Octavate
--*/

class Octavate : public Macro
{
 public:
    virtual void execute( StringList& parameters, Staff& staff );

    Octavate( const char* name );
    virtual ~Octavate();
};

//-- class Octavate //

/****************************************************************************
  class Slope
--*/

class Slope : public Macro 
{
 public:
    virtual void execute( StringList& parameters, Staff& staff );

    Slope( const char* name );
    virtual ~Slope();
};
//-- class Slope //

/****************************************************************************
  class StemLength
--*/

class StemLength : public Macro
{
 public:
    virtual void execute( StringList& parameters, Staff& staff );

    StemLength( const char* name );
    virtual ~StemLength();
};
//-- class StemLength //

#endif // __SLOPE_H //

