/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "refs.h"
#include "interf.h"
#include "fl_ut.h"
#include "mmenu.h"
#include "re_brow.h"
#include "str_fun.h"
#include "transf.h"
#include "expo_fun.h"
#include "rfnr_fun.h"
#include "re_edit.h"
#include "ks_edit.h"
#include "search.h"
#include "list_fun.h"
#include "list_bib.h"
#include "list_rfd.h"
#include "btch_fun.h"
#include "file_mg.h"
#include "rfd_fun1.h"
#include "stru_fun.h"
#include "initial.h"
#include "medl_ir.h"
#include "drec_fun.h"
#include "f_ver.h"
#include "list_kj.h"
#include "list_abs.h"
#include "refs2tex.h"
#include "srtf.h"
#include "xtrrm.h"



 extern char rdbpfad[PFAD_LEN+1];
 extern char textpfad[PFAD_LEN+1];
 extern char wrtxtbu[WRTXTBU_LEN+1];

 extern char cfg_name[PFAD_LEN+1];

 extern config_set one_config_set;

 

int refsmenu(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option, option_confirm;
 
  strcpy(ein,"menu");
  option = 0;
  option_confirm = 0;
  while (option_confirm!=1)
  {
     sprintf(wrtxtbu,"\nMAIN MENU -- REFERENCES BIBLIOGRAPHIC SOFTWARE V%s"
       " -- [e/l/b/s/d/t/f/i/q]\n",REFS_VERSION);
     wrtxt(wrtxtbu);
     sprintf(wrtxtbu,
      "[e] enter, edit, view\n"   /* 1 */
      "[l] compile lists of references etc.\n" /* 2 */
      "[b] process batch files\n" /* 3 */
      "[s] search references by keywords, authors, title etc.\n" /* 4 */
      "[d] bibliographic/macro format definitions\n"  /* 5 */
      "[t] text files, export/import from/into database\n" /* 6 */
      "[f] file, database and system functions\n" /* 7 */
      "[i] information about References v%s\n" /* 8 */
      "[q] quit, return to the OS",  /* 9 */
       REFS_VERSION);
     option = menu_wahl(ein,wrtxtbu
    );
  
    if (option==1) /* [e] */
    {
      editviewmenu();
      strcpy(ein,"menu");
    }
    if (option==2) /* [l] */
    {
      listmenu();
      strcpy(ein,"menu");
    }
    if (option==4) /* [s] */
    {
      char bbtdatei[PFAD_LEN+1];
      int ok;
      
      /* begin: new in version 4.2 */
      char such_textdatei_name[PFAD_LEN+1];
      strlimcpy(such_textdatei_name,textpfad,PFAD_LEN);
      strlimcat(such_textdatei_name,one_config_set.search_form_name,PFAD_LEN);
      load_file_yn(such_textdatei_name);
      /* end: new in version 4.2 */
      ok = search_main(bbtdatei);
      if (ok && strlen(bbtdatei) > 0)
      {
         re_brow_main(bbtdatei,"-b");
      }
      strcpy(ein,"menu");
    }
    if (option==3) /* [b] */
    {
      batchmenu();
      strcpy(ein,"menu");
    }
    if (option==5) /* [d] */
    {
      rfdmenu();
      strcpy(ein,"menu");
    }
    if (option==6) /* [t] */
    {
      transfermenu();
      strcpy(ein,"menu");
    }
    if (option==7) /* [f] */
    {
      file_and_databasemenu();
      strcpy(ein,"menu");
    }
    if (option==8) /* [f] */
    {
      wrtxt(VERSION_INFO);
      anhalten();
      wrtxt(REFS_DOKUMENTATION);
      dateien_und_pfade_anzeigen();
      strcpy(ein,"menu");
    }
    if (option==9) /* [q] */
    {
      strcpy(ein,"menu");
      wrtxt("\nConfirm to quit References [yes/no]\n");
      option_confirm = menu_wahl(ein,
        "[yes] yes, quit References\n"
        "[ no] no, continue to run References"
        );
      strcpy(ein,"menu");
    }
  } 
  return 1;
}

int batchmenu(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
 
  option = 0;
  strcpy(ein,"menu");
  while (option < 16)
  {
    wrtxt("\nMenu: process batch files [bt/tb/s1/s2/in/ay/rd/rs/ba/br/ui/ed/u/i/d/q]\n");
     option = menu_wahl(ein,
     "[bt] convert bbt-file into tbt-file: bbt -> tbt, [tb] convert: tbt -> bbt\n" /* 1, 2 */
     "[s1] sort bbt-file by reference number field, [s2] sort by text field\n" /* 3, 4*/
     "[in] invert sequence of records in a bbt-file\n" /* 5 */
     "[ay] write `author' and `year' into text field of a bbt-file\n" /* 6 */
     "[rd] remove duplicate records (order of records remains unchanged)\n" /* 7 */
     "[rs] remove duplicate records and sort by reference number\n" /* 8 */
     "[ba] write bbt-file with all records from the current database\n" /* 9*/
     "[br] create bbt-file with range of reference numbers (1st to 2nd record)\n" /* 10 */
     "[ui] write `unique record identifiers' (URID) into text field of a bbt-file\n" /* 11 */
     "[ed] extract duplicate records (text field) to a new bbt-file\n"                   /* 12 */
     "[ u] union of bbt-files A and B: each record of resulting bbt-file C can be\n" /* 13 */
     "     found in A or B or both\n"
     "[ i] intersection of A and B: each record of C can be found in A and B\n" /* 14 */
     "[ d] difference (complement) of A and B: C contains all records of A which\n" /* 15 */
     "     are not found in B\n"
     "[ q] back to main menu"                                           /* 16 */
      );
    if (option==1) /* [bt] */
    {
      bbt2text();
      strcpy(ein,"menu");
    }
    if (option==2) /* [tb] */
    {
      text2bbt();
      strcpy(ein,"menu");
    }
    if (option==3) /* [s1] */
    {
      sortbbt_recno();
      strcpy(ein,"menu");
    }
    if (option==4) /* [s2] */
    {
      sortbbt_text();
      strcpy(ein,"menu");
    }
    if (option==5) /* [in] */
    {
      invertbbt_order();
      strcpy(ein,"menu");
    }
    if (option==6) /* [ay] */
    {
      enternameyear();
      strcpy(ein,"menu");
    }
    if (option==7) /* [r1] */
    {
      remove_double_but_1st();
      strcpy(ein,"menu");
    }
    if (option==8) /* [rs] */
    {
      remove_double_keys();
      strcpy(ein,"menu");
    }
    if (option==9) /* [ba] */
    {
      copy_all_records();
      strcpy(ein,"menu");
    }
    if (option==10) /* [br] */
    {
      extract_range();
      strcpy(ein,"menu");
    }
    if (option==11) /* [ui] */
    {
      write_urid();
      strcpy(ein,"menu");
    }
    if (option==12) /* [ed] */
    {
      extract_text_duplicates();
      strcpy(ein,"menu");
    }
    if (option==13) /* [u] */
    {
      bbt_set_union();
      strcpy(ein,"menu");
    }
    if (option==14) /* [i] */
    {
      bbt_set_intersection();
      strcpy(ein,"menu");
    }
    if (option==15) /* [d] */
    {
      bbt_set_difference();
      strcpy(ein,"menu");
    }
  }
    
   return 1;
}

int editviewmenu(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
 
  option = 0;
  strcpy(ein,"menu");
  while (option < 21)
  {
  wrtxt("\nMenu: enter, edit, view [j1 ... m2/ir/er/fj/ij/ej/lj/fk/ik/lk/ed/c/b/s/q]\n");
   option = menu_wahl(ein,
   "[j1] create empty form for j1-type bibliographic record,\n"
   "     more: [j2], [b1], [b2], [b3], [m1], [m2]\n"                    
                                                       /* 1, 2, 3, 4, 5, 6, 7 */
   "     [ir] import bibliographic record/reference (from form to database),\n" 
   "     [er] export/edit bibliographic record/reference (write to form)\n"    
                                                                     /* 8, 9 */
   "[fj] create empty form for journal data (name, short form ISSN)\n"
   "     [ij] import journal data (from form to database),\n"
   "     [ej] export/edit journal data (write to form),\n"
   "     [lj] list journal data\n"
                                                            /* 10, 11, 12, 13 */
   "[fk] create empty form for keywords (to be transferred to the thesaurus), \n"
   "     [ik] import keywords (from form to thesaurus),\n"
   "     [lk] list keywords\n"
                                                                 /* 14, 15, 16*/
   "[ed] edit text files\n"                                               /* 17 */
   "[ c] browse complete database\n"                                    /* 18 */
   "[ b] browse database records by BBT-file\n"                         /* 19 */
   "[ s] browse records by BBT-file from last search\n"                 /* 20 */
   "[ q] back to main menu"                                             /* 21 */
    );
    if (option==1) /* [j1] */
    {
       char kziffer[KENNZIFFER_LEN+2];
       if (refnr_bereits_vorhanden(kziffer)==0)
       { 
         expo_leer_formular_main("j1",kziffer);
       }
       strcpy(ein,"menu");
       continue;
    }
    if (option==2) /* [j2] */
    {
       char kziffer[KENNZIFFER_LEN+2];
       if (refnr_bereits_vorhanden(kziffer)==0)
       { 
         expo_leer_formular_main("j2",kziffer);
       }
       strcpy(ein,"menu");
       continue;
    }
    if (option==3) /* [b1] */
    {
       char kziffer[KENNZIFFER_LEN+2];
       if (refnr_bereits_vorhanden(kziffer)==0)
       { 
         expo_leer_formular_main("b1",kziffer);
       }
       strcpy(ein,"menu");
       continue;
    }
    if (option==4) /* [b2] */
    {
       char kziffer[KENNZIFFER_LEN+2];
       if (refnr_bereits_vorhanden(kziffer)==0)
       { 
         expo_leer_formular_main("b2",kziffer);
       }
       strcpy(ein,"menu");
       continue;
    }
    if (option==5) /* [b3] */
    {
       char kziffer[KENNZIFFER_LEN+2];
       if (refnr_bereits_vorhanden(kziffer)==0)
       { 
         expo_leer_formular_main("b3",kziffer);
       }
       strcpy(ein,"menu");
       continue;
    }
    if (option==6) /* [m1] */
    {
       char kziffer[KENNZIFFER_LEN+2];
       if (refnr_bereits_vorhanden(kziffer)==0)
       { 
         expo_leer_formular_main("m1",kziffer);
       }
       strcpy(ein,"menu");
       continue;
    }
    if (option==7) /* [m2] */
    {
       char kziffer[KENNZIFFER_LEN+2];
       if (refnr_bereits_vorhanden(kziffer)==0)
       { 
         expo_leer_formular_main("m2",kziffer);
       }
       strcpy(ein,"menu");
       continue;
    }
 
    if (option==8) /* [ir] */
    {
       re_edit_main("reference");
       strcpy(ein,"menu");
       continue;
    }
    if (option==9) /* [er] */
    {
       char kziffer[KENNZIFFER_LEN+2];
       kennziffer_lesen_allein(kziffer);
       expo_formular_main(kziffer);
       strcpy(ein,"menu");
       continue;
    }
    if (option==10) /* [mj] */
    {
       char journal_code[QUELLKUERZEL_LEN + 2];
       strcpy(journal_code,"");
       if (journal_code_bereits_vorhanden(journal_code)==0)
       {
         journal_edit_main("make_empty_journal_form",journal_code);
       }
       strcpy(ein,"menu");
       continue;
    }
    
    if (option==11)  /* [ij] */
    {
       char journal_code[QUELLKUERZEL_LEN + 2];
       strcpy(journal_code,"");
       journal_edit_main("import_journal_code_data","");
       strcpy(ein,"menu");
       continue;
      
    }
    if (option==12)  /* [ej] */
    {
       journal_edit_main("export_edit_journal_data","");
       strcpy(ein,"menu");
       continue;
    }
    if (option==13) /*[lj]*/
    {
       journal_edit_main("list","");
       strcpy(ein,"menu");
       continue;
    }
    if (option==14) /* [fk] */
    {
       keywords_edit_main("make_keywords_form");
       strcpy(ein,"menu");
       continue;
    }
    if (option==15) /* [ik] */
    {
       keywords_edit_main("import");
       strcpy(ein,"menu");
       continue;
    }
    if (option==16) /* [lk] */
    {
       keywords_edit_main("list");
       strcpy(ein,"menu");
       continue;
    }
    if (option==17) /* [ed] */
    {
       edit_text_menu();
       strcpy(ein,"menu");
       continue;
    }
    if (option==18) /* [c] */
    {
       re_brow_main("","-c");
       strcpy(ein,"menu");
       continue;
    }
    if (option==19) /* [b] */
    {
       char pfad[PFAD_LEN+1];

       /* This ist the comfortable way to search a file with path */
       if (datei_suchen_mit_pfad("*.bbt",rdbpfad,pfad))
       {
         re_brow_main(pfad,"-b");
       } else
       {
         wrtxt("\n(No file selected)\n");
       }
       strcpy(ein,"menu");
       continue;
    }  /* end - [b] */    
    if (option==20) /* [s] */
    {
      char bbtdatei[PFAD_LEN+1];
      int ok;
      
      ok = search_last_bbt(bbtdatei);
      if (ok && strlen(bbtdatei) > 0)
      {
         re_brow_main(bbtdatei,"-b");
      }
      strcpy(ein,"menu");
    }
  }
  return 1;
}

int transfermenu(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
 
  option = 0;
  strcpy(ein,"menu");
  while (option < 9)
  {
  wrtxt("\nMenu: text files [im/ex/lt/xr/sr/me/ed/vi/q]\n");
  option = menu_wahl(ein,
   "[im] import data from archive file\n"
   "[ex] export data into archive file\n"
   "[lt] write list of references to LaTeX ``thebibliography'' environment\n"
   "[xr] extract reference numbers from a text file\n"
   "[sr] search and replace operations\n"
   "[me] convert medline input to form\n"
   "[ed] edit text file\n"
   "[vi] view text file\n"
   "[ q] back to main menu"
    );
    if (option==1) /* im: */
    {
       transf_main();    
       strcpy(ein,"menu");
    }
    if (option==2) /* ex: */
    {
       expo_fun_main();    
       strcpy(ein,"menu");
    }
    if (option==3) /* lt: */
    {
       refs2tex_main();    
       strcpy(ein,"menu");
    }
    if (option==4) /* xr: */
    {
       xtrrm_main();    
       strcpy(ein,"menu");
    }
    if (option==5) /* sr: */
    {
       srtf_main();
       strcpy(ein,"menu");
    }
    if (option==6) /* me: */
    {
       medl_ir_main();
       strcpy(ein,"menu");
    }
    if (option==7) /* [ed] */
    {
       edit_text_menu();
       strcpy(ein,"menu");
    }
    if (option==8) /* vi: */
    {
       char textdatei_name[PFAD_LEN + 1];
       if (datei_suchen_mit_pfad("*",textpfad,textdatei_name))
       {
         vtxt(textdatei_name,"");
       }
       strcpy(ein,"menu");
    }
  }
  return 1;
}

int listmenu(void)
{ 
  static char ein[INPUT_BU_LEN+1];
  int option;
 
  option = 0;
  strcpy(ein,"menu");
  while (option < 9)
  {
     wrtxt("\nMenu: make lists of references [s/u/tu/b/m/tm/t/a/q]\n");
     option = menu_wahl(ein,
       "[s] write list of references in standard format\n"      /* 1 */
       "[u] write list with user defined format, \n"            /* 2 */
       "    [tu] test list with user defined format (read fde file)\n"  /* 3 */
       "[b] create list in BibTeX database format\n"              /* 4 */
       "[m] create macro for text processors, sorting \n"            /* 5 */
       "    [tm] test macro with user defined format (read fde-file)\n" /* 6 */
       "[t] write text files with journal names, keywords\n"            /* 7 */
       "[a] export abstracts\n"                 /* 8 */
       "[q] quit"                               /* 9 */
       );
       if (option==1) /* [s] */
       {
          list_fun_main(""); 
          strcpy(ein,"menu");
       }
       if (option==2) /* [u] */
       {
          list_rfd_main("-n",0); 
          strcpy(ein,"menu");
       }
       if (option==3) /* [tu] */
       {
          list_rfd_main("-n",1); 
          strcpy(ein,"menu");
       }
       if (option==4) /* [b] */
       {
          list_bib_main(""); 
          strcpy(ein,"menu");
       }
       if (option==5) /* [m] */
       {
          list_rfd_main("-m",0); 
          strcpy(ein,"menu");
       }
       if (option==6) /* [tm] */
       {
          list_rfd_main("-m",1); 
          strcpy(ein,"menu");
       }
       if (option==7) /* [t] */
       {
          list_kj_main(); 
          strcpy(ein,"menu");
       }
       if (option==8) /* [a] */
       {
          list_abs_main(); 
          strcpy(ein,"menu");
       }
  }
  return 1;

}

int file_and_databasemenu(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
 
  option = 0;
  strcpy(ein,"menu");
  while (option < 9)
  {
     wrtxt("\nMenu: file, database and system functions [f/r/v/d/k/j/s/c/q]\n");
     option = menu_wahl(ein,
       "[f] file manager: delete, rename, duplicate files\n"   /* 1 */
       "[r] rebuild current database\n"                        /* 2 */
       "[v] verify database integrity\n"                       /* 3 */
       "[d] delete references in database\n"                   /* 4 */
       "[k] delete keywords in thesaurus\n"                    /* 5 */
       "[j] delete journal entry\n"                            /* 6 */
       "[s] shell command\n"                                   /* 7 */
       "[c] edit configuration file\n"                         /* 8 */
       "[q] quit"                                              /* 9 */
       );
       if (option==1) /* [f] */
       {
          file_managermenu();
          strcpy(ein,"menu");
       }
       if (option==2) /* [r] */
       {
          stru_fun_main();
          strcpy(ein,"menu");
       }
       if (option==3) /* [v] */
       {
          f_ver_main();
          strcpy(ein,"menu");
       }
       if (option==4) /* [d] */
       {
          drec_fun_main();
          strcpy(ein,"menu");
       }
       if (option==5) /* [k] */
       {
          keywords_edit_main("delete");
          strcpy(ein,"menu");
       }
       if (option==6) /* [j] */
       {
          journal_edit_main("delete","");
          strcpy(ein,"menu");
       }
       if (option==7) /* [s] */
       {
          shell_ausfuehren();
          strcpy(ein,"menu");
       }
       if (option==8) /* [c] */
       {
          char kmdo[PFAD_LEN+1];
          strlimcpy(kmdo,one_config_set.editor_name,PFAD_LEN);
          strlimcat(kmdo," ",PFAD_LEN);
          strlimcat(kmdo,cfg_name,PFAD_LEN);
          system(kmdo);
          anhalten();
          wrtxt("\nChanges become effective after the next program start\n");
          strcpy(ein,"menu");
       }
  }
  return 1;
}

int edit_text_menu(void)
{
   
  static char ein[INPUT_BU_LEN+1];
  int option, option_confirm;
  // static char kommando[PFAD_LEN + 1];
 
  strcpy(ein,"menu");
  option = 0;
  option_confirm = 0;
  while (option_confirm!=1)
  {
    sprintf(wrtxtbu,"\nMenu: edit text file "
      "[r/s/k/j/3/m/t/q]\n");
    wrtxt(wrtxtbu);
    sprintf(wrtxtbu,
      "[r] references form\n" /*1*/
      "[s] search command form\n" /*2*/
      "[k] keywords thesaurus form\n" /*3*/
      "[j] journal data form\n" /*4*/
      "[3] three forms: r+k+j\n" /*5*/
      "[m] more text files\n" /*6*/
      "[t] type text file name\n" /*7*/
      "[q] quit"); /*8*/
    option = menu_wahl(ein,wrtxtbu);
    if (option==1) /* [r] */
    {
       // strlimcpy(kommando,one_config_set.editor_name,PFAD_LEN);
       // strlimcat(kommando," ",PFAD_LEN);
       // strlimcat(kommando,textpfad,PFAD_LEN);
       // strlimcat(kommando,one_config_set.form_name,PFAD_LEN);
       // system(kommando);
       // anhalten();
       textdatei_editieren(one_config_set.form_name);
       strcpy(ein,"menu");
    }
    if (option==2) /* [s] */
    {
       // strlimcpy(kommando,one_config_set.editor_name,PFAD_LEN);
       // strlimcat(kommando," ",PFAD_LEN);
       // strlimcat(kommando,textpfad,PFAD_LEN);
       // strlimcat(kommando,one_config_set.search_form_name,PFAD_LEN);
       // system(kommando);
       // anhalten();
       textdatei_editieren(one_config_set.search_form_name);
       strcpy(ein,"menu");
    }
    if (option==3) /* [k] */
    {
       // strlimcpy(kommando,one_config_set.editor_name,PFAD_LEN);
       // strlimcat(kommando," ",PFAD_LEN);
       // strlimcat(kommando,textpfad,PFAD_LEN);
       // strlimcat(kommando,one_config_set.ky_form_name,PFAD_LEN);
       // system(kommando);
       // anhalten();
       textdatei_editieren(one_config_set.ky_form_name);
       strcpy(ein,"menu");
    }
    if (option==4) /* [j] */
    {
       // strlimcpy(kommando,one_config_set.editor_name,PFAD_LEN);
       // strlimcat(kommando," ",PFAD_LEN);
       // strlimcat(kommando,textpfad,PFAD_LEN);
       // strlimcat(kommando,one_config_set.jn_form_name,PFAD_LEN);
       // system(kommando);
       // anhalten();
       textdatei_editieren(one_config_set.jn_form_name);
       strcpy(ein,"menu");
    }
    if (option==5) /* [e] */
    {
       //strlimcpy(kommando,one_config_set.editor_name,PFAD_LEN);
       //system(kommando);
       //anhalten();
       drei_textdateien_editieren(one_config_set.form_name,
                                  one_config_set.ky_form_name,
                                  one_config_set.jn_form_name);
       strcpy(ein,"menu");
    }
    if (option==6) /* [m] */
    {
       // char maske[WILDCARD_PATTERN_LEN+1];
       char textdatei_name[PFAD_LEN + 1];
       
       // sprintf(wrtxtbu,"Initial characters of file "
       //   "(max. %i) default all files",WILDCARD_PATTERN_LEN-4);
       // ein_zeile(maske,wrtxtbu,WILDCARD_PATTERN_LEN-4);
       // if (strlen(maske)==0)
       // {
       //    strlimcpy(maske,"*.*",WILDCARD_PATTERN_LEN);
       // }
       // else
       // {
       //    strlimcat(maske,"*.*",WILDCARD_PATTERN_LEN);
       // }
       if (datei_suchen_mit_pfad("*",textpfad,textdatei_name))
       {
         // strlimcpy(kommando,one_config_set.editor_name,PFAD_LEN);
         // strlimcat(kommando," ",PFAD_LEN);
         // strlimcat(kommando,textdatei_name,PFAD_LEN);
         // system(kommando);
         textdatei_editieren(textdatei_name);
       }
       else
       {
          wrtxt("\nNo valid file name selected\n");
          anhalten();
       }
       // anhalten();
       strcpy(ein,"menu");
    }

    if (option==7) /* [t]*/
    {
       char textdatei_name[PFAD_LEN + 1];
       int name_ok;
       name_ok = 0;
       while (!name_ok)
       {
          ein_zeile(textdatei_name,"Please type text file name",PFAD_LEN);
          if ((name_ok = isvalidfilename2(textdatei_name)) == 0)
          {
            if (strlen(textdatei_name)==0)
            {
               wrtxt("\n(No text file selected)\n");
               break;
            }
            wrtxt("\nThis is not a valid filename!\n");
          }
       }
       if (strlen(textdatei_name)==0)
       {
          strcpy(ein,"menu");
          continue;   
       }
       
       // strlimcpy(kommando,one_config_set.editor_name,PFAD_LEN);
       // strlimcat(kommando," ",PFAD_LEN);
       // strlimcat(kommando,textpfad,PFAD_LEN);
       // strlimcat(kommando,textdatei_name,PFAD_LEN);
       // system(kommando);
       // anhalten();
       if (!isfile(textdatei_name))
       {
          textdatei_anlegen(textdatei_name);
       }
       textdatei_editieren(textdatei_name);
       strcpy(ein,"menu");

    }
    if (option==8) /* [q] */
    {
      option_confirm = 1;
      strcpy(ein,"menu");
    }
  }
   return 1;
}
