#!/usr/bin/wish8.0
# Tcltexed | Version 2.8 | 02. Nov 2006 | Martin Strauss
set Tcltexed_Version 2.8 
# A plaintext-editor for LaTeX based on scriptlanguage tcl/tk (8.x) 
#
# Copyright (C) 1999 - Martin Strauss -
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# My email-adress : mys@phi.faveve.uni-stuttgart.de
#######################################################################
# Begin of Tcltexed
#######################################################################
set basepath "[file dirname [info script]]/.."
#######################################################################
# If it doesn't work by it's own please enter here the right
# installationpath to the base of tcltexed (not to the executable)
# and uncommend the next line
set basepath /usr/local/app/tcltexed-2.8
#######################################################################
# You propably aren't interested to mix my files locations ???
set menupath $basepath/lib/menu
set txtpath $basepath/txt
set hlppath $basepath/hlp
set gifpath $basepath/gif
set bhtpath $basepath/bht
set etcpath $basepath/etc
set libpath $basepath/lib
#######################################################################
# Where to save options, this should work in the most cases
# without interferring 
switch $tcl_platform(platform) unix {
 set inifile $env(HOME)/.tcltexed
 set spellfileown $env(HOME)/.tcltexed_spell
 set spellfile $etcpath/tcltexed.sp
} windows {
 switch $tcl_platform(os) "Windows 95" {
  set inifile $etcpath/tcltexed.ini
  set spellfileown $etcpath/tcltexed_own.sp
  set spellfile $etcpath/tcltexed.sp
 } "Windows NT" {
  set inifile $env(USERPROFILE)/tcltexed.ini
  set spellfileown $env(USERPROFILE)/tcltexed.sp
  set spellfile $etcpath/tcltexed.sp
 }
}
#######################################################################
# If your colors make problems like ignoring all grey colors etc
# try to set this flag to 1, if it works with 0 it will be faster
set COLOR_flag 0
###############################################################
# If you get tired of the welcome-message on the beginning 
# set the value of readme_flag to 0 (else back to 1) 
set readme_flag 1
# but you will use this window later anyway ...
###############################################################
# If you want to have the stdout messages of latex/dvips shown
# as default, then change this flag to 1
set log_flag 0
#######################################################################
#######################################################################
# defaultvalue for the language 
# englisch 0 , german 1 , indonesia 2, brazilian 3
set language 0

#######################################################################
##########################################################################
# extern Commands make for sure you've the rigth path here
switch $tcl_platform(platform) unix {
 # unix und linux Programme
 set latex_exec "latex"
 set xdvi_exec "xdvi"
 set dvips_exec "dvips"
 set ghostview_exec "ghostview"
 set makeindex_exec "makeindex"
 set ispell_exec "ispell"
} windows {
 # Windows 9x and NT
 set latex_exec  "latex"
 set xdvi_exec "yap"
 set dvips_exec "dvips"
 set ghostview_exec "C:/gstools/gsview/gsview32"
 set makeindex_exec "makeindex"
 set ispell_exec "ispell"
} default {exit}
# interested Mac users should contact me !

##########################################################################
####### There is no point to "repair" anything beyond this line ##########
##########################################################################
# Maximal length of the memory in bytes spend for the UNDO function
# for each window.
set max_undo 10240
#######################################################################
# nown packetes, first named the file (.bth) to load, then the name to
# display
set PLISTE [list latex latex latex_math "+math" latex_other "+more" picture "+picture" tabelle "+tabular/array" notiz "+footnote/marginpar" latex209 "+latex 2.09" amsmath amsmath amssymb amssymb amsfonts amsfonts amscd amscd amsthm amsthm epsf epsf graphics "graphics/x"]
#######################################################################
# "My Own", number of selfdefined buttons
set myown_max 10
#######################################################################
# complition by mouse, number of lines shown at once
set erg2_max 10
#######################################################################
# help on LaTeX-commands, number of lines shown at once
set wlatex_max 20
#######################################################################
# help on Tcltexed, number of lines shown at once
set wTcltexed_max 6
#######################################################################
# number of chars after a line is forced to break
set line_breaking_chars 80
#######################################################################

#######################################################################
# a short test looking if you set your mainpath right
if {![file exists $basepath/bin/tcltexed.tcl]} {
 wm withdraw .
 tk_messageBox -icon error -message "[info script] Tcltexed\nWrong path configuration !\nPlease read the INSTALL file !\n Currently the basepath is set to\n $basepath\nbut I can't find my data there."
 exit
}
#######################################################################
# default font size
set tft_size 12
#######################################################################
# event Delete sei BackSpace
set Delete2BackSpace_flag 0
#######################################################################
# What not to have within a word to spell
# [-0123456789&$^\[\]?\\+*/%=_]
set spell_not "\[-0123456789&$^\\\[\\\]\\\\+*/%=_\]"
set spell_yes "\[ \n\t.,:;!?\\\[\\\]\{\}()\]"
# number of lines shown at once for nearly matched words
set wspell_max 10
#######################################################################
# switch between this letters
set umlaut_with    {\
\\\"a  \\\"A  \\\"o  \\\"O  \\\"u  \\\"U \
\\c\{C\}  \\'e  \\^a  \\`a \
\\c\{c\}  \\"e  \\^e  \\`e  \\'E \
\\^o  \\`o  \\^u  \\`u  \\'a  \\'o  \\'u  \\~n  \\~N \
}
foreach {i j} {\\\\ss  \\\\aa  \\\\\\\"\\\\i  \\\\\\\^\\\\i  \\\\\\\`\\\\i  \\\\\\\'\\\\i  \\\\AA  \\\\ae  \\\\AE } {
 set umlaut_with "$umlaut_with \"$i \" $j \\{$i\\} $j \"$i\\\\ \" \"$j \" $i\\\\ $j\\\\ $i\\n $j\\n $i\\t $j\\t"
}
set umlaut_without {\
 \\\"a  \\\"A  \\\"o  \\\"O  \\\"u  \\\"U \
\\c\{C\}  \\'e  \\^a  \\`a \
\\c\{c\}  \\"e  \\^e  \\`e  \\'E \
\\^o  \\`o  \\^u  \\`u  \\'a  \\'o  \\'u  \\~n  \\~N\
}
foreach {i j} {\\\\ss  \\\\aa  \\\\\\\"\\\\i  \\\\\\\^\\\\i  \\\\\\\`\\\\i  \\\\\\\'\\\\i  \\\\AA  \\\\ae  \\\\AE } {
 set umlaut_without "$umlaut_without $j\\t $i\\t $j\\n $i\\n $j\\\\ $i\\\\ \"$j \" \"$i\\\\ \" $j \"$i \""
}
set umlautgerman_with    {\"a  \"A  \"o  \"O  \"u  \"U  \"s }
set umlautgerman_without { \"a  \"A  \"o  \"O  \"u  \"U  \"s}
#######################################################################
# which ispell dictionary for which language ?
set ispell_dictionary(0) english
set ispell_dictionary(1) deutsch
set ispell_dictionary(2) indo-spell
set ispell_dictionary(3) brazilian
##########################################################################
##########################################################################
# You won't believe it what happens if you ... so leave it the way it is #
##########################################################################
# Testwindow
# eval "toplevel .test\nlabel .test.t1\nlabel .test.t2\npack .test.t1 .test.t2"

 # Editor
 set EDITORNUMMER 0
 # Focus
 set FocusEditorFlag 0
 set FocusEditor ""
 # Filenamen
 set FilenameArray(scratch) "scratch"
 set ModifiedArray(scratch) 0
 set UpToDateArray(scratch) 0
 set GotoArray(scratch) ""
 set UndoArray(scratch) ""
 # Block
 set BlockBeginFlag 0
 set BlockEndFlag 0
 set BlockEditor ""
 # Projekt
 set MasterFlag 0
 set Master ""
 set Masterfile ""
 image create photo MasterBildSlaveOn -file "$gifpath/slaveon.gif"
 image create photo MasterBildSlaveOff -file "$gifpath/slaveoff.gif"
 image create photo MasterBildMasterOn -file "$gifpath/masteron.gif"
 image create photo MasterBildMasterOff -file "$gifpath/masteroff.gif"
 # Search
 set wsearch_gb 1
 # Klammern automatische
 set KlammerFlag 1
 # fuer .wlatex ein ABC
set ABC [list A B C D E F G H I J K L M N O P Q R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t u v w x y z]
 # Syntax
 set syntax_flag 1
 # Startverzeichnis in das gespeichert wird
 set directory [pwd]
 # Spelling
 set spell_flag 1
 # help
 set hlpfile ""
#######################################################################
# tclversion mindestens 8
if {[lindex [split tk_version .] 0] < 8} {
 exit
}
#######################################################################
# tag Farben
# wrong Spelling
set SpellColorRed "#800000"
# Syntax Highlightning
set SyntaxColorBlue Blue
set SyntaxColorRed Red
set SyntaxColorGreen "#007300"
# LaTeX-Befehlsergaenzung
set ErgaenzungGray Gray
# Block
set BlockColor "#e0e0e0"
#######################################################################
# set several default values
source $libpath/arg.tcl

#######################################################################
proc I {name befehl txt back} {
 global T I_befehl I_txt I_back I_state I_flag I_file
 switch $I_flag 2 {
  if [info exists I_befehl($name)] {
   tk_messageBox -message $T(BHTERROR1)$I_file$T(BHTERROR2)$name$T(BHTERROR3)$befehl -icon error -type ok
  } {
   set I_befehl($name) $befehl
   set I_txt($name) $txt
   set I_back($name) $back
   }
 } 0 {
   unset I_state($name)
 } 1 {
  set I_state($name) 1
 }
}
#######################################################################
# Options
source $libpath/options.tcl

LoadOptions
#######################################################################
# set several default fonts
font create tft -family Courier -size $tft_size

#######################################################################
# language
source $libpath/translate$language.tcl
#######################################################################
# virtuelle events
source $libpath/events.tcl

#######################################################################
# Umdefinition des Defaultverhaltens fuer Text-variablen
source $libpath/bindings.tcl

#######################################################################
# Default Color
source $libpath/color.tcl

#######################################################################
# line breaking
source $libpath/linebreak.tcl

#######################################################################
# Oh no, again someone very nosey around !
#######################################################################
# Mainwindow
frame .mb

set LISTE [glob $menupath/*.itm]
set MenuModus 1
set MenuItemList ""
source $menupath/menu
foreach i $LISTE {
 source $i
 lappend ItemList $i 
 lappend MenuItemList "$ItemList"
}
frame .mb.menu
foreach i [lsort $MenuItemList] {
 if [lindex $i 1] {
  .mb.menu.button[lindex $i 0].m add command  -label [lindex [lindex $i 2] $language] -command "makeWindow .menu[lindex $i 0]Item[lindex $i 1] \"[lindex $i 3]\""
 } else {
  menubutton .mb.menu.button[lindex $i 0]  -text [lindex [lindex $i 2] $language] -relief raised -menu .mb.menu.button[lindex $i 0].m
  menu .mb.menu.button[lindex $i 0].m
  pack .mb.menu.button[lindex $i 0] -side left -padx 2m -fill x -expand yes
 }
}



menubutton .mb.button1  -text $T(MW-File) -relief raised -menu .mb.button1.m
menubutton .mb.button2  -text $T(MW-Edit) -relief raised -menu .mb.button2.m
menubutton .mb.button3  -text $T(MW-Options) -relief raised -menu .mb.button3.m
menubutton .mb.button4  -text $T(MW-Help) -relief raised -menu .mb.button4.m

pack .mb.button1 .mb.button2 .mb.button3 .mb.menu .mb.button4 -side left  -padx 2m -fill x -expand yes

menu .mb.button1.m
menu .mb.button2.m
menu .mb.button3.m
menu .mb.button4.m


# Neues EditorFenster
.mb.button1.m add command  -label $T(MW-New) -command {NewFile}
.mb.button1.m add command  -label $T(MW-Load) -command {LoadFile}
.mb.button1.m add command  -label $T(MW-Append) -command {
 if $FocusEditorFlag then {AppendFile $FocusEditor}
}
.mb.button1.m add command  -label $T(MW-Save) -command {
 if $FocusEditorFlag then {SaveFile $FocusEditor}
}
.mb.button1.m add command  -label $T(MW-SaveAs) -command {
 if $FocusEditorFlag then {SaveAsFile $FocusEditor}
}
.mb.button1.m add command  -label $T(MW-Quit) -command {ALLQUIT}

.mb.button2.m add command  -label $T(MW-Clear) -command {CLEAR}
menu .mb.button2.m.m1
.mb.button2.m.m1 add command  -label $T(LB-all) -command \
{if {$FocusEditorFlag} {Line_breaking_switch $FocusEditor.te.edit1 all}}
.mb.button2.m.m1 add command  -label $T(LB-section) -command {if $FocusEditorFlag {Line_breaking_switch $FocusEditor.te.edit1 section}}
.mb.button2.m.m1 add command  -label $T(LB-line) -command {if $FocusEditorFlag {Line_breaking_switch $FocusEditor.te.edit1 line}}
.mb.button2.m.m1 add command  -label $T(LB-unall) -command {if $FocusEditorFlag {Line_breaking_switch $FocusEditor.te.edit1 unall}}
.mb.button2.m.m1 add command  -label $T(LB-unsection) -command {if $FocusEditorFlag {Line_breaking_switch $FocusEditor.te.edit1 unsection}}
.mb.button2.m.m1 add command  -label $T(LB-unline) -command {if $FocusEditorFlag {Line_breaking_switch $FocusEditor.te.edit1 unline}}
.mb.button2.m add cascade -label $T(LB-breakline) -menu .mb.button2.m.m1
.mb.button2.m add command  -label $T(MW-Spelling) -command \
{if $FocusEditorFlag {spell $FocusEditor.te.edit1 show 1.0 end}}
.mb.button2.m add command  -label $T(MW-Spell) -command {if $FocusEditorFlag {spell $FocusEditor.te.edit1 add 1.0 end}}
.mb.button2.m add command  -label $T(MW-Umlaut_with) -command {umlaut $umlaut_with}
.mb.button2.m add command  -label $T(MW-Umlaut_without) -command {umlaut $umlaut_without}
.mb.button2.m add command  -label $T(MW-UmlautGerman_with) -command {umlaut $umlautgerman_with}
.mb.button2.m add command  -label $T(MW-UmlautGerman_without) -command {umlaut $umlautgerman_without}
.mb.button2.m add command  -label $T(MW-Search) -command {InitSearch}
.mb.button2.m add command  -label $T(MW-MyOwn) -command {InitMyOwn}

.mb.button3.m add checkbutton -variable KlammerFlag  -label $T(MW-AutoKlammerZu)
.mb.button3.m add checkbutton -variable syntax_flag -label $T(MW-Syntax)
.mb.button3.m add checkbutton -variable log_flag -label $T(MW-log)
menu .mb.button3.m.m1
foreach {i n} $PLISTE {
 set I_file $bhtpath/$i.bht
 set I_flag 2
 source $bhtpath/$i.bht
 .mb.button3.m.m1 add checkbutton -variable Package($i) -label $n -command "set I_file $bhtpath/\$i.bht\nset I_flag \$Package($i)\nsource $bhtpath/$i.bht"
}
set LISTE [lsort [array names I_befehl]]
set wlatex_LISTE ""
foreach i $ABC {
 lappend wlatex_LISTE [lsearch -glob $LISTE $i*]
}
unset LISTE
.mb.button3.m add cascade -label $T(MW-Packages) -menu .mb.button3.m.m1
menu .mb.button3.m.m2
.mb.button3.m.m2 add radiobutton -variable language -value 0 -label $T(MW-english) -command {tk_messageBox -message $T(MW-language-msg)} 
.mb.button3.m.m2 add radiobutton -variable language -value 1 -label $T(MW-german) -command {tk_messageBox -message $T(MW-language-msg)}  
.mb.button3.m.m2 add radiobutton -variable language -value 2 -label $T(MW-indonesia) -command {tk_messageBox -message $T(MW-language-msg)}  
.mb.button3.m.m2 add radiobutton -variable language -value 3 -label $T(MW-bre) -command {tk_messageBox -message $T(MW-language-msg)}  
.mb.button3.m add cascade -label $T(MW-language) -menu .mb.button3.m.m2
menu .mb.button3.m.m3

 foreach i {6 8 10 12 14 16 18 20 22 24} {
  .mb.button3.m.m3 add radiobutton -variable tft_size -value $i -label $i -command "font configure tft -size $i"
 }
.mb.button3.m add cascade -label $T(MW-size) -menu .mb.button3.m.m3
.mb.button3.m add command -label $T(MW-SaveOptions) -command {SaveOptions}

.mb.button4.m add command -label $T(MW-Version) -command {InitVersion}
.mb.button4.m add command -label $T(MW-Tcltexed) -command {InitTcltexed}
.mb.button4.m add command -label $T(MW-LaTeX) -command {InitListen}

wm resizable . 0 0
wm protocol . WM_DELETE_WINDOW {ALLQUIT}
#######################################################################
proc CLEAR {} {
 global FocusEditorFlag T FocusEditor
 if $FocusEditorFlag then {
  if {[winfo exists .wclear] == 0} then {
   set sp [tk_messageBox -icon question -message $T(MW-Clear-msg) -type okcancel]
   switch $sp ok {
    $FocusEditor.te.edit1 delete 1.0 end
}}}}

proc ALLQUIT {} {
 global ModifiedArray T
 set Flag 1 
 set ID [array startsearch ModifiedArray] 
 while {[array anymore ModifiedArray $ID] && $Flag} {
  if $ModifiedArray([array nextelement ModifiedArray $ID]) then {
   set Flag 0
  }
 }
 array donesearch ModifiedArray $ID
 if {$Flag == 0} then {
  switch [tk_messageBox -message $T(ALLQUIT1) -icon question -type yesnocancel] yes {
   switch [tk_messageBox -message $T(ALLQUIT2) -icon question -type yesnocancel] yes {
    set ID [array startsearch ModifiedArray]
    while {[array anymore ModifiedArray $ID]} {
     set E [array nextelement ModifiedArray $ID]
     if $ModifiedArray($E) then {
      set ed [string range $E 0 [expr [string length $E] - 10]]
      focus $ed
      SaveFile $ed
    }}
    set Flag 1
    set ID [array startsearch ModifiedArray]
    while {[array anymore ModifiedArray $ID] && $Flag} {
     if $ModifiedArray([array nextelement ModifiedArray $ID]) then {
      set Flag 0
     }
    }
    if $Flag then {destroy .}
   } no {
    set Flag 1
    set ID [array startsearch ModifiedArray]
    while {[array anymore ModifiedArray $ID] && $Flag} {
     set E [array nextelement ModifiedArray $ID]
     if $ModifiedArray($E) then {
      set ed [string range $E 0 [expr [string length $E] - 10]]
      focus $ed
      switch [tk_messageBox -parent $ed -message $T(ALLQUIT3)[wm title $ed] -icon question -type yesnocancel] yes {
       SaveFile $ed
      } no {} cancel {
       set Flag 0
      }
    }}
    if $Flag then {destroy .}
   } cancel {}
  } no {destroy .} cancel {}
 } else {destroy .}
 spell_save
}
#######################################################################
proc makeWindow {NAME S} {
 global T language
 global packstring
 if {[winfo exists $NAME] == 0} then {
  set MenuModus 0
  toplevel $NAME
  set packstring ""
  source $S
  button $NAME.q -text $T(Quit) -command "destroy $NAME"
  pack  $NAME.q
  bind $NAME <Control-c> {
   destroy %W
  }
  bind $NAME <<Help>> "set ksp \[winfo containing -displayof $NAME \[winfo pointerx $NAME\] \[winfo pointery $NAME\]\]\n if {\$ksp != \"\"} then {event generate \$ksp <<HelpHelp>>}"

  bind $NAME <Button-3> "set ksp \[winfo containing -displayof $NAME \[winfo pointerx $NAME\] \[winfo pointery $NAME\]\]\n if {\$ksp != \"\"} then {event generate \$ksp <<HelpHelp>>}"

  wm resizable $NAME 0 0
  COLOR $NAME
 } else {focus $NAME}
}



 pack .mb   -pady 2m -fill x
 COLOR .
#######################################################################
















#######################################################################
proc Master {E} {
 global MasterFlag Master
 if $MasterFlag then {
  if [string compare $Master $E] then {
   $Master.todo.master configure -image MasterBildSlaveOff
   set Master $E
   $Master.todo.master configure -image MasterBildMasterOn
  } else {
   set MasterFlag 0
   $Master.todo.master configure -image MasterBildSlaveOn
 }} else {
  set MasterFlag 1
  set Master $E
  $Master.todo.master configure -image MasterBildMasterOn
 }
}
proc MasterFocus {NEW OLD} {
 global MasterFlag Master
 global FocusEditorFlag FocusEditor
 if $MasterFlag then {
  if [string compare $Master $NEW] then {
   $NEW.todo.master configure -image MasterBildSlaveOn
  } else {
   $NEW.todo.master configure -image MasterBildMasterOn
  }
  if $FocusEditorFlag then {
   if [string compare $NEW $OLD] then {
    if [string compare $Master $OLD] then {
     $OLD.todo.master configure -image MasterBildSlaveOff
    } else {
     $OLD.todo.master configure -image MasterBildMasterOff
  }}}
 } else {
  $NEW.todo.master configure -image MasterBildSlaveOn
  if [string compare $NEW $OLD] then {
   if $FocusEditorFlag then { $OLD.todo.master configure -image MasterBildSlaveOff}
  }}
 set FocusEditorFlag 1
 set FocusEditor $NEW
}
proc MasterBefehl {E BEFEHL} {
 global latex_exec xdvi_exec dvips_exec ghostview_exec makeindex_exec ispell_exec
 global MasterFlag Master
 global FilenameArray UpToDateArray
 global tcl_platform
 global ispell_dictionary language
 global log_flag
 if $MasterFlag then {
  set Q $Master
 } else {
  set Q $E
 }
 # Entfernt die Endung des Quellfiles (.tex)
 set FILE [string range $FilenameArray($Q) 0 [expr [string length $FilenameArray($Q)] - 5]]

 # Setzt Pfad fuer die Bearbeitung
 set nowpath [pwd]
 cd [file dirname $FilenameArray($Q)]

 switch $tcl_platform(platform) unix {
  switch $BEFEHL latex {
   SaveFile $E
   # Entfernt die Endung des Quellfiles (.tex)
   set FILE [string range $FilenameArray($Q) 0 [expr [string length $FilenameArray($Q)] - 5]]
   # Setzt Pfad fuer die Bearbeitung
   set nowpath [pwd]
   cd [file dirname $FilenameArray($Q)]
   catch {exec xterm -e $latex_exec "$FILE.tex"} error
   if { $log_flag } then {
    if [file exists $FILE.log] then {
     set f [open $FILE.log r]
     set error [read $f]
     set t [close $f]
    }
   }
   if [file exists $FILE.idx] then {
    catch {exec xterm -e $makeindex_exec "$FILE.idx"} error2
    set error "$error\n\n$error2"
   }
   if { $log_flag } then {
    Init_wmsg $Q "$error"
   }
  } xdvi {
   catch {exec $xdvi_exec "$FILE.dvi" &} error
  } dvips {
   catch {set error [exec $dvips_exec "$FILE.dvi" -o "$FILE.ps"]} error
   if { $log_flag } then {
    Init_wmsg $Q "$error"
   }
  } ghostview {
   catch {exec $ghostview_exec "$FILE.ps" &} error
  } ispell {
   SaveFile $E
   catch {exec xterm -e $ispell_exec -t -d $ispell_dictionary($language) "$FILE.tex"} error
   ReLoadFileArg $E "$FILE.tex"
  }
 } windows {
  switch $BEFEHL latex {
   SaveFile $E
   # Entfernt die Endung des Quellfiles (.tex)
   set FILE [string range $FilenameArray($Q) 0 [expr [string length $FilenameArray($Q)] - 5]]
   # Setzt Pfad fuer die Bearbeitung
   set nowpath [pwd]
   cd [file dirname $FilenameArray($Q)]
   catch {exec xterm -e $latex_exec "$FILE.tex"} error
   catch {exec $latex_exec "$FILE.tex"} error
   if [file exists $FILE.idx] then {
    catch {exec $makeindex_exec "$FILE.idx"} error2
    set error "$error\n\n$error2"
   }
   Init_wmsg $Q "$error"
  } xdvi {
   catch {exec $xdvi_exec "$FILE.dvi" &} error
  } dvips {
   catch {exec $dvips_exec "$FILE.dvi" -o "$FILE.ps"} error
   Init_wmsg $Q "$error"
  } ghostview {
   catch {exec $ghostview_exec "$FILE.ps" &} error
  } ispell {
  }
 } default {}

 # Setzt Pfad zurueck
 cd $nowpath
}
proc Init_wmsg {E error} {
  global T

  if ![winfo exists $E.wmsg] then {
   toplevel $E.wmsg
   frame $E.wmsg.f
   scrollbar $E.wmsg.f.vscroll -relief sunken -command "$E.wmsg.f.l yview"
   
   text $E.wmsg.f.l -yscroll "$E.wmsg.f.vscroll set"
   pack $E.wmsg.f.vscroll  -side right -fill y
   pack $E.wmsg.f.l -expand yes -fill both
   button $E.wmsg.butQ -text $T(quit) -command "destroy $E.wmsg"
   
   pack $E.wmsg.f $E.wmsg.butQ
   wm title $E.wmsg $T(wmsg-titel)
   COLOR $E.wmsg
   bind $E.wmsg.f.l <Button> "Line_wmsg $E" 
  }
  $E.wmsg.f.l configure -state normal
  $E.wmsg.f.l delete 1.0 end
  $E.wmsg.f.l insert 1.0 $error
  $E.wmsg.f.l configure -state disabled
  $E.wmsg.f.l see end
  focus $E.wmsg
}
proc Line_wmsg E {
  if {[string compare [$E.wmsg.f.l get "insert linestart"] "!"]==0} {
   set lpos [$E.wmsg.f.l index "insert linestart + 1 l"]
  } {
   set lpos [$E.wmsg.f.l search -backwards -regexp "^l\\..* .*" insert]
 }
 $E.wmsg.f.l see $lpos
 set txt [$E.wmsg.f.l get $lpos "$lpos lineend"]
 if [string match "l.* *" $txt] {
  set pos [string first " " $txt]
  $E.te.edit1 mark set insert "[string range $txt 2 [expr $pos -1]].[expr [string length $txt] - $pos]"
  event generate $E.te.edit1 <<Position_tail>> -when tail
  update
 }
}
proc EDITORQUIT {E} {
 global ModifiedArray T
 if $ModifiedArray($E.te.edit1) then {
   set sp [tk_messageBox -message $T(EDITORQUIT) -icon question -type yesnocancel]
   switch $sp yes {
    SaveFile $E
    destroy $E
   } no {
    destroy $E
   }
 } else {destroy $E}
}
#######################################################################
# Are i am in the inquisitation ??? What are you looking for ?
#######################################################################
proc EDITOR {} {
 global FilenameArray UpToDateArray EDITORNUMMER ModifiedArray GotoArray UndoArray FocusEditor T
 global BeginFlag BeginRealy
 global erg_flag tcl_platform
 global SpellColorRed BlockColor SyntaxColorGreen SyntaxColorRed SyntaxColorBlue ErgaenzungGray
 global Delete2BackSpace_flag
 global have_ispell_flag
 incr EDITORNUMMER
 set E ".editor$EDITORNUMMER"
 set FilenameArray($E) scratch
 set UpToDateArray($E) 0
 set UndoArray($E.te.edit1) ""
 set BeginFlag($E.te.edit1) 0
 set BeginRealy($E.te.edit1) 0
 set erg_flag($E.te.edit1) 0
 set GotoArray($E.te.edit1) ""
 set var$E.wcurser ""
 toplevel $E
 frame $E.todo
 button $E.todo.master -image MasterBildSlaveOn -command "Master $E"
 
 button $E.todo.save -text $T(Save) -command "SaveFile $E"
 
 button $E.todo.saveas -text $T(SaveAs) -command "SaveAsFile $E"
  
 button $E.todo.latex -text $T(EDITOR-latex) -command "MasterBefehl $E latex"
 button $E.todo.xdvi -text $T(EDITOR-xdvi) -command "MasterBefehl $E xdvi"
 button $E.todo.dvips -text $T(EDITOR-dvips) -command "MasterBefehl $E dvips"
 button $E.todo.gv -text $T(EDITOR-ghostview) -command "MasterBefehl $E ghostview"
 button $E.todo.ispell -text $T(EDITOR-ispell) -command "MasterBefehl $E ispell"

 button $E.todo.pos -text "$T(EDITOR-ZS) END" -width 12 -command "Init_curser $E"
 button $E.todo.syntax -text $T(EDITOR-Syntax) -command "Syntax $E.te.edit1 1.0 end"
 button $E.todo.quit -text $T(Quit) -command "EDITORQUIT $E"
 
 pack $E.todo.master $E.todo.save $E.todo.saveas $E.todo.latex $E.todo.xdvi $E.todo.dvips $E.todo.gv $E.todo.ispell $E.todo.syntax $E.todo.quit $E.todo.pos -side left -fill x
 pack $E.todo -fill x

 frame $E.te -relief raised -borderwidth 2
 scrollbar $E.te.vscroll -relief sunken -command "$E.te.edit1 yview"
 text $E.te.edit1 -font tft -yscroll "$E.te.vscroll set"
 
 pack $E.te.vscroll  -side right -fill y
 pack $E.te.edit1 -expand yes -fill both
 pack $E.te  -expand yes -fill both
 bind $E.te.edit1 <Control-d> {}
 bind $E <Enter> "UpToDateFile $E" 
 bind $E.te.edit1 <<Help>> {HelpTo %W}
 bind $E.te.edit1 <Control-k><x> "SaveFile $E"
 bind $E.te.edit1 <Control-k><d> "SaveAsFile $E"
 bind $E <FocusIn> "erg_proc $E.te.edit1 \n MasterFocus $E \$FocusEditor"
 MasterFocus $E $FocusEditor
 if {$Delete2BackSpace_flag == 0} {
  bind $E.te.edit1 <Delete> {
   if $erg_flag(%W) then {
    proc_undo %W
    set erg_flag(%W) 0
    break
   } else {
    undo_switch %W {Save SelSave DeleteKey UndoMax}
    Syntax %W "insert linestart" "insert lineend"
   }
  }
  bind $E.te.edit1 <BackSpace> {
   undo_switch %W {Save SelSave BackSpaceKey UndoMax}
   Syntax %W "insert linestart" "insert lineend"
   event generate $FocusEditor.te.edit1 <<Position_tail>> -when tail
  }
 } else {
  bind $E.te.edit1 <Delete> {
   if $erg_flag(%W) then {
     proc_undo %W
     set erg_flag(%W) 0
     break
   } else {
    undo_switch %W {Save SelSave BackSpaceKey UndoMax}
    Syntax %W "insert linestart" "insert lineend"
    event generate $FocusEditor.te.edit1 <<Position_tail>> -when tail
    if {[%W tag nextrange sel 1.0 end] != ""} {
        %W delete sel.first sel.last
    } elseif [%W compare insert != 1.0] {
        %W delete insert-1c
        %W see insert
    }
   }
   break
  }
  bind $E.te.edit1 <BackSpace> {
   event generate %W <Delete>
   break
  }
 }
 set ModifiedArray($E.te.edit1) 0
 bind $E.te.edit1 <<Position>> "event generate $E.te.edit1 <<Position_tail>> -when tail"
 bind $E.te.edit1 <<Position_tail>> "$E.todo.pos configure -text \"$T(EDITOR-ZS) \[$E.te.edit1 index insert\]\"\nif \[winfo exists $E.wcurser\] {$E.wcurser.pos configure -text \"$T(EDITOR-ZS) \[$E.te.edit1 index insert\]\"}"
 bind  $E.te.edit1 <<Modified>> {
  set ModifiedArray(%W) 1
 }
 bind $E.te.edit1 <<ERG>> {
  ergaenzung %W
 }
 bind $E.te.edit1 <<BeginFlag>> {
  set BeginFlag(%W) 0
  erg_proc %W
  event generate $FocusEditor.te.edit1 <<Position_tail>> -when tail
 }
 bind $E.te.edit1 <<proc_undo>> {
  undo_switch %W Save
  event generate $FocusEditor.te.edit1 <<BeginFlag>>
 }
 bind $E.te.edit1 <F2> "SaveFile $E"
 bind $E.te.edit1 <F3> {LoadFile}
 bind $E.te.edit1 <F4> "$E.te.edit1 see insert"
 bind $E.te.edit1 <F9> "MasterBefehl $E latex"
 bind $E.te.edit1 <Alt-x> {ALLQUIT}
 bind $E.te.edit1 <Alt-BackSpace> "pop_menu $E.te.edit1 Undo"
 bind $E.te.edit1 <Shift-Delete> "pop_menu $E.te.edit1 Cut"
 bind $E.te.edit1 <Control-Insert> "pop_menu $E.te.edit1 Copy"
 bind $E.te.edit1 <Shift-Insert> "pop_menu $E.te.edit1 Paste"
 bind $E.te.edit1 <Control-Delete> "pop_menu $E.te.edit1 Clear"
 bind $E.te.edit1 <Control-l> {
  if [winfo exists .wsearch] then {
   .wsearch.f1.but2 invoke
  }
 }
 bind $E.te.edit1 <Control-w> {ergaenzung2 %W}
 wm protocol $E WM_DELETE_WINDOW "EDITORQUIT $E"
 menu $E.pop_menu
 $E.pop_menu add command -label $T(pop_menu-Undo) -command "pop_menu $E.te.edit1 Undo"
 $E.pop_menu add separator
 $E.pop_menu add command -label $T(pop_menu-Cut) -command "pop_menu $E.te.edit1 Cut"
 $E.pop_menu add command -label $T(pop_menu-Copy) -command "pop_menu $E.te.edit1 Copy"
 $E.pop_menu add command -label $T(pop_menu-Paste) -command "pop_menu $E.te.edit1 Paste" 
 $E.pop_menu add command -label $T(pop_menu-Clear) -command "pop_menu $E.te.edit1 Clear" 
 $E.pop_menu add separator
 $E.pop_menu add command -label $T(pop_menu-Spell) -command "pop_menu $E.te.edit1 Spell" 
 $E.pop_menu add separator
 $E.pop_menu add command -label $T(pop_menu-Block) -command "pop_menu $E.te.edit1 Block" 
 $E.pop_menu add command -label $T(pop_menu-plus) -command "pop_menu $E.te.edit1 AusKomm"
 $E.pop_menu add command -label $T(pop_menu-minus) -command "pop_menu $E.te.edit1 AusKommRueck"
 $E.pop_menu add command -label $T(pop_menu-more) -command "ergaenzung2 $E.te.edit1"
 if {[lindex [split [info tclversion] .] 0] > 7} {
  switch $tcl_platform(platform) unix {
  } windows {
   $E configure -menu $E.pop_menu
 }}
 bind $E.te.edit1 <Button-3> "tk_popup $E.pop_menu \[winfo pointerx $E\] \[winfo pointery $E\]"
 bind $E.te.edit1 <ssharp> {
  if {[%W tag nextrange sel 1.0 end] != ""} {
   undo_switch %W Save
   %W insert sel.last "\}"
   %W tag add undo sel.last sel.last+1c
   %W mark set insert sel.first
   %W insert insert "\{\\"
   %W tag add undo insert-2c insert
   %W tag remove sel 1.0 end
   undo_switch %W {Save UndoMul}
   break 
  }
 }
 $E.te.edit1 tag add spell 1.0 1.0
 $E.te.edit1 tag add syntax_blue 1.0 1.0
 $E.te.edit1 tag add syntax_red 1.0 1.0
 $E.te.edit1 tag add syntax_green 1.0 1.0
 $E.te.edit1 tag add BlockTag 1.0 1.0
 $E.te.edit1 tag add erg_tag 1.0 1.0
 $E.te.edit1 tag raise spell
 $E.te.edit1 tag raise syntax_red
 $E.te.edit1 tag raise syntax_green
 $E.te.edit1 tag raise syntax_blue
 $E.te.edit1 tag raise BlockTag
 $E.te.edit1 tag raise erg_tag
 $E.te.edit1 tag raise sel
 $E.te.edit1 tag configure spell -foreground $SpellColorRed
 $E.te.edit1 tag configure syntax_blue -foreground $SyntaxColorBlue
 $E.te.edit1 tag configure syntax_green -foreground $SyntaxColorGreen
 $E.te.edit1 tag configure syntax_red -foreground $SyntaxColorRed
 $E.te.edit1 tag configure BlockTag -background $BlockColor
 $E.te.edit1 tag configure erg_tag -background $ErgaenzungGray
 $E.te.edit1 tag bind spell <Double-ButtonPress> "spell $E.te.edit1 add 1.0 end"
 focus $E.te.edit1
 COLOR $E
 $E.te.edit1 configure -background White
 return $E
}
 
proc pop_menu {E Fall} {
 global BlockBeginFlag BlockEndFlag BlockEditor BlockColor UndoArray
 switch $Fall Cut {
   undo_switch $E {SelSave UndoMax}
   tk_textCut $E
   Syntax $E "insert linestart" "insert lineend"
 } Copy {
  tk_textCopy $E
 }  Paste {
  set ksp [$E index {insert linestart}]
  undo_switch $E {Save SelSave UndoBegin}
  if {[$E tag nextrange sel 1.0 end] != ""} {
   $E delete sel.first sel.last
  }
  tk_textPaste $E
  undo_switch $E {UndoEnd SelMul UndoMax}
  Syntax $E $ksp "insert lineend"
 } Clear {
  if {[$E tag nextrange sel 1.0 end] != ""} {
   undo_switch $E {SelSave UndoMax}
   $E delete sel.first sel.last
   Syntax $E "insert linestart" "insert lineend"
  }
 } Spell {
  spell $E show 1.0 end
 } Block {
  if {[$E tag nextrange sel 1.0 end] != ""} {
   if {$BlockBeginFlag && $BlockEndFlag} then {$BlockEditor tag remove BlockTag 1.0 end}
   set BlockBeginFlag 1
   set BlockEndFlag 1
   set BlockEditor $E
   $E mark set BlockBegin [$E index sel.first]
   $E mark set BlockEnd [$E index sel.last]
   $E mark gravity BlockEnd left
   $E tag add BlockTag BlockBegin BlockEnd
  }
 } AusKomm {
  if {[$E tag nextrange sel 1.0 end] != ""} {
   AusKomm $E sel.first sel.last
  }
 } AusKommRueck {
  if {[$E tag nextrange sel 1.0 end] != ""} {
   AusKommRueck $E sel.first sel.last
  }
 } Undo {
  proc_undo $E
 }
}

######################################################################
# file routines (load save new saveas append)
source $libpath/file.tcl

#######################################################################
# Setzt backslash's fuer eine Stringuebergabe ein
source $libpath/backslash.tcl

#######################################################################
# search routine
source $libpath/search.tcl

#######################################################################
# search routine
source $libpath/umlaut.tcl

########################################################################
########################################################################
# spelling
source $libpath/spelling.tcl
spell_load

#######################################################################
# pack-hilfe fuer buttons
set packstring ""
proc addpack {T} { 
 global packstring
 lappend packstring $T
}
#######################################################################
# picture-button
proc FRLIAN {FRAME LISTE ANZ START} {
 global txtpath gifpath hlppath
 global I_befehl I_txt I_back
 set ii 1
 set fr 1
 frame $FRAME.$START$fr
 set i infty
 foreach i $LISTE {
  set x [backslash $I_befehl($i)]
  button $FRAME.$START$fr.but$i -image [Bild $i] -command "if \$FocusEditorFlag then {focus \$FocusEditor.te.edit1 \nset ksp \[\$FocusEditor.te.edit1 index \"insert linestart\"\]\n undo_switch \$FocusEditor.te.edit1 {Save UndoBegin}\n\$FocusEditor.te.edit1 insert insert \"$x\"\nundo_switch \$FocusEditor.te.edit1 {UndoEnd Save}\n\$FocusEditor.te.edit1 mark set insert \"insert - $I_back($i) chars\"\n Syntax \$FocusEditor.te.edit1 \$ksp \"insert lineend\"\n  event generate \$FocusEditor.te.edit1 <<Modified>>}"
  bind $FRAME.$START$fr.but$i <<Help>> "Help $i"
  bind $FRAME.$START$fr.but$i <<HelpHelp>> "Help $i"
  if {$ii == $ANZ} then {
   set ii 0
   incr fr
   frame $FRAME.$START$fr
  }  
  incr ii
 }
 set ii 1
 set fr 1
 foreach i $LISTE {
  pack $FRAME.$START$fr.but$i -side left
  if {$ii == $ANZ} then {
   pack $FRAME.$START$fr -side top
   set ii 0
   incr fr
  }  
  incr ii
 }
 pack $FRAME.$START$fr -side top
}

#######################################################################
# text-button
proc buttonmake {NAME buttonmakecount latex} {
 global I_befehl I_txt I_back
 set t "[backslash "$I_befehl($latex)"]"
    
  
 button $NAME.but$buttonmakecount -text $I_txt($latex)  -command "if \$FocusEditorFlag then {\n focus \$FocusEditor.te.edit1 \n set ksp \[\$FocusEditor.te.edit1 index \"insert linestart\"\]\n undo_switch \$FocusEditor.te.edit1 {Save UndoBegin}\n\$FocusEditor.te.edit1 insert insert \"$t\"\nundo_switch \$FocusEditor.te.edit1 {UndoEnd Save}\n\$FocusEditor.te.edit1 mark set insert \"insert - $I_back($latex) chars\"\n Syntax \$FocusEditor.te.edit1 \$ksp \"insert lineend\"\n event generate \$FocusEditor.te.edit1 <<Modified>>}"
 bind $NAME.but$buttonmakecount <<Help>> "Help $latex"
 bind $NAME.but$buttonmakecount <<HelpHelp>> "Help $latex"
 addpack $NAME.but$buttonmakecount
}

#######################################################################
# myown Buttons
proc InitMyOwn {} {
 global FocusEditorFlag FocusEditor myown myown_max T
 if ![winfo exists .wmyown] then {
  toplevel .wmyown
  wm title .wmyown $T(wmyown-titel)
  for {set i 0} {$i < $myown_max} {incr i} {
   frame .wmyown.f$i
   entry .wmyown.f$i.text -width 20 -relief sunken -textvariable myown($i) -background White
   button .wmyown.f$i.but  -command "if \$FocusEditorFlag {focus \$FocusEditor.te.edit1\n set ksp \[\$FocusEditor.te.edit1 index \"insert linestart\"\]\n undo_switch \$FocusEditor.te.edit1 {Save UndoBegin}\n \$FocusEditor.te.edit1 insert insert \[.wmyown.f$i.text get\]\n undo_switch \$FocusEditor.te.edit1 {UndoEnd Save}\n Syntax \$FocusEditor.te.edit1 \$ksp \"insert lineend\"\n event generate \$FocusEditor.te.edit1 <<Position_tail>> -when tail}"
   menu .wmyown.f$i.pop_menu 
 .wmyown.f$i.pop_menu add command -label $T(pop_menu-Cut) -command "event generate .wmyown.f$i.text <<Cut>>"
 .wmyown.f$i.pop_menu add command -label $T(pop_menu-Copy) -command "event generate .wmyown.f$i.text <<Copy>>"
 .wmyown.f$i.pop_menu add command -label $T(pop_menu-Paste) -command "event generate .wmyown.f$i.text <<Paste>>" 
 .wmyown.f$i.pop_menu add command -label $T(pop_menu-Clear) -command "event generate .wmyown.f$i.text <<Clear>>" 
 bind .wmyown.f$i.text <Button-3> "tk_popup .wmyown.f$i.pop_menu \[winfo pointerx .wmyown.f$i\] \[winfo pointery .wmyown.f$i\]"


   pack  .wmyown.f$i.but .wmyown.f$i.text -side left
   pack .wmyown.f$i
  }
  button .wmyown.butQ -text $T(Quit) -command {
   destroy .wmyown
  }
  pack .wmyown.butQ
  wm minsize . 1 1
  bind .wmyown <<Help>> {Help $T(wmyown-Help)}
  bind .wmyown <Control-c> {
   destroy .wmyown
  }
  wm resizable .wmyown 0 0
  COLOR .wmyown
  for {set i 0} {$i < $myown_max} {incr i} {
   .wmyown.f$i.text configure -background White
  }
 } else {focus .wmyown}
}
#######################################################################
# Yeah, cut everything into small pieces to disturb curius people !
#######################################################################
# help online in the latex-text
source $libpath/help.tcl
HLP_load

#######################################################################
# auto complition
source $libpath/complition.tcl

#######################################################################
# help-system of tcltexed
source $libpath/helpmanual.tcl

#######################################################################
# undo function
source $libpath/undo.tcl

#######################################################################
# Farbige Syntax
source $libpath/syntax.tcl

#######################################################################
# Bilderverwaltung
proc Bild {name} {
 global gifpath I_txt
 set ksp [lsearch [image names] "IMAGE$I_txt($name)"]
 if {$ksp == -1} {
  image create photo "IMAGE$I_txt($name)" -file "$gifpath/$I_txt($name).gif" 
 }
 return "IMAGE$I_txt($name)" 
}
#######################################################################
# Goto Curser
proc Init_curser {E} {
  global T GotoArray

  if ![winfo exists $E.wcurser] then {
   toplevel $E.wcurser
   label $E.wcurser.l -text $T(wcurser-gotocurser)
   label $E.wcurser.pos -text "$T(EDITOR-ZS) [$E.te.edit1 index insert]" -width 12
   entry $E.wcurser.text -width 6 -relief sunken -textvariable GotoArray($E.te.edit1) -background White
   frame $E.wcurser.f
   button $E.wcurser.f.goto -text $T(wcurser-goto) -command "if \[catch {if {\[llength \[split \$GotoArray($E.te.edit1) .\]\] == 1} {append GotoArray($E.te.edit1) \".0\"}\n$E.te.edit1 mark set insert \$GotoArray($E.te.edit1)\n$E.te.edit1 see insert\nevent generate $E.te.edit1 <<Position_tail>> -when tail\n focus $E.te.edit1}\] {set GotoArray($E.te.edit1) \[$E.te.edit1 index insert\]}"

 
   button $E.wcurser.f.butQ -text $T(Quit) -command "destroy $E.wcurser"
   pack $E.wcurser.f.goto $E.wcurser.f.butQ -side left
   pack $E.wcurser.l $E.wcurser.pos $E.wcurser.text $E.wcurser.f
   wm title $E.wcurser $T(wcurser-titel)
   COLOR $E.wcurser
   $E.wcurser.text configure -background White
  }
  focus $E.wcurser
}
#######################################################################
# It's all folks !
#######################################################################
# Bei Programstart eine Message

if $readme_flag {
 Help readme_hlp
}

if {[ string compare [ info procs tkTextInsert ] tkTextInsert]} {
  # contributed by Aaron Mueller
  proc tkTextInsert {w s} {
   if {$s == ""} {return}
   catch {
    if {[$w compare sel.first <= insert] && [$w compare sel.last >= insert]} {
     $w tag remove sel sel.first promptEnd
     $w delete sel.first sel.last
    }
   }
   $w insert insert $s
   $w see insert
  }
}
