/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.base.BoolPar;
import nts.command.CommandBase;
import nts.command.InpTokChecker;
import nts.command.SpaceToken;
import nts.command.Token;
import nts.io.Loggable;

public abstract class BaseToksChecker
implements InpTokChecker {
    protected final String tokError;
    protected final String eofError;
    protected final Loggable source;

    public Token checkToken(Token tok, BoolPar canExpand) {
        if (CommandBase.meaningOf(tok, canExpand.get()).isOuter()) {
            this.handleOuterToken(tok);
            this.reportError(this.tokError);
            canExpand.set(true);
            return SpaceToken.TOKEN;
        }
        return tok;
    }

    public void checkEndOfFile() {
        this.reportError(this.eofError);
    }

    protected void reportError(String ident) {
        this.tryToFix();
        this.reportRunAway();
        Loggable[] params = new Loggable[]{this.source};
        CommandBase.nonDelError(ident, params);
    }

    protected void handleOuterToken(Token tok) {
        CommandBase.backTokenWithoutCleaning(tok);
    }

    protected abstract void tryToFix();

    protected abstract void reportRunAway();

    public BaseToksChecker(String tokErr, String eofErr, Loggable src) {
        this.tokError = tokErr;
        this.eofError = eofErr;
        this.source = src;
    }
}

