/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import nts.base.Dimen;
import nts.node.AnyBoxNode;
import nts.node.Box;
import nts.node.BoxSizes;
import nts.node.GlueSetting;
import nts.node.Node;
import nts.node.NodeList;
import nts.node.TypeSetter;
import nts.node.VertIterator;

public class VBoxNode
extends AnyBoxNode {
    public final boolean isVBox() {
        return true;
    }

    public String getDesc() {
        return "vbox";
    }

    protected void moveStart(TypeSetter setter) {
        setter.moveUp(this.getHeight());
    }

    protected void movePrev(TypeSetter setter, Node node) {
        setter.moveDown(node.getHeight(this.setting));
        node.syncVertIfBox(setter);
    }

    protected void movePast(TypeSetter setter, Node node) {
        setter.moveDown(node.getDepth(this.setting));
    }

    public Box pretendSizesCopy(BoxSizes sizes) {
        return new VBoxNode(sizes, this.setting, this.list);
    }

    public static VBoxNode packedOf(NodeList list, Dimen maxDepth) {
        return new VBoxNode(VertIterator.naturalSizes(list.nodes(), maxDepth), GlueSetting.NATURAL, list);
    }

    public static VBoxNode packedOf(NodeList list) {
        return VBoxNode.packedOf(list, null);
    }

    public static VBoxNode packedOf(Node node) {
        return VBoxNode.packedOf(new NodeList(node));
    }

    public String toString() {
        return "VBox(" + this.sizes + "; " + this.setting + "; " + this.list + ")";
    }

    public VBoxNode(BoxSizes sizes, GlueSetting setting, NodeList list) {
        super(sizes, setting, list);
    }
}

