/*
 * Decompiled with CFR 0.152.
 */
package nts.tex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import nts.command.FileName;
import nts.tex.FileOpener;

public class KpseFileOpener
implements FileOpener {
    private static final String FUTILE_PREFIX = "." + File.separator;
    private static final String S_KPSEWHICH = "kpsewhich";
    private static final String S_VERSION = "version";
    private static final String[] CONFIG_ARGS = new String[]{"kpsewhich", "--" + "version"};
    private String progNameArg;
    private boolean texfmOutputFlag = false;
    private String texfmOutputVal = null;
    private boolean kpseConfigured = false;
    private boolean kpseWorking = false;
    private boolean kpseAdvanced = false;
    private boolean useProgName = false;

    public InputStream openForReading(FileName name, String format, boolean mustExist) throws IOException {
        String path = name.getPath();
        String found = this.findFileName(path, format, mustExist);
        if (found != null && found.length() > 0) {
            if (File.separatorChar != '/') {
                found = found.replace('/', File.separatorChar);
            }
            if (found.startsWith(FUTILE_PREFIX) && !path.startsWith(FUTILE_PREFIX)) {
                found = found.substring(FUTILE_PREFIX.length());
            }
            name.setPath(found);
            path = found;
        } else {
            name.addDefaultExt(format);
            path = name.getPath();
        }
        return new FileInputStream(path);
    }

    public OutputStream openForWriting(FileName name, String format) throws IOException {
        name.addDefaultExt(format);
        String path = name.getPath();
        try {
            return new FileOutputStream(path);
        }
        catch (IOException e) {
            if (!new File(path).isAbsolute()) {
                if (!this.texfmOutputFlag) {
                    this.texfmOutputVal = this.variableValue("TEXMFOUTPUT");
                    if (this.texfmOutputVal != null && this.texfmOutputVal.length() == 0) {
                        this.texfmOutputVal = null;
                    }
                    this.texfmOutputFlag = true;
                }
                if (this.texfmOutputVal != null) {
                    path = this.texfmOutputVal + File.separator + path;
                    FileOutputStream out = new FileOutputStream(path);
                    name.setPath(path);
                    return out;
                }
            }
            throw e;
        }
    }

    private void kpseConfigure() {
        if (!this.kpseConfigured) {
            try {
                String versionOutput = this.captureOutput(CONFIG_ARGS);
                this.kpseWorking = true;
                int idx = versionOutput.indexOf(S_VERSION);
                if (idx >= 0) {
                    idx += S_VERSION.length();
                    while (Character.isWhitespace(versionOutput.charAt(idx))) {
                        ++idx;
                    }
                    ParsePosition pos = new ParsePosition(idx);
                    NumberFormat format = NumberFormat.getNumberInstance(Locale.ENGLISH);
                    format.setParseIntegerOnly(true);
                    int major = 0;
                    int minor = 0;
                    Number majorNum = format.parse(versionOutput, pos);
                    if (majorNum != null) {
                        major = majorNum.intValue();
                        idx = pos.getIndex();
                        if (versionOutput.charAt(idx) == '.') {
                            pos.setIndex(idx + 1);
                            Number minorNum = format.parse(versionOutput, pos);
                            if (minorNum != null) {
                                minor = minorNum.intValue();
                            }
                        }
                    }
                    this.kpseAdvanced = major > 3 || major == 3 && minor >= 2;
                    this.useProgName = this.kpseAdvanced && this.progNameArg != null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.kpseConfigured = true;
        }
    }

    protected String variableValue(String var) {
        this.kpseConfigure();
        if (this.kpseWorking) {
            int argc = 2;
            if (this.useProgName) {
                ++argc;
            }
            String[] args = new String[argc];
            int i = 0;
            args[i++] = S_KPSEWHICH;
            if (this.useProgName) {
                args[i++] = this.progNameArg;
            }
            args[i++] = "--expand-var=$" + var;
            try {
                return this.captureOutput(args);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected String findFileName(String name, String format, boolean mustExist) {
        this.kpseConfigure();
        if (this.kpseWorking) {
            int argc = 3;
            if (this.useProgName) {
                ++argc;
            }
            if (mustExist) {
                ++argc;
            }
            String[] args = new String[argc];
            int i = 0;
            args[i++] = S_KPSEWHICH;
            if (this.useProgName) {
                args[i++] = this.progNameArg;
            }
            args[i++] = this.kpseAdvanced ? "--format=" + format : "--format=." + format;
            if (mustExist) {
                args[i++] = "--must-exist";
            }
            args[i++] = name;
            try {
                return this.captureOutput(args);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String captureOutput(String[] args) throws IOException {
        Process proc = Runtime.getRuntime().exec(args);
        try {
            int c;
            Reader in = KpseFileOpener.makeReader(proc.getInputStream());
            StringBuffer buf = new StringBuffer();
            while ((c = in.read()) >= 0) {
                void var5_6;
                buf.append((char)var5_6);
            }
            int len = buf.length();
            if (len > 0) {
                if (buf.charAt(len - 1) == '\r' || buf.charAt(len - 1) == '\n' && --len > 0 && buf.charAt(len - 1) == '\r') {
                    --len;
                }
                buf.setLength(len);
            }
            try {
                proc.waitFor();
                if (proc.exitValue() == 0) {
                    return buf.toString();
                }
            }
            catch (InterruptedException e) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static Reader makeReader(InputStream in) {
        try {
            return new InputStreamReader(in, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Can't happen");
        }
    }

    public KpseFileOpener(String progName) {
        if (progName != null) {
            this.progNameArg = "--progname=" + progName;
        }
    }

    public KpseFileOpener() {
    }
}

