/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.rendering;

import com.github.ajalt.mordant.internal.CellwidthKt;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.TextStyle;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 !2\u00020\u0001:\u0001!B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0014J\u0015\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\r\u0010\u001a\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001bJ\u0015\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001fJ\b\u0010 \u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/github/ajalt/mordant/rendering/Span;", "", "text", "", "style", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "<init>", "(Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/TextStyle;)V", "getText", "()Ljava/lang/String;", "getStyle", "()Lcom/github/ajalt/mordant/rendering/TextStyle;", "cellWidth", "", "getCellWidth$mordant", "()I", "cellWidth$delegate", "Lkotlin/Lazy;", "take", "n", "take$mordant", "drop", "drop$mordant", "isWhitespace", "", "isWhitespace$mordant", "isTab", "isTab$mordant", "withStyle", "withStyle$mordant", "replaceStyle", "replaceStyle$mordant", "toString", "Companion", "mordant"})
public final class Span {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final TextStyle style;
    @NotNull
    private final Lazy cellWidth$delegate;

    private Span(String text2, TextStyle style) {
        this.text = text2;
        this.style = style;
        this.cellWidth$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> Span.cellWidth_delegate$lambda$0(this));
    }

    /* synthetic */ Span(String string, TextStyle textStyle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            textStyle = ConstantsKt.getDEFAULT_STYLE();
        }
        this(string, textStyle);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final TextStyle getStyle() {
        return this.style;
    }

    public final int getCellWidth$mordant() {
        Lazy lazy = this.cellWidth$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final Span take$mordant(int n) {
        return new Span(StringsKt.take(this.text, n), this.style);
    }

    @NotNull
    public final Span drop$mordant(int n) {
        return new Span(StringsKt.drop(this.text, n), this.style);
    }

    public final boolean isWhitespace$mordant() {
        return CharsKt.isWhitespace(this.text.charAt(0));
    }

    public final boolean isTab$mordant() {
        return this.text.charAt(0) == '\t';
    }

    @NotNull
    public final Span withStyle$mordant(@NotNull TextStyle style) {
        Intrinsics.checkNotNullParameter(style, "style");
        return new Span(this.text, this.style.plus(style));
    }

    @NotNull
    public final Span replaceStyle$mordant(@NotNull TextStyle style) {
        Intrinsics.checkNotNullParameter(style, "style");
        return new Span(this.text, style);
    }

    @NotNull
    public String toString() {
        return "<Span '" + this.text + "', " + this.style + '>';
    }

    private static final int cellWidth_delegate$lambda$0(Span this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return CellwidthKt.stringCellWidth(this$0.text);
    }

    public /* synthetic */ Span(String text2, TextStyle style, DefaultConstructorMarker $constructor_marker) {
        this(text2, style);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lcom/github/ajalt/mordant/rendering/Span$Companion;", "", "<init>", "()V", "word", "Lcom/github/ajalt/mordant/rendering/Span;", "text", "", "style", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "space", "width", "", "mordant"})
    @SourceDebugExtension(value={"SMAP\nSpan.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Span.kt\ncom/github/ajalt/mordant/rendering/Span$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,52:1\n1#2:53\n1104#3,3:54\n*S KotlinDebug\n*F\n+ 1 Span.kt\ncom/github/ajalt/mordant/rendering/Span$Companion\n*L\n23#1:54,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Span word(@NotNull String text2, @NotNull TextStyle style) {
            Intrinsics.checkNotNullParameter(text2, "text");
            Intrinsics.checkNotNullParameter(style, "style");
            if (!(((CharSequence)text2).length() > 0)) {
                boolean $i$a$-require-Span$Companion$word$22 = false;
                String $i$a$-require-Span$Companion$word$22 = "Span text cannot be empty";
                throw new IllegalArgumentException($i$a$-require-Span$Companion$word$22.toString());
            }
            CharSequence $this$count$iv = text2;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!CharsKt.isWhitespace(it)) continue;
                ++count$iv;
            }
            int it = count$iv;
            boolean bl = false;
            if (!(it == 0 || it == text2.length())) {
                boolean $i$a$-require-Span$Companion$word$72 = false;
                String $i$a$-require-Span$Companion$word$72 = "Spans must contain either all whitespace, or no whitespace: \"" + text2 + '\"';
                throw new IllegalArgumentException($i$a$-require-Span$Companion$word$72.toString());
            }
            if (!(!StringsKt.contains$default((CharSequence)text2, "\n", false, 2, null))) {
                boolean $i$a$-require-Span$Companion$word$82 = false;
                String $i$a$-require-Span$Companion$word$82 = "Spans cannot contain newlines";
                throw new IllegalArgumentException($i$a$-require-Span$Companion$word$82.toString());
            }
            if (!(!StringsKt.contains$default((CharSequence)text2, "\u001b[", false, 2, null))) {
                boolean bl2 = false;
                String string = "Spans cannot contain ANSI codes";
                throw new IllegalArgumentException(string.toString());
            }
            return new Span(text2, style, null);
        }

        public static /* synthetic */ Span word$default(Companion companion, String string, TextStyle textStyle, int n, Object object) {
            if ((n & 2) != 0) {
                textStyle = ConstantsKt.getDEFAULT_STYLE();
            }
            return companion.word(string, textStyle);
        }

        @NotNull
        public final Span space(int width, @NotNull TextStyle style) {
            Intrinsics.checkNotNullParameter(style, "style");
            return new Span(StringsKt.repeat(" ", width), style, null);
        }

        public static /* synthetic */ Span space$default(Companion companion, int n, TextStyle textStyle, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            if ((n2 & 2) != 0) {
                textStyle = ConstantsKt.getDEFAULT_STYLE();
            }
            return companion.space(n, textStyle);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

