/*
   file: yacco2_compile_symbols.h   
   The symbols below may also be imported into your compiler
   using switches 
   THREAD_LIBRARY_TO_USE__ values 
      1 - Microsoft NT windows thread library
      0 - Pthread POSIX thread library
   TRACE__ define if u want to trace
 *
 * make visible if porting to HP's VMS 
 *
   VMS__ if defined corrects the pthread library weaknesses
   VMS_PTHREAD_STACK_SIZE__ 1024*128 
*/
#ifndef __yacco2_compile_symbols_h__
#define __yacco2_compile_symbols_h__ 0
//#define VMS__ 1
//#define VMS_PTHREAD_STACK_SIZE__ 1024*4*256// multiple of k per thread : proc calls need larger stack or crash
#define THREAD_LIBRARY_TO_USE__ 0 // MUST BE DEFINED:
/*
Debug switches: they are now global variables --- not compile time macro symbols!
U can define them yourself or use the YACCO2_define_trace_variables macro
Eg. put below macro in prefix of your program to define variables:
YACCO2_define_trace_variables()
The trace variables are housed within yacco2 namespace.
Don't trace has a 0 value while trace is set to 1 as illustrated below.
Examples of setting variables 
yacco2::YACCO2_AR__ = 1;         // trace arbitrator(s) when debug = "true" in grammar
using namespace yacco2;
YACCO2_TLEX__ = 1;       // trace grammar macros of emitted rules etc
YACCO2_THP__ = 1;        // track how the thread library works in dispatching
YACCO2_MSG__ = 1;        // trace messages between threads
YACCO2_T__ = 1;          // trace Terminals
YACCO2_TH__ = 1;         // trace thread code when debug = "true" in grammar
YACCO2_MU_TRACING__ = 1; // trace mutex acquire / release tracing mutex
YACCO2_MU_TH_TBL__ = 1;  // trace mutex acquire / release thread table
YACCO2_MU_GRAMMAR__ = 1; // trace mutex acquire / release in grammar
*/
#endif
