/*********************************************************************/
/*        LINEAR TREE for Supervised Learning                        */
/*        Versao 1.0 (10/12/1997)                                    */
/*        Developed by: Joao Gama                                    */
/*                LIACC - Uni.do Porto                               */
/*                jgama@ncc.up.pt                                    */
/*-------------------------------------------------------------------*/
/*   FILE:Ci_instances.h                                             */  
/*********************************************************************/
/*  Data Types for Constructive Induction                            */
/*********************************************************************/
#ifndef _CiFRAMEWORK_
#define _CiFRAMEWORK_

#define TRUE            1
#define FALSE           0
#define ContType        float
#define TypeOfVal(a_v)      a_v.type_of_val
#define CVal(a_v)           a_v.val.c
#define DVal(a_v)           a_v.val.d

enum ValTypes { normal,unknown,dontcare };
enum AttrTypes { nominal,ordered,integer,continuous };

union NormalVal {
  int               d;
  ContType          c;
};

typedef struct attr_val {
  enum  ValTypes    type_of_val;
  union NormalVal   val;
} AttrVal;
typedef AttrVal * Instance;

typedef struct attr_info {
  char              *name;
  enum AttrTypes    type_attr;
  unsigned int      nr_vals;
  void              *vals;
} AttrInfo;

typedef struct domain_info {
  char              *root_name;
  unsigned int      nr_attrs;
  AttrInfo          *attrs;
} DomainInfo;                                

typedef struct _ciex {
  int classe;
  int nr_att;
  double weight;
  AttrVal *instance;
}CiExample;

typedef struct _cids {
  DomainInfo *domain;
  unsigned long nr_exs;
  CiExample **examples;
}CiDs;

#define Id(instance)        instance[0].val.c
#define ValsAttr(D,i)       ((char **)D->attrs[i].vals)
#define NrAttrs(D)          D->nr_attrs
#define CI_Domain(ds)       (ds->domain)
#define Ci_NrExs(ds)        (ds->nr_exs)
#define Ci_Examples(ds)     (ds->examples)
#define Ci_Example(ds, i)   (ds->examples[i])
#define Ci_AttVal(ds, i)    ((ds->examples[i])->instance)
#define Ci_Classe(ex)       ((ex)->classe)
#define Ci_NrAtts(ex)       ((ex)->nr_att)
#define Ci_Weight(ex)       ((ex)->weight)
#define Ci_Instance(ex)     (ex->instance)
#define Ci_NrClasses(D)     (NValsAttr(D, NrAttrs(D) + 1))
#define CiTypeAttr(D, Att)  (Att > NrAttrs(D) ? continuous : TypeAttr(D, Att))
#define NameAttr(D,i)        D->attrs[i].name
#define NValsAttr(D,i)       D->attrs[i].nr_vals
#define CValAttEx(instance, att) instance[att].val.c
#define DValAttEx(instance, att) instance[att].val.d
#define NormalVal(a_v)      (a_v.type_of_val == normal)
#define TypeAttr(D,i)        D->attrs[i].type_attr
#define ContAttr(D,attr)     (TypeAttr(D,attr) == continuous)
#define NomAttr(D,attr)      (TypeAttr(D,attr) == nominal)
#define IntAttr(D,attr)      (TypeAttr(D,attr) == integer)
#define OrdAttr(D,attr)      (TypeAttr(D,attr) == ordered)
#define DOMAIN_INFO(ds)      (ds->domain)
#define ForAllAttributes(D, attr)     for(attr = 1; attr <= D->nr_attrs; attr++)
/************************************************/
/*              Public Methods                  */
/************************************************/
CiDs *ReadCiDataset(FILE *fi, DomainInfo *domain);
void Show_CiInstances(CiDs *ds, long int Low, long int High);
void ShowCiInstance(DomainInfo *domain, AttrVal *instance, int nr_att);
void ShowDomain(DomainInfo *D);

int CiQuickSort(CiDs *ds, int Att, unsigned long Low, unsigned long High);
long int CiJoinValues(CiDs *ds, int Att, int value, unsigned long Low, unsigned long High);
long int CiSplitingPosition(CiDs *ds, int Att, unsigned long Low, unsigned long High, double value);
long int CiJoinUnknowns(CiDs *ds, int Att, unsigned long Low, unsigned long High);
long int CiMoveUnknowns(CiDs *ds, int Att, unsigned long Low, unsigned long High,unsigned long Pos);
int Ci_ReBuildInstance(CiExample *exemplo, int nr_att);
DomainInfo *_ReadDomain(char *Name, char *Ext);
unsigned int IdAttr(DomainInfo *D, char *name);
char *LblValId(DomainInfo *D, unsigned int IdAttr, unsigned int IdVal);
unsigned int IdValLbl(DomainInfo *D, unsigned int IdAttr, char *Value);
#endif
