/*********************************************************************/
/*        LINEAR TREE for Supervised Learning                        */
/*        Versao 1.0 (10/12/1997)                                    */
/*        Developed by: Joao Gama                                    */
/*                LIACC - Uni.do Porto                               */
/*                jgama@ncc.up.pt                                    */
/*-------------------------------------------------------------------*/
/*   FILE:Combine.c                                                  */  
/*********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "Ci_instances.h"
#include "utils.h"
#include "externs.i"

#define M 0.1

double *combing_evidences\
(DomainInfo *domain, double *actual_class_freq, double *antec_class_freq)
{
  register int i;
  double sum = 0.0, phe, peE, peEH;
  double *acum_class_distr = dvector(1, Ci_NrClasses(domain));

  /* No examples at this Node */
  if (!actual_class_freq[0]) {
    for(i = 1; i <= Ci_NrClasses(domain); i++)
      acum_class_distr[i] = antec_class_freq[i] / antec_class_freq[0];
    return acum_class_distr;
  }

  if (WEIGHT) {
    if (antec_class_freq) {
      sum = 0.0;
      peE =  (M+actual_class_freq[0]) / (antec_class_freq[0] + Ci_NrClasses(domain));
      for(i = 1; i <= Ci_NrClasses(domain); i++) {
        phe = (M+antec_class_freq[i]) / (antec_class_freq[0] + Ci_NrClasses(domain)); 
        peEH = WEIGHT * (M+actual_class_freq[i]) / (actual_class_freq[0] + Ci_NrClasses(domain)) ;
        acum_class_distr[i] = phe * peEH / peE;
        sum += acum_class_distr[i];
      }
      for(i = 1; i <= Ci_NrClasses(domain); i++)
        acum_class_distr[i] /= sum;
    }
    else 
      for(i = 1; i <= Ci_NrClasses(domain); i++)
	acum_class_distr[i] = actual_class_freq[i] / actual_class_freq[0];
  }
  else
    for(i = 1; i <= Ci_NrClasses(domain); i++)
      acum_class_distr[i] = actual_class_freq[i] / actual_class_freq[0];

  return acum_class_distr;
}

int dmajority(double *class_freq, int nr_class)
{
  register int i, j = 1;

  for(i = 1; i <= nr_class; i++) 
    if (class_freq[i] > class_freq[j]) j = i;
  
  return j;
}









