/*********************************************************************/
/*        LINEAR TREE for Supervised Learning                        */
/*        Versao 1.0 (10/12/1997)                                    */
/*        Developed by: Joao Gama                                    */
/*                LIACC - Uni.do Porto                               */
/*                jgama@ncc.up.pt                                    */
/*-------------------------------------------------------------------*/
/*  File: Ltree.c                                                    */
/*-------------------------------------------------------------------*/
/* Please report any bug (I,m sorry about that) to the author        */
/*********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "Ci_instances.h"
#include "BuildTree.h"
#include "tree.h"
#include "classify.h"
#include "utils.h"

#define FALSE 0
#define TRUE 1
#define KH_DEFAULT 2.5

short VERBOSITY = 0;
int   GAIN_RATIO = TRUE;
int   MINIMUM_EXAMPLES = 2;
int   UNSEENS = FALSE;
int    MAX_DEPTH   = 10;
double MIN_SPLIT = 0.98;
double CF = 0.25;
double WEIGHT = 5.0;
double KH = KH_DEFAULT;

#define VERBOSE(v) if(VERBOSITY >= v)

int main(int argn, char *argl[])
{
  char opt, *FileName = NULL, *optarg = NULL;
  int test_erros = 0, depth = 0, **mconf = NULL;
  DomainInfo *domain;
  FILE  *ftest;
  CiDs  *ds;
  Tree *tree;
  TreeInfo *treeinfo;

  while ((opt = mygetopt(argn, argl, "f:v:t:", &optarg)) != EOF ) {
    switch (opt)      {
    case 'f':
      FileName = optarg;
      break;
    case 'v':
      VERBOSITY = atoi(optarg);
      break;
    default:
      fprintf(stderr, "Invalid Option\n");
    }
  }
  if (!FileName)
    fprintf(stderr, "\nUse:%s -f dataset [-u][-v Verbose](Version 1.0)\n", argl[0]);
  else {
    if ((domain = _ReadDomain(FileName, ".domain")) != NULL) {
      --NrAttrs(domain);
      VERBOSE(5) ShowDomain(domain);
      if ((ftest = fopen(new_strcat(FileName, ".test"), "r")) != NULL) {
	ds = ReadCiDataset(ftest, domain);
	VERBOSE(4)
	  printf("Reading %ld Examples from File %s.test\n",Ci_NrExs(ds), FileName);
	VERBOSE(5) Show_CiInstances(ds, 1, Ci_NrExs(ds)); 

	if ((tree = Read_Tree(FileName, ReadData, Ci_NrClasses(ds->domain))) != NULL) {
	  treeinfo = Recompute_Nodes(tree, &depth);
	  DEPTH(treeinfo) = depth;
	  printf("Decision Tree:\n(Nodes: %d, Leaves: %d, Depth: %d, Errors: %.3f, Colapses %d)\n",
		 NODES(treeinfo),LEAVES(treeinfo), DEPTH(treeinfo), ERRORS(treeinfo), COLAPSES(treeinfo));
	  Show_Tree(tree, domain, (void *) ShowTree);
	  Show_Coeficients(domain, tree);
	  mconf = classify(ds, tree, NULL, &test_erros);
	  VERBOSE(2) {
	    printf("Confusion Matrix:\n");
	    ShowIMatrix(mconf, 1, Ci_NrClasses(ds->domain), 1, Ci_NrClasses(ds->domain)); 
	  }
	  printf("Error rate on test set %f (%ld / %ld) (Nodes: %d, Leaves: %d, Depth: %d)\n",
		 test_erros/(double)Ci_NrExs(ds), test_erros, Ci_NrExs(ds),
		 NODES(treeinfo),LEAVES(treeinfo), DEPTH(treeinfo));
	}
      }
      else
	fprintf(stderr, "File %s.test Not Found!\n", FileName);
    }
    else
      fprintf(stderr, "File %s.domain Not Found!\n", FileName);
  }
  exit(0);
}
