/*********************************************************************/
/*        LINEAR TREE for Supervised Learning                        */
/*        Versao 1.0 (10/12/1997)                                    */
/*        Developed by: Joao Gama                                    */
/*                LIACC - Uni.do Porto                               */
/*                jgama@ncc.up.pt                                    */
/*-------------------------------------------------------------------*/
/*   FILE: tree.h                                                    */  
/*********************************************************************/
#ifndef _TREEHEADER
#define _TREEHEADER

typedef enum {leaf, split_discrete, split_continuous, split_linear} TYPE_NODE;

struct _tree {
  TYPE_NODE tipo;
  int node;
  void *data;  
  int nr_descendents;
  struct _tree *ascendent;
  struct _tree **descendents;
};
typedef struct _tree Tree;

typedef struct {
  int nodes;
  int leaves;
  int depth;
  int colapses;
  double errors;
}TreeInfo;

#define DATA(T)           (T->data)
#define NR_DESCENDENTS(T) (T->nr_descendents)
#define DESCENDENTS(T)    (T->descendents)
#define DESCENDENT(T,N)   (T->descendents[N])

#define NODES(TI)         (TI->nodes)
#define LEAVES(TI)        (TI->leaves)
#define DEPTH(TI)         (TI->depth)
#define COLAPSES(TI)      (TI->colapses)
#define ERRORS(TI)        (TI->errors)

#define Show_Tree(a,b,c)  show_tree(a,b,c,0)

Tree *Make_Tree(void *data, int node, int nr_desc, Tree *ascen, TYPE_NODE tipo);
TreeInfo *MakeTreeInfo();
void Set_Descendent(Tree *tree, int nr, Tree *descendent);
TreeInfo *Recompute_Nodes(Tree *tree, int *depth);

Tree *Read_Tree(char *FileName, void *(func)(int, int), int nr_cl);
int Write_Tree(char *FileName, Tree *tree, int (func)(int, void *, int), int nr_cl);
void show_tree(Tree *tree, void *p1, void (* func)(void *, void *,int,TYPE_NODE), int off);
double code_tree(Tree *tree, int nrcl, double nrexs, double nrerr, void *p1, double (* func)(void *, void *, TYPE_NODE));
#endif







