/*********************************************************************/
/*        LINEAR TREE for Supervised Learning                        */
/*        Versao 1.0 (10/12/1997)                                    */
/*        Developed by: Joao Gama                                    */
/*                LIACC - Uni.do Porto                               */
/*                jgama@ncc.up.pt                                    */
/*-------------------------------------------------------------------*/
/*  File: utils.h                                                    */
/*********************************************************************/
#ifndef _UTILS_HEADER
#define _UTILS_HEADER
#define TRUE  1
#define FALSE 0

#define SReadFile(fi, nrl, nrw, f_sep) _ReadFile(fi, nrl, nrw, 1, f_sep)
#define v_split(str,sep,nwrds) _v_split(str, sep, nwrds, 1)

int mygetopt(int Argc, char **Argv,char *Str, char **optarg);
/* ========================================= 
   Generic Data Structures
 ========================================= */
struct list {
  void          *data;
  struct list   *next;
};
typedef struct list List;

typedef struct {
  List *list;
} Stack;

#define tail(list)              (list->next)
#define top_of_stack(stack)     (stack->list->data)

void *pop(Stack *s);
Stack *push(void *e, Stack *s);

/* ========================================= 
   String Utilities
 ========================================= */
unsigned int all_integers(char **s, unsigned int n);
int compare_chars(char **s1, char **s2);
int is_a_int(char *str);
char *new_strcat(char *str1, char *str2);
char *new_strcpy(char *str);
char **_v_split(char *str, char *splits, int *nwrds, int nr);
/* ========================================= 
   Files Utilities
 ========================================= */
char ***_ReadFile(FILE *fi, long *nrt, int **nr_valores, long nr, char *fld_sep);
char **_ReadLine(FILE *fi, int *nrt, int nr, char *fld_sep);
char *ReadField(FILE *fi, char *sep);
/* =========================================
   Vector and Matrices Utilities
 ========================================= */
int *ivector(long nrl, long nrh);
double *dvector(long nrl, long nrh);
int **imatrix(long nrl,long nrh, long ncl, long nch);
double **dmatrix(long nrl,long nrh, long ncl, long nch);

void free_imatrix(int **m, long nrl, long nrh, long ncl, long nch);
void free_ivector(int *v, long nl, long nh);
void free_dmatrix(double **m, long nrl, long nrh, long ncl, long nch);
void free_dvector(double *v, long nl, long nh);

void ShowIMatrix(int **m, int n0, int n, int l0, int l);
void ShowMatrix(double **m, int n0, int n, int l0, int l);

#endif
