/* m3dargs.c  --  morph3d argument parser program */

/* contains:  GetArgs(), OptErr()[static]  */

/* dependencies: none */

/* morph3d version 4.0   1 June 1993               */
/* 3D image morphology program                     */
/*                                                 */
/* by Richard Alan Peters II                       */
/* Department of Electrical Engineering            */
/* Vanderbilt University School of Engineering     */
/* Nashville, TN 37235                             */
/* rap2@vuse.vanderbilt.edu                        */
/*                                                 */
/* This software is freely redistributable if      */
/* the author's name and affiliation are included. */
			
#include "morph3d.h"

static void OptErr();

int GetArgs( argc,argv,MorphOp,sname,autoSE,x,y,z,v,SorF,SEType,ImgType,
             rank,lthresh,uthresh,nopad,slope,incept,dsp,basename,mnemo) 
   unsigned int argc;   /* count of arguments parsed by operating system    */
   char *argv[];        /* pointers to arguments parsed by operating system */
   int *MorphOp;        /* morphological operation to perform */
   char **sname;        /* structuring element (SE) path name */
   int *autoSE;         /* use canned or auto generated SE */
   int *x,*y,*z,*v;     /* SE x,y,z dimensions, gray-level */
   int *SorF;			/* Set operation or Function operation */
   int *SEType;			/* binary or gray-level SE */
   int *ImgType;		/* gray-level or binary */
   int *rank;           /* rank for rank filter */
   int *lthresh;        /* lower binary threshold value */
   int *uthresh;        /* upper binary threshold value */
   int *nopad;          /* flag.  F => zeropadding of input */
   float *slope;        /* scale factor for output image */
   float *incept;       /* gray-level offset for output image */
   int *dsp;            /* display flag */
   char **basename;     /* image basename */
   char **mnemo;        /* image filename mnemonic */
   {
   int n = argc;
   int i;

   /* zero everything (almost) initially */
   *autoSE=0;
   *x=0;
   *y=0;
   *z=0;
   *v=0;
   *MorphOp=0;
   *SorF=0;
   *SEType=0;
   *ImgType=0;
   *rank=0;
   *lthresh=0;
   *uthresh=0;
   *nopad=0;
   *slope=1.0;
   *incept=0.0;
   *dsp=0;
   *basename = NULL;
   *mnemo = NULL;


   /* get arguments */
   while ( --n )
      {
      if ( argv[n][0] == '-' )          /* then this is a switch */
         {
         if ( argv[n][1] == 'k' )       /* SE file name follows */
            {
            if ( !strcasecmp( argv[n+1], "3x3x3" ) )
               {
               *autoSE = S3X3X3;
               *sname = NULL;
               }
            else if ( !strcasecmp( argv[n+1], "plus" ) )
               {
               *autoSE = PLUS;
               *sname = NULL;
               }
            else if ( !strcasecmp( argv[n+1], "5x5x5" ) )
               {
               *autoSE = S5X5X5;
               *sname = NULL;
               }
            else if ( !strcasecmp( argv[n+1], "sphere" ) )
               {
               *autoSE = SPHERE;
               *x = atoi( argv[n+2] );
               *y = atoi( argv[n+3] );
               *z = atoi( argv[n+4] );
               if ( ((n+5) < argc) && isdigit( argv[n+5][0] ) )
                  *v = atoi( argv[n+5] );
               else
                  *v = BLACK;
               /* note if (*autoSE != 0), setupop sets SEType = GRASE */
               *sname = NULL;
               }
            else if ( !strcasecmp( argv[n+1], "cylinder" ) )
               {
               *autoSE = CYLINDER;
               *x = atoi( argv[n+2] );
               *y = atoi( argv[n+3] );
               *z = atoi( argv[n+4] );
               if ( ((n+5) < argc) && isdigit( argv[n+5][0] ) )
                  *v = atoi( argv[n+5] );
               else
                  *v = BLACK;
               *sname = NULL;
               }
            else if ( !strcasecmp( argv[n+1], "cone" ) )
               {
               *autoSE = CONE;
               *x = atoi( argv[n+2] );
               *y = atoi( argv[n+3] );
               *z = atoi( argv[n+4] );
               if ( ((n+5) < argc) && isdigit( argv[n+5][0] ) )
                  *v = atoi( argv[n+5] );
               else
                  *v = BLACK;
               *sname = NULL;
               }
            else
               *sname = argv[n+1];
            }
         else if ( argv[n][1] == 'm' )  /* morph op flag follows */
            {
            switch (argv[n+1][0])
               {
               case 'e' : { *MorphOp = ERODE;  break; }
               case 'd' : { *MorphOp = DILATE; break; }
               case 'o' : { *MorphOp = OPEN;   break; }
               case 'c' : { *MorphOp = CLOSE;  break; }
               case 'r' : { *MorphOp = RANK;   break; }
               case 'a' : { *MorphOp = MINMAX; break; }
               case 'b' : { *MorphOp = MAXMIN; break; }
               case 'l' : { *MorphOp = LUM;    break; }
               case 'm' : { *MorphOp = LUMSMO; break; }
               case 'n' : { *MorphOp = LUMSHA; break; }
               case 'p' : { *MorphOp = ERODE  | NOTFLG; break; }
               case 'q' : { *MorphOp = DILATE | NOTFLG; break; }
               default  : { OptErr( argv[n], argv[n+1] ); }
               }
            }
         else if ( argv[n][1] == 'r' )  /* rank value follows */
            {
            *rank = strcmp( argv[n+1], "med" );
            if ( *rank ) *rank = atoi( argv[n+1] );
            } 
         else if ( argv[n][1] == 't' )  /* threshold value(s) follows */
            {
            *lthresh = atoi( argv[n+1] );
            if ( n+2 < argc  &&  isdigit( argv[n+2][0] ) )
                *uthresh = atoi( argv[n+2] );
            else
                *uthresh = WHITE;
            if (*lthresh > *uthresh) 
                OptErr( argv[n], "lthresh > uthresh" );
            } 
         else if ( argv[n][1] == 'o' )  /* op type follows */
            {
            switch (argv[n+1][0])
               {
               case 's' : { *SorF = SET;   break; }
               case 'f' : { *SorF = FUNCT; break; }
               default  : { OptErr( argv[n], argv[n+1] ); }
               }
            }
         else if ( argv[n][1] == 's' )  /* SE type follows */
            {
            switch (argv[n+1][0])
               {
               case 'b' : { *SEType = BINSE; break; }
               case 'g' : { *SEType = GRASE; break; }
               default  : { OptErr( argv[n], argv[n+1] ); }
               }
            }
         else if ( argv[n][1] == 'i' )  /* image type follows */
            {
            switch (argv[n+1][0])
               {
               case 'g' : { *ImgType = GRAIMG; break; }
               case 'b' : { *ImgType = BINIMG; break; }
               default  : { OptErr( argv[n], argv[n+1] ); }
               }
            }
         else if ( argv[n][1] == 'z' ) /* do not zeropad input */
            *nopad = TRUE;

         else if ( argv[n][1] == 'f' )  /* scale factor follows */
            {
            *slope = atof( argv[n+1] );
            *incept = atof( argv[n+2] );
            }
         else if ( argv[n][1] == 'l' )  /* LUM value(s) follows */
            {
            if ( (n+1 < argc) )
               {
               if ( isdigit( argv[n+1][0] ) )
                  {
                  *lthresh = atoi( argv[n+1] );
                  if ( n+2 < argc  &&  isdigit( argv[n+2][0] ) )
                      *uthresh = atoi( argv[n+2] );
                  else
                      OptErr( argv[n], "LUM (-l) parameter(s)." );
                  }
               else
                  OptErr( argv[n], "LUM (-l) parameter(s)." );
               }
            else 
               OptErr( argv[n], "LUM (-l) parameter(s)." );
            }
         else if ( argv[n][1] == 'b' ) /* follows: basename for outfile  */
            *basename = argv[n+1];
         else if ( argv[n][1] == 'n' ) /* follows: nemonic code for outfile  */
            *mnemo = argv[n+1];
         }
      }
   
   return;
   }


static void OptErr( s, t )
   char *s,*t;
   {
   fprintf(stderr,"Invalid Op: %s %s\n",s,t);
   exit( 0 );
   }

