C$Header: /csm/nice/max/RCS/max.f.cray,v 1.1 89/11/29 11:22:22 maring Exp $
C$F77               MAX
      program       MAX
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  T Y P E   &   D I M E N S I O N                    |
C+---------------------------------------------------------------------+
      character*12  deknam
      integer       mark,     n
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       MXDICK,   MXHEAD
C
      external      MXDICK,   MXHEAD
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
C|              Load command text                                      |
C+---------------------------------------------------------------------+
      call       MXLOAD
C+---------------------------------------------------------------------+
C|              Parse command data                                     |
C+---------------------------------------------------------------------+
      call       MXDATA
C+---------------------------------------------------------------------+
C|              Prompt for missing data                                |
C+---------------------------------------------------------------------+
      call       MXPROD
C+---------------------------------------------------------------------+
C|              Open I/O devices                                       |
C+---------------------------------------------------------------------+
      call       MXOPEN
C+---------------------------------------------------------------------+
C|              Get ready to launch                                    |
C+---------------------------------------------------------------------+
      call       MXSET
C+---------------------------------------------------------------------+
C|              Distribute decks                                       |
C+---------------------------------------------------------------------+
 2000 mark  =    MXDICK  ( )
        if (mark .ne. -1)           then
          if (msctyp .eq. DECK)       then
            if (MXHEAD ( ) .ne. 0)    go to 6000
            if (wrtdek .eq. YES)      kdeckw = kdeckw + 1
          endif
          go to 2000
        endif
C+---------------------------------------------------------------------+
C|              Terminate I/O; print stats (as requested)              |
C+---------------------------------------------------------------------+
 6000 call       MXTAIL
      if (lisinf .eq. YES)            then
        print 6001, klinew, kdeckw
 6001 format (' MAX put out ',I6,' lines in',I4,' decks')
        if (splitw .eq. YES) print 6002, kdeckw
 6002 format (' Input split into ',I4,' files')
      endif
      if (ndklis .gt. 0)             then
        do 6200  n = 1,ndklis
          deknam =   dklist(n)
          if (deknam(1:1) .ne. ' ')    then
            if (INDEX(deknam,'*') .eq. 0 .and.
     $          INDEX(deknam,'%') .eq. 0)  then
                print 6003, ' *MAX* Warning: deck ',
     $                           deknam,' not found'
 6003 format (A,A,A)
              endif
            endif
 6200     continue
      endif
      if (klinew .le. 0)              then
        print 6003, ' *MAX* Warning: Nothing written'
      endif
      if (devr .ne. 0)                CLOSE (unit=devr)
      if (devw .ne. 0)                CLOSE (unit=devw)
      stop
      end
C$F77               MXADIK
      subroutine    MXADIK
     $                      (keyarg)
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     keyarg*(*)
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     key*24
      integer       i
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      key =     keyarg
      do 2000  i = 1,ndikey
        if (key .eq. diskey(i))        return
 2000   continue
      ndikey =   ndikey + 1
      diskey(ndikey) = key
      return
      end
C$F77               MXBEND
      integer function  MXBEND
     $                          (cbline, nxtch)
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     cbline*(*)
      integer       nxtch
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     key*25
      integer       k,        level,    n,        nxt,      m
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       GETWRD
C
      external      GETWRD
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      MXBEND =   0
      nxt =      nxtch
      m =        0
C
 1000   if (GETWRD (1, cbline, nxt, key(2:)) .ne. 0)       then
          key(1:1) =   '-'
          m =          m + 1
          if (nackey .gt. 0)           then
            do 2000  k = nackey,1,-1
              if (key(2:25) .eq. actkey(k) .or.
     $           (akelse(k) .eq. YES .and.
     $            key(1:24) .eq. actkey(k)))  then
                call     MXDROP  (k)
                go to 1000
              endif
 2000         continue
          endif
          go to 6000
        else
          if (m .ne. 0)                then
            return
          else
            if (nackey .le. 0)         go to 6000
            n =       nackey
            level =   aklevl(nackey)
            do 3000  k = n,1,-1
              if (aklevl(k) .eq. level)   call MXDROP (k)
 3000         continue
            return
          endif
        endif
C
 6000 print 6001, ' *MAX* Unbalanced specification'
 6001 format (A)
      MXBEND =   1
      return
      end
C$F77               MXBLOK
      integer function  MXBLOK
     $                          (cbline, nxtch)
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     cbline*(*)
      integer       nxtch
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     key*24
      integer       k,        level,    n,        nxt
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       GETWRD,   MXFIND
C
      external      GETWRD,   MXFIND
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      MXBLOK =   0
      nxt =      nxtch
      level =    1
      if (nackey .gt. 0)           level = aklevl(nackey) + 1
C
 2000   if (GETWRD (1, cbline, nxt, key) .ne. 0)           then
C
          n =       MXFIND (key)
          if (nackey .gt. 0)           then
            do 3000  k = 1,nackey
              if (key .eq. actkey(k))  then
                print 2001,   key, dkline, dkname
 2001 format (' *MAX* Redundant C=BLOCK key: ',A,
     $                  ' ignored'/7X,'Line',I6,' of deck ',
     $                  A12)
                MXBLOK = -1
                go to 2000
              endif
 3000         continue
          endif
C
          if (nackey .lt. MACKEY)      then
            nackey =    nackey + 1
            actkey(nackey) = key
            aklevl(nackey) = level
            akelse(nackey) = NO
            if (dktype(1:1) .eq. 'M')  then
              if (key(1:8) .eq. 'FORTRAN ')  then
                codtyp = 'F'
                if (hedbuf(2)(1:1) .eq. '@') hedbuf(2)(1:8) = forftn
              endif
              if (key(1:8) .eq. 'ASSEMBLY')  then
                codtyp = 'A'
                if (hedbuf(2)(1:1) .eq. '@') hedbuf(2)(1:4) = '@ASM'
              endif
            endif
          else
            print 2002, ' *MAX* Active key list overflow'
 2002 format ( A )
            MXBLOK =   1
            return
          endif
        else
          return
        endif
        go to 2000
C
      end
C$F77               MXCHEK
      integer function  MXCHEK
     $                          ( )
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      integer       kval,     n
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       MXFIND
C
      external      MXFIND
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      MXCHEK =  0
      wrtlin =  YES
      if (ndikey .le. 0)               return
      if (nackey .le. 0)               then
        wrtlin =   NO
        return
      endif
      n =       nackey
C
 2000  if (n .gt. 0)                  then
          kval =    MXFIND (actkey(n))
          if (kval .lt. 0)             then
            MXCHEK =   1
            if (kval .eq. -1)          then
              print 2001, ' *MAX* Undefined macrokey'
 2001 format( A )
            else
              print 2001, ' *MAX* Defined keylist overflow'
            endif
            return
          endif
C+---------------------------------------------------------------------+
C|        if (akelse(n) .eq. YES)      kval = abs(1-kval)              |
C+---------------------------------------------------------------------+
          if (kval .eq. 0)             then
            wrtlin =  NO
            return
          endif
          n =         n - 1
          go to 2000
        endif
      return
      end
C$F77               MXDATA
      subroutine    MXDATA
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character*48  key
      integer       i,        nextch,   nk
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       GETWRD
      external      GETWRD
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      fnamr   =  ' '
      fnamw   =  ' '
      fextr   =  ' '
      fextw   =  ' '
      fuc     =  ' '
      forftn  =  '@FTN,SIO'
      hdglin  =  NO
      lisinf  =  NO
      inlcmt  =  '   '
      nextch  =  1
      ndklis  =  0
      ndkpro  =  0
      ndikey  =  0
      nolist  =  NO
      nohead  =  NO
      nukpro  =  0
      machin  =  'VAX'
      wrtcom  =  NO
      wrtmsc  =  NO
      xincld  =  NO
      xwrmsc  =  YES
      xqtmod  =  'STREAM'
C
 1000 nk      =  GETWRD (0, text, nextch, key)
      if (nk .le. 0)                   return
C+---------------------------------------------------------------------+
C|    1st character of key = '<'                                       |
C+---------------------------------------------------------------------+
      if     (key(1:1) .eq. '<')       then
        fnamr =   key(2:)
C+---------------------------------------------------------------------+
C|    1st character of key = '>'                                       |
C+---------------------------------------------------------------------+
      elseif (key(1:1) .eq. '>')       then
        fnamw =   key(2:)
        if (key(2:2) .eq. ' ')         fnamw = '0'
C+---------------------------------------------------------------------+
C|    1st char .ne. '<' or '>', hence change 'key' to UPPER CASE       |
C|                              for all remaining tests                |
C+---------------------------------------------------------------------+
      else
        call     CC2UC (key, key, nk)
C+---------------------------------------------------------------------+
C|      1st character of key = '/'  (qualifier)                        |
C+---------------------------------------------------------------------+
        if (key(1:1) .eq. '/')         then
C
          if (key(2:4) .eq. 'FOR')     then
            if (xqtmod(1:1) .eq. 'A')  then
              xqtmod =  'MIXED'
            else
              xqtmod =  'FORTRAN'
            endif
          endif
C
          if (key(2:4) .eq. 'ASM')     then
            if (xqtmod(1:1) .eq. 'F')  then
              xqtmod =  'MIXED'
            else
              xqtmod =  'ASM'
            endif
          endif
C
          if (key(2:3) .eq. 'DA')      xqtmod = 'DATA'
C
          if (key(2:3) .eq. 'AP')      machin = 'APOLLO'
          if (key(2:3) .eq. 'CD')      machin = 'CDC'
          if (key(2:3) .eq. 'CY')      machin = 'CY205'
          if (key(2:3) .eq. 'CR')      machin = 'CRAY'
          if (key(2:3) .eq. 'FP')      machin = 'FPS'
          if (key(2:3) .eq. 'IB')      machin = 'IBM'
          if (key(2:3) .eq. 'SP')      machin = 'SPERRY'
          if (key(2:3) .eq. 'UN')      machin = 'UNIX'
C
          if (key(2:3) .eq. 'WC')      wrtcom = YES
          if (key(2:3) .eq. 'WA')      wrtcom = YES+YES
C
          if (key(2:3) .eq. 'UC')      fuc    = key(2:)
C
          if (key(2:3) .eq. 'WM')      wrtmsc = YES
C
          if (key(2:3) .eq. 'XM')      xwrmsc = NO
C
          if (key(2:3) .eq. 'NL')      nolist = YES
C
          if (key(2:4) .eq. 'XDH')     nohead = YES
C
          if (key(2:2) .eq. 'H')       hdglin = YES
C
          if (key(2:2) .eq. 'L')       lisinf = YES
C
          if (key(2:3) .eq. 'D=')  call  CCL2I (key(4:), 2, ndkpro)
          if (key(2:3) .eq. 'K=')  call  CCL2I (key(4:), 2, nukpro)
C
          if (key(2:4) .eq. 'SIC')     then
            i =      INDEX(key,'=')
            if (i .ne. 0)              then
              inlcmt(2:2) = key(i+1:i+1)
            else
              inlcmt(2:2) = '!'
            endif
          endif
C
          if (key(2:2) .eq. 'M')       then
            i =      INDEX(key,'=')
*           print '('' key: '',A,''  i: '',I5)', key(1:12), i
            if (i .gt. 0)              then
              machin =  key(i+1:)
            endif
          endif
C
          if (key(2:3) .eq. 'TI')      xincld = YES
C+---------------------------------------------------------------------+
C|      1st character of key = '#'  (specified 'deck' name)            |
C+---------------------------------------------------------------------+
        else if (key(1:1) .eq. '#')     then
C
          if (ndklis .lt. MDKLIS)       then
            ndklis =   ndklis + 1
            dklist(ndklis) = key(2:13)
          endif
C+---------------------------------------------------------------------+
C|      1st character of key = ( something else )                      |
C+---------------------------------------------------------------------+
        else
          if (ndikey .lt. MDIKEY)      then
            ndikey =  ndikey + 1
            diskey(ndikey) = key(1:24)
            if (key(1:6) .eq. 'ATHENA') forftn = '@FOR,SI '
          endif
        endif
C+---------------------------------------------------------------------+
C|    go and process the next 'key'                                    |
C+---------------------------------------------------------------------+
      endif
      go to 1000
C
      end
C$F77               MXDECK
       integer function  MXDECK
     $                           (cbline, nxtch)
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     cbline*(*)
      integer       nxtch
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
      character     name*12,  namx*12
      integer       GETWRD,   nxt,      j
      external      GETWRD
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      MXDECK =   0
      if (nackey .gt. 0)                  then
        print 1001, dkname
 1001 format (' *MAX* Warning: unbalanced keys in deck: ',A)
        print 1002, (actkey(j),j=1,nackey)
 1002 format(7X,A,A,A)
        nackey =   0
      endif
C
      dktype  =  'FORTRAN'
      nxt     =  nxtch
      dkname  =  'AAAAAA'
C
      if (GETWRD (0, cbline, nxt, name) .eq. 0)  return
      dkname  =  name
C
      if (GETWRD (1, cbline, nxt, namx) .eq. 0)  return
C
      if (GETWRD (1, cbline, nxt, name) .ne. 0)  then
        dktype = name
      else
        if ((namx(1:8) .eq. 'ASSEMBLY') .or.
     $      (namx(1:7) .eq. 'FORTRAN' ) .or.
     $      (namx(1:5) .eq. 'MIXED'   )      )   then
         dktype = namx
        endif
      endif
C
      return
      end
C$F77               MXDICK
      integer function  MXDICK
     $                          ( )
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      integer       i,        k,        ceqwrt,   linwrt
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       MXCHEK,   MXGETL,   MXLINE
C
      external      MXCHEK,   MXGETL,   MXLINE
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      dkline =  0
C
 2000   MXDICK =   MXGETL ( )
C
        if (MXDICK .ne. -1)          then
          dkline =   dkline + 1
          linwrt =   wrtlin
C
          if (lintyp .eq. CEQUAL)      then
            ceqwrt =   wrtmsc
            if (MXLINE( ) .gt. 0)      go to 6000
            if (msctyp .eq. DECK)      then
              call       MXTAIL
              wrtlin =   YES
              if (ndikey .gt. 0)       wrtlin = NO
              return
            elseif (wrtdek .eq. NO)    then
              go to 2000
            elseif (msctyp .eq. BLOCK  .or.
     $              msctyp .eq. BLELSE .or.
     $              msctyp .eq. BLEND) then
              if (MXCHEK( ) .gt. 0)      go to 6000
            elseif (msctyp .eq. ERROR) then
              print 2001,  ' *MAX* Forced error exit'
 2001 format ( A )
              go to 6000
            elseif (msctyp .eq. OTHER .and.
     $              ceqwrt .eq. NO)    then
              do 2200  i = 1,ndikey
                if (msckey .eq. diskey(i)(1:12))  go to 2500
 2200           continue
            endif
            if (ceqwrt .eq. NO)        go to 2000
 2500       continue
            call       MXWMSC (line)
            go to 2000
C
          elseif (wrtdek .eq. NO)      then
            go to 2000
C
          elseif (lintyp .eq. COMENT)  then
            if ((wrtcom .eq. YES+YES .and.
     $           xqtmod(1:1) .ne. 'S') .or.
     $          (wrtcom .eq. YES .and.
     $           wrtlin .eq. YES))     then
              call       MXWRIT  (line)
            endif
C
          else
            if (nackey .eq. 0 .and.
     $          xqtmod(1:1) .ne. 'S') wrtlin = YES
            if (wrtlin .eq. YES)      then
              if (xqtmod(1:1) .eq. 'F' .or.
     $             xqtmod(1:1) .eq. 'M')  then
                if (lintyp .eq. INCLUD .and.
     $              codtyp .eq. 'F'    .and.
     $              xincld .eq. YES          )   call MXTINC
                if (inlcmt(2:2) .ne. ' ')        then
                  k =     INDEX (line, inlcmt)
                  if (k .gt. 7)        line(k:) = ' '
                endif
              endif
              call     MXWRIT  (line)
            endif
          endif
C
          go to 2000
        endif
C
 5000 continue
      return
C
 6000 print 6001, line(1:MXDICK)
 6001 format (7X,'Culprit line: ',A)
      print 6002, dkline, dkname
 6002 format (7X,'Line ',I6,' of deck ',A12)
      print 6003, 'Distribution process aborted'
 6003 format (7X,A)
      MXDICK =    -1
      go to 5000
C
      end
C$F77               MXDROP
      subroutine    MXDROP
     $                      (k)
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      integer       k
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      integer       j
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      if (k .lt. nackey)           then
        do 3500  j = k+1,nackey
          actkey(j-1) =  actkey(j)
          aklevl(j-1) =  aklevl(j)
          akelse(j-1) =  akelse(j)
 3500   continue
      endif
C
      actkey(nackey) = ' '
      nackey =   nackey - 1
      return
      end
C$F77               MXELSE
      integer function  MXELSE
     $                          (cbline, nxtch)
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     cbline*(*)
      integer       nxtch
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     key*26
      integer       i,        level,    nxt
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       GETWRD,   MXBEND,   MXBLOK
C
      external      GETWRD,   MXBEND,   MXBLOK
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      MXELSE =   0
      if (nackey .le. 0)              then
        print 1001, ' *MAX* Warning: C=', msckey,
     $                   ' not preceded by C=BLOCK'
 1001 format ( A,A,A)
        MXELSE =   -1
        return
      endif
      level =   aklevl(nackey)
      i =       nackey
 2000   if (i .le. 0)                     go to 2500
        if (aklevl(i) .eq. level .and.
     $      akelse(i) .eq. NO)            then
          key    =   ' '//actkey(i)
          MXELSE =   MXBEND (key, 1)
          if (key(2:2) .ne. '-')        then
            key(1:1) =  '-'
          else
            key(2:2) =  ' '
          endif
          MXELSE =   MXBLOK (key, 1)
          if (MXELSE .gt. 0)              return
          akelse(i) =  YES
          aklevl(i) =  level
        endif
        i =        i - 1
        go to 2000
C
 2500   continue
        if (msckey(5:5) .eq. ' ')        return
C
        nxt =     nxtch
 3000   if (GETWRD (1, cbline, nxt, key(1:24)) .gt. 0)     then
          key(25:25)  =  ' '
          MXELSE      =  MXBLOK (key, 1)
          if (MXELSE .gt. 0)               return
          if (MXELSE .eq. 0)               aklevl(nackey) = level
          go to 3000
        else
          return
        endif
      end
C$F77               MXFIND
      integer function  MXFIND
     $                          (key)
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
*     character     key*(*)
      character     key*24
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character*24  keyrut
      integer       i,        f1,       f2
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       KEYCMP
C
      external      KEYCMP
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      MXFIND =   1
      keyrut =   key
      f1 =       0
      f2 =       1
      if (key(1:1) .eq. '-')           then
        keyrut =    key(2:)
        f1 =        1
        f2 =       -1
      endif
C
      if (ndikey .gt. 0)               then
        i =      ndfkey + 1
        go to 2500
 2000     continue
          if (keyrut .eq. defkey(i))   then
            MXFIND =    f1 + f2*dfkval(i)
*           print '(A,A,A,I3)', ' MXFIND(', key(1:8),
*    $                          '): ', MXFIND
            return
          endif
 2500     i =       i - 1
          if (i .gt. 0)                go to 2000
C
        if (key(1:1) .eq. '*')        then
          MXFIND = -1
          return
        else
          if (ndfkey .ge. MDFKEY)      then
            MXFIND = -2
            return
          endif
          MXFIND =    f1
          do 3200  i = 1,ndikey
            if (KEYCMP (keyrut, diskey(i)) .eq. 1)  then
              MXFIND =  1 - f1
              go to 3500
            endif
 3200       continue
 3500     ndfkey =     ndfkey + 1
          defkey(ndfkey) = keyrut
          dfkval(ndfkey) = f1 + f2*MXFIND
*
*         print '('' Defkey:'',A,''='',I2,4X,A,''='',I2,4X,A,''='',I2)',
*    $           (defkey(kk)(1:8),dfkval(kk),kk=1,ndfkey)
*
        endif
      endif
*
*     print '(A,A,A,I3)', ' MXFIND(', key(1:8),
*    $                    '): ', MXFIND
*
      return
      end
C$F77               MXGETL
      integer function  MXGETL
     $                          ( )
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      integer       i
C+---------------------------------------------------------------------+
C|                  E Q U I V A L E N C E                              |
C+---------------------------------------------------------------------+
      character     key1*1,   key2*2,   key3*3
      equivalence  (key1,key2,key3)
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       GETLIN
      external      GETLIN
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      nchlin  =  GETLIN (devr, line, MCHLIN)
      MXGETL  =  nchlin
C
      if (MXGETL .ne. -1)           then
        key3  =    line(1:3)
        if (key1      .eq. 'c')           key1      = 'C'
        if (key3(2:2) .eq. 'c')           key3(2:2) = 'C'
        i     =    MIN (nchlin,3)
        if (i .le. 3)                     key3(i:3) = '  '
C+---------------------------------------------------------------------+
C|      classify input line ( CEQUAL = ? )                             |
C+---------------------------------------------------------------------+
        lintyp =   CODE
        if ((key2 .eq. 'C=' ) .or.
     $      (key2 .eq. '*=' ) .or.
     $      (key2 .eq. '%=' ) .or.
     $      (key2 .eq. '!=' ) .or.
     $      (key2 .eq. '##' ) .or.
     $      (key2 .eq. ';=' ) .or.
     $      (key3 .eq. '. =')      )   then
          lintyp = CEQUAL
C+---------------------------------------------------------------------+
C|      check FORTRAN coding for COMENT or INCLUDE                     |
C+---------------------------------------------------------------------+
        elseif (codtyp .eq. 'F' .or.
     $         (codtyp .eq. 'P' .and. xqtmod(1:1) .eq. 'F'))   then
C
          if (key1 .eq. 'C' .or.
     $       (key1 .eq. '*' .and. key2 .ne. '*C'))
     $                                 lintyp = COMENT
          if (line(1:6)  .eq. '      ' .and.
     $       (INDEX (line( 7:17),'INCLUDE') .ne. 0 .or.
     $        INDEX (line( 7:17),'include') .ne. 0 .or.
     $        INDEX (line( 7:17),'Include') .ne. 0)     )  then
            if (INDEX (line(14:),'''') .ne. 0)
     $                                lintyp = INCLUD
          endif
C+---------------------------------------------------------------------+
C|      check ASSEMBLY coding for COMENT                               |
C+---------------------------------------------------------------------+
        else if (codtyp .eq. 'A')      then
          if (machin(1:3) .eq. 'CDC'  .or.
     $        machin(1:4) .eq. 'CRAY' .or.
     $        machin(1:5) .eq. 'CY205'     )     then
            if (key1 .eq. '*' .and. key2 .ne. '*C')
     $                                lintyp = COMENT
          else if (machin(1:3) .eq. 'IBM')       then
            if (key1 .eq. '*')        lintyp = COMENT
          else if (machin(1:3) .eq. 'SPE')       then
            if (key2 .eq. '. ')       lintyp = COMENT
          else if (machin(1:3) .eq. 'VAX')       then
            if (key1 .eq. ';')        lintyp = COMENT
          endif
        endif
      endif
C
      return
      end
C$F77               MXHEAD
      integer function  MXHEAD
     $                          ( )
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     deknam*12
      integer       n,        kbldek
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       KEYCMP
C
      external      KEYCMP
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      MXHEAD =   0
*
*     print '(A,A,A,A)', ' MXHEAD entered. dkname: ', dkname,
*    $                   '  dktype: ', dktype
*
      wrtdek =   YES
      if (ndklis .gt. 0)               then
        kbldek =   0
        do 2000  n = 1,ndklis
          deknam =   dklist(n)
          if (deknam(1:1) .eq. ' ')    kbldek = kbldek + 1
          wrtdek =   KEYCMP (dkname, deknam)
          if (wrtdek .eq. YES)           then
            if (INDEX (deknam,'*') .eq. 0 .and.
     $          INDEX (deknam,'%') .eq. 0)  dklist(n) = ' '
                go to 2500
              endif
 2000     continue
        if (kbldek .eq. ndklis)        MXHEAD = -1
      endif
C
 2500 continue
      if ((xqtmod(1:1) .eq. 'D' .and. dktype(1:1) .ne. 'D') .or.
     $    (xqtmod(1:1) .ne. 'D' .and. dktype(1:1) .eq. 'D') .or.
     $    (xqtmod(1:1) .eq. 'F' .and. dktype(1:1) .eq. 'A') .or.
     $    (xqtmod(1:1) .eq. 'A' .and. dktype(1:1) .eq. 'F'))
     $                                 wrtdek = NO
      if (wrtdek .eq. NO)              return
C
      if (splitw .eq. YES)             then
        if (kdeckw .gt. 0)             then
          if (dklinw .gt. 0)           then
            CLOSE (unit=devw)
          else
            CLOSE (unit=devw, status='delete')
            kdeckw =  kdeckw - 1
          endif
        endif
        n =      INDEX (dkname,' ') - 1
        if (n .le. 0)                  n = 12
        fnamw =    dkname(1:n)//'.'//fextw
        call       CC2LC (fnamw, fnamw, LEN(fnamw))
        OPEN (unit=devw, file=fnamw, status='new', err=7000)
      endif
C
      hedbuf(1) = ' '
      hedbuf(2) = ' '
      hedbuf(3) = ' '
      dkline =   0
      dklinw =   0
      if (nohead .eq. YES)             return
C
      if (xqtmod(1:1) .eq. 'S')        then
        if (wrtmsc .eq. YES)           then
          call      MXWRIT  (line)
        endif
        return
      endif
C
      call       MXHELL
      if (wrtmsc .eq. YES)             call MXWMSC (line)
      return
C
 7000 print 7001, fnamw
 7001 format (' *MAX* Can''t open file: ',A)
      MXHEAD =   1
      return
      end
C$F77               MXHELL
      subroutine    MXHELL
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     name*14,  head*20
      integer       i
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
      name =   dkname//' '
      head =   ' '
C+---------------------------------------------------------------------+
C|            APOLLO  ( DOMAIN )                                       |
C+---------------------------------------------------------------------+
      if (machin(1:6) .eq. 'APOLLO')             then
        head =   ' '
        if (dktype(1:1) .eq. 'F')      head = 'C$FORTRAN'
        if (dktype(1:1) .eq. 'A')      head = ' '
        if (dktype(1:1) .eq. 'M')      then
          if (xqtmod(1:1) .eq. 'F')    head = 'C$FORTRAN'
          if (xqtmod(1:1) .eq. 'A')    head = ' '
        endif
        if (dktype(1:1) .eq. 'P')      head = 'C$PROCEDURE'
C+---------------------------------------------------------------------+
C|            CDC, CRAY, CY205                                         |
C+---------------------------------------------------------------------+
      elseif ((machin(1:3) .eq. 'CDC')   .or.
     $        (machin(1:5) .eq. 'CY205') .or.
     $        (machin(1:4) .eq. 'CRAY')       )  then
        head =   '*DECK'
        if (dktype(1:1) .eq. 'P')    head = '*COMDECK'
        if (nolist .eq. YES)         then
          hedbuf(3) =  'C$    LIST (S=0) '
C                       123456789.1234567
        endif
C+---------------------------------------------------------------------+
C|            FPS   ( Standard Operating System )                      |
C+---------------------------------------------------------------------+
      elseif (machin(1:3) .eq. 'FPS')            then
        head =   ' '
        if (dktype(1:1) .eq. 'F')      head = 'C$APFTN64'
        if (dktype(1:1) .eq. 'A')      head = ' '
        if (dktype(1:1) .eq. 'M')      then
          if (xqtmod(1:1) .eq. 'F')    head = 'C$APFTN64'
          if (xqtmod(1:1) .eq. 'A')    head = ' '
        endif
        if (dktype(1:1) .eq. 'P')      head = 'C$INSERT'
C+---------------------------------------------------------------------+
C|            IBM   ( Temporary )                                      |
C+---------------------------------------------------------------------+
      elseif (machin(1:3) .eq. 'IBM')            then
        head =   ' '
        if (dktype(1:1) .eq. 'F')      head = 'C$FORTRAN'
        if (dktype(1:1) .eq. 'A')      head = ' '
        if (dktype(1:1) .eq. 'M')      then
          if (xqtmod(1:1) .eq. 'F')    head = 'C$FORTRAN'
          if (xqtmod(1:1) .eq. 'A')    head = ' '
        endif
        if (dktype(1:1) .eq. 'P')      head = 'C$PROCEDURE'
C+---------------------------------------------------------------------+
C|            Sperry (eigenborene UNIVAC) and (new_name = UNISYS)      |
C+---------------------------------------------------------------------+
      elseif (machin(1:3) .eq. 'SPE')            then
        if (hdglin .eq. YES)                     then
            hedbuf(1) =
     $      '@HDG,P                                   '//
     $       dkname(1:1)//' '//dkname(2:2)//' '//
     $       dkname(3:3)//' '//dkname(4:4)//' '//
     $       dkname(5:5)//' '//dkname(6:6)//' '//
     $       dkname(7:7)//' '//dkname(8:8)//' '//
     $       dkname(9:9)//' '
        endif
        head =  '@ELT,SI'
        if (dktype(1:1) .eq. 'F')    head = forftn
        if (dktype(1:1) .eq. 'A')    head = '@ASM,SI'
        if (dktype(1:1) .eq. 'M')    then
          if (xqtmod(1:1) .eq. 'F')  head = forftn
          if (xqtmod(1:1) .eq. 'A')  head = '@ASM,SI'
        endif
        if (dktype(1:1) .eq. 'P')    then
          head =      ' '
          if (kdeckw .eq. 0)         then
            if (xqtmod(1:1) .eq. 'A')  then
              head =   '@PDP,I'
            else
              head =   '@PDP,FI'
            endif
          endif
          i =      INDEX (name,' ') - 1
          hedbuf(3) =  name(1:i)//'* PROC '
        endif
C+---------------------------------------------------------------------+
C|            UNIX                                                     |
C+---------------------------------------------------------------------+
      elseif (machin(1:4) .eq. 'UNIX')           then
        head =    ' '
        if (dktype(1:1) .eq. 'A')      head = ' '
        if (dktype(1:1) .eq. 'F')      head = 'C$F77'
        if (dktype(1:1) .eq. 'M')      then
          if (xqtmod(1:1) .eq. 'F')    head = 'C$F77'
          if (xqtmod(1:1) .eq. 'A')    head = ' '
        endif
        if (dktype(1:1) .eq. 'P')      head = 'C$INC'
C+---------------------------------------------------------------------+
C|            VAX  ( VMS )                                             |
C+---------------------------------------------------------------------+
      elseif (machin(1:3) .eq. 'VAX')            then
        head =   'C$??????'
        if (dktype(1:1) .eq. 'A')      head = ';MACRO'
        if (dktype(1:1) .eq. 'F')      head = 'C$FORTRAN'
        if (dktype(1:1) .eq. 'M')      then
          if (xqtmod(1:1) .eq. 'F')    head = 'C$FORTRAN'
          if (xqtmod(1:1) .eq. 'A')    head = ';MACRO'
        endif
        if (dktype(1:1) .eq. 'P')      head = 'C$PROCEDURE'
C+---------------------------------------------------------------------+
C|            UNKNOWN                                                  |
C+---------------------------------------------------------------------+
      else
        head =   ' '
        if (dktype(1:1) .eq. 'A')      head = ' '
        if (dktype(1:1) .eq. 'F')      head = 'C$FORTRAN'
        if (dktype(1:1) .eq. 'M')      then
          if (xqtmod(1:1) .eq. 'F')    head = 'C$FORTRAN'
          if (xqtmod(1:1) .eq. 'A')    head = ' '
        endif
        if (dktype(1:1) .eq. 'P')      head = 'C$PROCEDURE'
      endif
C+---------------------------------------------------------------------+
C|            Store header in hedbuf(-) array for later use            |
C+---------------------------------------------------------------------+
      if (head(1:1) .ne. ' ')          hedbuf(2) = head//name
C
*     print *, ' hedbuf(1): ', hedbuf(1)(1:48)
*     print *, ' hedbuf(2): ', hedbuf(2)(1:48)
*     print *, ' hedbuf(3): ', hedbuf(3)(1:48)
*
      return
      end
C$F77               MXLINE
      integer function  MXLINE
     $                          ( )
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      integer       n,        nextch
      character     keyceq*12
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       GETWRD,   MXBEND,   MXBLOK,   MXDECK,   MXMACR,
     $              MXELSE
C
      external      GETWRD,   MXBEND,   MXBLOK,   MXDECK,   MXMACR,
     $              MXELSE
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
      MXLINE =   0
      nextch =   3
      if (line(3:3) .eq. '=')            nextch = 4
      n =        GETWRD (1, line, nextch, keyceq)
      msckey =   keyceq
C
      if (keyceq(1:4) .eq. 'DECK' .or.
     $    keyceq(1:4) .eq. 'MODU')       then
        msctyp =   DECK
        MXLINE =   MXDECK  (line, nextch)
        codtyp =   dktype
C
      else if (keyceq(1:4) .eq. 'BLOC' .or.
     $         keyceq(1:2) .eq. 'IF')           then
        msctyp =   BLOCK
        MXLINE =   MXBLOK  (line, nextch)
C
      else if (keyceq(1:4) .eq. 'ELSE')         then
        msctyp =   BLELSE
        MXLINE =   MXELSE  (line, nextch)
C
      else if (keyceq(1:3) .eq. 'END')          then
        msctyp =   BLEND
        MXLINE =   MXBEND  (line, nextch)
C
      else if (keyceq(1:1) .eq. '*')           then
        msctyp =   MACRO
        MXLINE =   MXMACR  (line, 3)
      else if (keyceq(1:3) .eq. 'ERR')          then
        msctyp =   ERROR
C
      else
        msctyp =   OTHER
      endif
C
      return
      end
C$F77               MXLOAD
      subroutine    MXLOAD
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      integer       m
C
      character     tok*80
      integer       i,        jb,       lb,       le,       lt
      integer       maxa
C
      integer                 iargc,    LENETB
      external      getarg,   iargc,    LENETB
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
C+---------------------------------------------------------------------+
C|    Input and collect all of the COMMAND_LINE arguments              |
C+---------------------------------------------------------------------+
      le   =   0
      text =   ' '
C
      maxa =   iargc()
      if (maxa .le. 0)                 return
C
      do 100 i = 1,maxa
C
        call   getarg (i, tok)
C
        lt  =  LENETB (tok)
        jb  =  1
C
        if (tok(1:1) .eq. '-')         then
          if     ((tok(2:2) .eq. 'i') .or.
     $            (tok(2:2) .eq. 'I')      )     then
            tok(1:2)  =  ' <'
            jb        =  2
            go to 50
          elseif ((tok(2:2) .eq. 'o') .or.
     $            (tok(2:2) .eq. 'O')      )     then
            tok(1:2)  =  ' >'
            jb        =  2
            go to 50
          endif
          print 3000, tok(1:lt)
          stop '*error stop*'
        endif
C
   50   lb  =  le + 1
        le  =  lb + lt-jb+1
        if (le .gt. MCHTXT)            then
          print 3001, MCHTXT
          stop '*error stop*'
        endif
C
        if (jb.eq.2 .and. lt.eq.2)     then
          le  =  le - 1
          text(lb:le) = tok(jb:lt)
        else
          text(lb:le) = tok(jb:lt)//' '
        endif
C
  100 continue
      m    =  le - 1
C
*     print '(/1X,''Cmd_Line: m= '',I3,''  text= '',A)', m,text(1:m)
C
 2000 if (text(m:m) .ne. ' ')      go to 2500
      m         =  m - 1
      if (m .gt. 1)                go to 2000
C
 2500 continue
      return
C+---------------------------------------------------------------------+
C|    Format statements                                                |
C+---------------------------------------------------------------------+
 3000 format (/' ERROR, illegal input argument (-i & -o): ',A/)
 3001 format (/' ERROR, total argument(s) length .gt. MCHTXT = ',I3/)
      end
C$F77               MXMACR
      integer function  MXMACR
     $                          (cbline, nxtch)
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     cbline*(*)
      integer       nxtch
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     key*24,   mkey*24
      character*5   andor,    sandor
      integer       imac,     m,        kval,     nxt,      value
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       GETWRD,   MXFIND
C
      external      GETWRD,   MXFIND
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      MXMACR =   0
C
      nxt =      nxtch
      m =        GETWRD (1, cbline, nxt, mkey)
      imac =     ndfkey
      m =        0
C
 1500   if (imac .le. 0)               go to 2000
        if (mkey .eq. defkey(imac))    go to 2000
        imac =    imac - 1
        go to 1500
C
 2000   if ( GETWRD (1, cbline, nxt, key) .ne. 0)          then
          kval =     MXFIND (key)
          if (kval .lt. 0)             then
            MXMACR =   1
            if (kval .eq. -1)          then
              print 2001, ' *MAX* Undefined macrokey'
 2001 format ( A )
            else
              print 2001, ' *MAX* Defined-key table overflow'
            endif
            return
          endif
          if (m .eq. 0)                then
            value =   kval
          else
            if (andor(2:2) .eq. 'A')
     $                                 value = and (value,kval)
            if (andor(2:2) .eq. 'O')
     $                                 value = or (value,kval)
          endif
          if ( GETWRD (1, cbline, nxt, andor) .eq. 0)      then
            if (imac .eq. 0)           then
              if (ndfkey .lt. MDFKEY)  then
               imac =    ndfkey + 1
               ndfkey =  imac
              else
                print 2001, ' *MAX* Defined-key table overflow'
               MXMACR =   1
               return
              endif
            endif
            defkey(imac) =  mkey
            dfkval(imac) =  value
            return
          else
            if (andor .ne. '.OR.' .and.
     $          andor .ne. '.AND.')    then
              print 2001, ' *MAX* Illegal connective'
              MXMACR =  1
              return
            endif
            if (m .eq. 0)              then
              sandor =  andor
            else
              if (andor .ne. sandor)   then
                print 2001, ' *MAX* Mixed AND-ORs are no-nos'
                MXMACR =   1
                return
              endif
            endif
            m =        m + 1
          endif
          go to 2000
        endif
C
      return
      end
C$F77               MXOPEN
      subroutine    MXOPEN
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character*48  filnam,   sname
      integer       i,        jdot
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
C+---------------------------------------------------------------------+
C|    setup and OPEN the 'read' file                                   |
C+---------------------------------------------------------------------+
      devr =     0
      if (fnamr(1:1) .ne. '0')        then
        devr =     1
        splitr =   NO
        jdot =        INDEX (fnamr,'.')
        if (jdot .eq. 0)               then
          i =         INDEX (fnamr,' ')
          sname =     fnamr(1:i-1)//'.MSC'
          fnamr =     sname
        endif
        filnam =   fnamr
        OPEN (unit=devr, status='old', file=fnamr,
     $        err=6000)
      endif
C+---------------------------------------------------------------------+
C|    setup and OPEN the 'write' file                                  |
C+---------------------------------------------------------------------+
      devw =     0
      if (fnamw(1:1) .ne. '0')       then
        devw =     2
        splitw =   NO
        if (fnamw(1:1) .eq. '.')        then
          fextw =    fnamw(2:8)
          jdot =     INDEX (fnamr,'.')
          sname =    fnamr(1:jdot-1)//'.'//fextw
          fnamw =    sname
        endif
C
        if (fnamw(1:1) .eq. '/')      then
          splitw =   YES
          fextw =    fnamw(2:8)
        endif
C
        if (splitw .eq. NO)             then
          filnam =  fnamw
          OPEN (unit=devw, status='new', file=fnamw,
     $          err=6000)
        endif
      endif
C
      return
 6000 print 6001, filnam
 6001 format (' *MAX* Can''t open file: ',A)
      stop '*error stop*'
      end
C$F77               MXPROD
      subroutine    MXPROD
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character*24  name
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
C+---------------------------------------------------------------------+
C|    prompt for INPUT 'read' file name                                |
C+---------------------------------------------------------------------+
      if (fnamr(1:1) .eq. ' ')         then
        call     MXREAP (0, 'Input  filename:', fnamr)
      endif
C+---------------------------------------------------------------------+
C|    prompt for OUTPUT 'write' file name                              |
C+---------------------------------------------------------------------+
      if (fnamw(1:1) .eq. ' ')         then
        call     MXREAP (0, 'Output filename:', fnamw)
      endif
C+---------------------------------------------------------------------+
C|    prompt for 'ndkpro' DECK names                                   |
C+---------------------------------------------------------------------+
 2000 if (ndkpro .gt. 0)               then
        if (ndklis .lt. MDKLIS)        then
          call     MXREAP (1, 'Deck name:', name)
          ndklis =   ndklis + 1
          dklist(ndklis) = name
        endif
        ndkpro =   ndkpro - 1
        go to 2000
      endif
C+---------------------------------------------------------------------+
C|    prompt for 'nukpro' distribution KEYs                            |
C+---------------------------------------------------------------------+
 3000 if (nukpro .gt. 0)               then
        if (ndikey .lt. MDIKEY)        then
          call     MXREAP (1, 'Distribution key:', name)
          ndikey =   ndikey + 1
          diskey(ndikey) = name
        endif
        nukpro =   nukpro - 1
        go to 3000
      endif
C
      return
      end
C$F77               MXREAP
      subroutine    MXREAP
     $                      (uc, prompt, reply)
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character*(*) prompt,   reply
      integer       uc
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     ch,       chread*48
      integer       i,        ich
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
      i =      INDEX (prompt,':')
 1000 continue
      print  9000, prompt(1:i)
      read   9001, chread
C
      reply =    ' '
C
      do 2000  i = 1,MIN(LEN(chread), LEN(reply))
        ch  =    chread(i:i)
        ich =    ICHAR(ch)
        if (ich .le. ICHAR(' '))       go to 3000
C
        if (uc .ne. 0)                 then
          if (ich .ge. ICHAR('a') .and.
     $        ich .le. ICHAR('z')       )        then
            ich =  ich - (ICHAR('a')-ICHAR('A'))
            ch  =  CHAR(ich)
          endif
        endif
C
        reply(i:i)  =  ch
 2000   continue
 3000 continue
C
      if (reply(1:1) .eq. ' ')         go to 1000
      return
C+---------------------------------------------------------------------+
C|    Format statements                                                |
C+---------------------------------------------------------------------+
 9000 format (1X,A,' ',$)
 9001 format (A)
      end
C$F77               MXSET
      subroutine    MXSET
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      integer        j
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      dkname =   ' '
      dkline =   0
      dklinw =   0
      dktype =   ' '
      kdeckw =   0
      klinew =   0
      nackey =   0
      ndfkey =   0
C
      if (xqtmod(1:1) .eq. 'F' .or. xqtmod(1:1) .eq. 'M') then
        call       MXADIK ('FORTRAN ')
      endif
      if (xqtmod(1:1) .eq. 'A' .or. xqtmod(1:1) .eq. 'M') then
        call       MXADIK ('ASSEMBLY')
      endif
C
      if (xqtmod(1:1) .ne. 'S' .and. xqtmod(1:1) .ne. 'D')  then
        if (machin(1:1) .eq. ' ')     then
          call     MXADIK ('VAX')
        else
          call     MXADIK (machin)
         endif
      endif
C
      if (ndikey .le. 0)              then
        wrtcom =   YES
        wrtmsc =   YES
      endif
C
      if (xqtmod(1:1) .eq. 'S')      then
        wrtmsc =  xwrmsc
      endif
C
      if (lisinf .eq. YES)           then
        if (ndikey .le. 0)           then
          print 1001, 'No distribution keys'
 1001 format ( A )
        else
         print 1002, (diskey(j),j=1,ndikey)
 1002 format (' Distribution keys: ',2A24)
        endif
      endif
C
      return
      end
C$F77               MXTAIL
      subroutine    MXTAIL
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character*(MCHLIN)  tail
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      if (wrtdek      .eq.  NO .or.
     $    xqtmod(1:1) .eq. 'S' .or.
     $    xqtmod(1:1) .eq. 'D')        return
C
      tail(1:4) =  ' '
      if (codtyp .eq. 'P')             then
        if (machin(1:3) .eq. 'CDC'  .or.
     $      machin(1:4) .eq. 'CRAY' .or.
     $      machin(1:5) .eq. 'CY205'     )       then
          if (nolist .eq. YES)         then
            tail =   'C$    LIST (S=1) '
          endif
        endif
        if (machin(1:3) .eq. 'SPE')              then
          tail =   ' END '
        endif
      endif
C
      if (tail(1:4) .ne. '    ')       then
        call   MXWRIT (tail)
      endif
      return
      end
C$F77               MXTINC
      subroutine    MXTINC
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     fname*48, ext*3
      integer       i,        j,        k,        n
C+---------------------------------------------------------------------+
C|                  E X T E R N A L S                                  |
C+---------------------------------------------------------------------+
      integer       LENETB
C
      external      CC2LC,    LENETB
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
C+---------------------------------------------------------------------+
C|                   VAX  ( use as is, no translations )               |
C+---------------------------------------------------------------------+
      if (machin(1:3) .eq. 'VAX')      return
C+---------------------------------------------------------------------+
C|                   extract file_name, file_extension, etc.           |
C+---------------------------------------------------------------------+
      i =       INDEX (line,'''')
      j =       INDEX (line,':')
      k =       INDEX (line,']')
      if (k .gt. 0)                   j = k
      if (j .eq. 0)                   j = i
      i   =     INDEX (line(j+1:),'.')
      n   =     i - 1
      k   =     INDEX (line(j+1:),'/')
      if (k .gt. 0 .and. n .eq. 0)    n = k - 1
      k =       INDEX (line(j+1:),'''')
      if (n .eq. 0)                   n = k - 1
      fname =   line(j+1:j+n)
      m   =     0
      ext =     ' '
      if (i .gt. 0)                    then
        m   =  k - i - 1
        ext =  line(j+i+1:j+k-1)
      endif
C+---------------------------------------------------------------------+
C|                  APOLLO  ( DOMAIN )                                 |
C+---------------------------------------------------------------------+
      if (machin(1:6) .eq. 'APOLLO')             then
        call     CC2LC (fname, fname, n)
        call     CC2LC (ext,   ext,   m)
        if (ext(1:1) .ne. ' ')         then
          line = '%include            '''//fname(1:n)//'.'//ext(1:m)//
     $           ''' '
        else
          line = '%include            '''//fname(1:n)//''' '
        endif
C+---------------------------------------------------------------------+
C|                  CRAY  and  CDC  (UPDATE format)                    |
C+---------------------------------------------------------------------+
      elseif (machin(1:3) .eq. 'CDC'  .or.
     $        machin(1:4) .eq. 'CRAY' .or.
     $        machin(1:5) .eq. 'CY205'     )     then
        line = '*CALL               '//fname(1:n)//' '
C+---------------------------------------------------------------------+
C|                  HONEYWELL  ( DPS8 )                                |
C+---------------------------------------------------------------------+
      elseif (machin(1:4) .eq. 'DPS8')           then
        if (ext(1:1) .ne. ' ')         then
          line = '      include       '//fname(1:n)//'_'//ext(1:m)//' '
        else
          line = '      include       '//fname(1:n)//' '
        endif
C+---------------------------------------------------------------------+
C|                  FPS                                                |
C+---------------------------------------------------------------------+
      elseif (machin(1:3) .eq. 'FPS')            then
        call     CC2LC (fname, fname, n)
        call     CC2LC (ext,   ext,   m)
        if (ext(1:1) .ne. ' ')         then
          line = '$INSERT             '''//fname(1:n)//'.'//ext(1:m)//
     $           ''' '
        else
          line = '$INSERT             '''//fname(1:n)//''' '
        endif
C+---------------------------------------------------------------------+
C|                  IBM    (VS FORTRAN 5 = FORTRAN_77)                 |
C+---------------------------------------------------------------------+
      elseif (machin(1:3) .eq. 'IBM')            then
        line = '      include       ('//fname(1:n)//') '
C+---------------------------------------------------------------------+
C|                  SPERRY  (UNIVAC)                                   |
C+---------------------------------------------------------------------+
      elseif (machin(1:3) .eq. 'SPE')            then
        call     CC2LC (fname, fname, n)
        line = '      include       '//fname(1:n)//' '
C+---------------------------------------------------------------------+
C|                  UNIX  ( SYS_5 & BSD_4.2 )                          |
C+---------------------------------------------------------------------+
      elseif (machin(1:4) .eq. 'UNIX')           then
        call     CC2LC (fname, fname, n)
        call     CC2LC (ext,   ext,   m)
        if (ext(1:1) .ne. ' ')         then
          line = '      include       '''//fname(1:n)//'.'//ext(1:m)//
     $           ''' '
        else
          line = '      include       '''//fname(1:n)//''' '
        endif
      endif
C
      return
      end
C$F77               MXWMSC
      subroutine    MXWMSC
     $                      (ceqlin)
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     ceqlin*(*)
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     outlin*80
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      outlin =   ceqlin
      if (xqtmod(1:1) .ne. 'S')      then
C+---------------------------------------------------------------------+
C|    Insure ASSEMBLER output correct for destination machine          |
C+---------------------------------------------------------------------+
        if (codtyp .eq. 'A')           then
          if (machin(1:3) .eq. 'CDC'  .or.
     $        machin(1:4) .eq. 'CRAY' .or.
     $        machin(1:5) .eq. 'CY205'     )     outlin(1:1) = '*'
          if (machin(1:3) .eq. 'IBM')            outlin(1:1) = '*'
          if (machin(1:3) .eq. 'SPE')            then
            if (outlin(1:2) .ne. '. ')           then
              outlin  =  '. '//ceqlin(2:)
            endif
          endif
          if (machin(1:3) .eq. 'VAX')            outlin(1:1) = ';'
        endif
C
        if (codtyp .eq. 'F')           then
          outlin(1:1) =  'C'
        endif
      endif
C
      if (outlin(2:3) .eq. '=+')     then
        outlin(2:) = '     ++++++++++++++++++++++++++++++++++'//
     $               '+++++++++++++++++++++++++++ '
      endif
C
      call       MXWRIT  (outlin)
      return
      end
C$F77               MXWRIT
      subroutine    MXWRIT
     $                      (outlin)
C+---------------------------------------------------------------------+
C|                  C O M M O N   &   G L O B A L S                    |
C+---------------------------------------------------------------------+
      include       'cmxdat.inc'
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     outlin*(*)
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      integer       i,        mch
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      mch =       LEN (outlin)
      do 2000  i = 1,3
        if (hedbuf(i)(1:1) .ne. ' ')       then
          call     PUTLIN (devw, hedbuf(i), mch)
          klinew =   klinew + 1
          dklinw =   dklinw + 1
          hedbuf(i) =  ' '
        endif
 2000   continue
        if (fuc .eq. 'UCALL' .or.
     $     (fuc(1:2) .eq. 'UC' .and. lintyp .eq. CODE)) then
            call CC2UC (outlin, outlin, 0)
        endif
      call       PUTLIN  (devw, outlin, mch)
      klinew =   klinew + 1
      dklinw =   dklinw + 1
      outlin =   ' '
      return
      end
C$F77               KEYCMP
      integer function  KEYCMP
     $                          (ckey, xkey)
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     ckey*(*), xkey*(*)
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     ch1,      ch2
      integer       i,        j,        k,        n,        ich,
     $              icyc,     imax,     imin,     inc
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      KEYCMP =   1
      i      =   0
      j      =   0
 2000   j =        j + 1
        if (j .gt. len(xkey) .or. KEYCMP .eq. 0)  return
        i =        i + 1
        ch1 =     ckey(i:i)
        ch2 =     xkey(j:j)
        if (ch2 .eq. '*')             then
          if (xkey(j+1:j+1) .ne. '.')  then
            return
          else
            i =      INDEX (ckey,'.') - 1
            if (i .le. 0)              KEYCMP = 0
          endif
          go to 2000
        endif
        if (ch2 .eq. '%')              go to 2000
        if (ch1 .ne. ch2)              KEYCMP = 0
        if (ch1 .eq. ' ')              return
        if (ch2 .ne. '.')              then
          go to 2000
        else
          k =      INDEX (xkey,':')
          if (k .le. j)                go to 2000
          imin =    0
          imax =    0
          icyc =    0
          if (xkey(k+1:k+1).eq.' ')    imax = 999999
          do 2500  n = 1,6
            j =      j + 1
            if (j .lt. k)              then
              ich =    ICHAR(xkey(j:j)) - ICHAR('0')
              if (ich .ge. 0 .and. ich .le. 9) imin = 10*imin + ich
            endif
            ich =    ICHAR(xkey(k+n:k+n)) - ICHAR('0')
            if (ich .ge. 0 .and. ich .le. 9) imax = 10*imax + ich
            ich =    ICHAR(ckey(i+n:i+n)) - ICHAR('0')
            if (ich .ge. 0 .and. ich .le. 9) icyc = 10*icyc + ich
 2500       continue
          if (imax .eq. 0)             then
            imax =    imin
          else if (imax .lt. imin)     then
            inc =     10
            if (imax .ge. 10)          inc = 100
            if (imax .ge. 100)         inc = 1000
            if (imax .ge. 1000)        inc = 10000
 2600         imax =    imax + inc
              if (imax .lt. imin)      go to 2600
          endif
          if (icyc .lt. imin .or. icyc .gt. imax)  KEYCMP = 0
          return
        endif
      end
C$F77               GETWRD
      integer function  GETWRD
     $                          (uc, s, j, word)
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     s*(*),    word*(*)
      integer       uc,       j
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character*1   ch,       chlast
      integer       i,        k,        m,        slen
C+---------------------------------------------------------------------+
C|                  P A R A M E T E R                                  |
C+---------------------------------------------------------------------+
      character*1   HTAB
*     parameter    (HTAB = CHAR('09'X))
C+---------------------------------------------------------------------+
C|                   L O G I C                                         |
C+---------------------------------------------------------------------+
      HTAB  =    CHAR(09)
      slen  =    LENETB (s)
C
      word  =    ' '
      m     =    LEN(word)
      k     =    0
      i     =    j - 1
C
 2000 i   =    i + 1
      if (i .gt. slen)                 go to 4000
      ch  =    s(i:i)
      if (ch .eq. '$' .or.
     $    ch .eq. '!'      )           go to 4000
      if (ch .eq. ' ' .or.
     $    ch .eq. ',' .or.
     $    ch .eq. HTAB     )           go to 2000
      go to 3200
C
 3000 if (i .gt. slen)                 go to 4000
      ch =       s(i:i)
      if (ch .eq. ' ' .or.
     $    ch .eq. ',' .or.
     $    ch .eq. HTAB .or.
     $    ch .eq. '#' .or.
     $    ch .eq. '>' .or.
     $    ch .eq. '<'      )           go to 4000
      if (ch     .eq. '/' .and.
     $    chlast .ne. '>' .and.
     $    chlast .ne. '<'       )      go to 4000
 3200 continue
      chlast =   ch
      if (k .lt. m)                    then
        k   =      k + 1
        if (uc .ne. 0)                 then
          call   CC2UC (ch, ch, 1)
        endif
        word(k:k) = ch
      endif
      i     =    i + 1
      go to 3000
C
 4000 j     =    i
      GETWRD =   k
      return
      end
C$F77               GETLIN
      integer function  GETLIN
     $                          (device, line, mchrec)
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     line*(*)
      integer       device,   mchrec
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      integer       n,        unit
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
      unit  =    device
      line  =    ' '
      if (unit .le. 0)                  then
        read  9000, line(1:mchrec)
      else
        read (unit,9000,end=6000,err=7000) line(1:mchrec)
      endif
C+---------------------------------------------------------------------+
C|    Determine the last non-blank character in input line             |
C+---------------------------------------------------------------------+
      n =      mchrec
 3000 if (line(n:n) .ne. ' ')          go to 4000
      n =        n - 1
      if (n .gt. 1)                    go to 3000
C
 4000 GETLIN =   n
      return
C
 6000 GETLIN =   -1
      return
C
 7000 stop ' ** File read error in GETLIN **'
C+---------------------------------------------------------------------+
C|    Format statements                                                |
C+---------------------------------------------------------------------+
 9000 format (A)
C
      end
C$F77               PUTLIN
      subroutine    PUTLIN
     $                      (device, line, mchrec)
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     line*(*)
      integer       device,   mchrec
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      integer       n,        unit
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
      n   =    LENETB (line(1:mchrec))
      if (n .le. 0)                    then
        line  =  ' '
        n     =  1
      endif
C
      unit  =  device
      if (unit .le. 0)                  then
        print 9000, line(1:n)
      else
        write (unit,9001,err=7000) line(1:n)
      endif
C
      return

 7000 stop ' ** File write error in PUTLIN - Check your disk quota **'
C+---------------------------------------------------------------------+
C|    Format statements                                                |
C+---------------------------------------------------------------------+
 9000 format (1X,A)
 9001 format (A)
C
      end
C$F77               CC2UC
      subroutine    CC2UC
     $                     (cs, cd, n)
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character*(*) cs,       cd
      integer       n
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     ch
      integer       i,        ich,      m
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
      m =      n
      if (m .le. 0)                 m = LEN (cs)
      do 1000  i = 1,m
        ch =      cs(i:i)
        ich =     ICHAR (ch)
        if ((ich .ge. ICHAR('a')) .and.
     $      (ich .le. ICHAR('z'))       )        then
          ich  =  ich - (ICHAR('a') - ICHAR('A'))
          ch   =  CHAR(ich)
        endif
        cd(i:i) = ch
 1000 continue
      return
      end
C$F77               CC2LC
      subroutine    CC2LC
     $                     (cs, cd, n)
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character*(*) cs,       cd
      integer       N
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      character     ch
      integer       i,        ich,      m
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
      m =      n
      if (m .le. 0)                 m = LEN(cs)
      do 1000  i = 1,m
        ch =      cs(i:i)
        ich =     ICHAR (ch)
        if ((ich .ge. ICHAR('A')) .and.
     $      (ich .le. ICHAR('Z'))       )        then
           ich  =  ich + (ICHAR('a') - ICHAR('A'))
           ch   =  CHAR(ich)
        endif
        cd(i:i) = ch
 1000   continue
      return
      end
C$F77               CCL2I
      subroutine    CCL2I
     $                     (s, m, ival)
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character*1   s(*)
      integer       m, ival
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      integer       i,        ich,      idig,     iflag
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
      ival =     0
      iflag =    0
C
      do 3000  i = 1,m
        ich =      ICHAR(s(i))
        idig =     ich - ICHAR('0')
        if (idig .ge. 0 .and. idig .le. 9)  then
          ival =     10*ival + idig
        else if (ich .eq. ICHAR('-'))       then
          iflag =   1
        else
          if (ich .ne. ICHAR('+'))     go to 4000
        endif
 3000   continue
C
 4000 if (iflag .ne. 0)                ival = -ival
      return
      end
C$F77               LENETB
      integer function  LENETB
     $                          (c)
C+---------------------------------------------------------------------+
C|                  A R G U M E N T S                                  |
C+---------------------------------------------------------------------+
      character     c*(*)
C+---------------------------------------------------------------------+
C|                  L O C A L   V A R I A B L E S                      |
C+---------------------------------------------------------------------+
      integer       i,        ich
*     integer       ichmin,   ichmax,   ichbnk
C+---------------------------------------------------------------------+
C|                  L O G I C                                          |
C+---------------------------------------------------------------------+
C+---------------------------------------------------------------------+
C|    define Minimum/Maximum values of ICHAR for ASCII character set   |
C+---------------------------------------------------------------------+
*     ichmin  =  ICHAR(' ')
*     ichmax  =  ICHAR('~')
*     ichbnk  =  ICHAR(' ')
C
      LENETB =  LEN(c)
      do 2000  i = LEN(c),1,-1
*       if (c(i:i) .ne. ' ')           return
        ich =    ICHAR(c(i:i))
        if (ich .gt. ICHAR(' ') .and.
     $      ich .le. ICHAR('~')      ) return
        LENETB  =  i - 1
 2000 continue
      return
      end
