SUBROUTINE ZGBSVX1_F95(A, B, X, KL, AF, IPIV, FACT, TRANS, &
                      EQUED, R, C, FERR, BERR, RCOND, RPVGRW, INFO)
!
!  -- LAPACK95 interface driver routine (version 3.0) --
!     UNI-C, Denmark; Univ. of Tennessee, USA; NAG Ltd., UK
!     September, 2000
!
!  .. USE STATEMENTS ..
   USE LA_PRECISION, ONLY: WP => DP
   USE LA_AUXMOD, ONLY: LSAME, ERINFO
   USE F77_LAPACK, ONLY: GBSVX_F77 => LA_GBSVX
!  .. IMPLICIT STATEMENT ..
   IMPLICIT NONE
!  .. SCALAR ARGUMENTS ..
   CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS, FACT
   CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
   INTEGER, INTENT(IN), OPTIONAL :: KL
   INTEGER, INTENT(OUT), OPTIONAL :: INFO
   REAL(WP), INTENT(OUT), OPTIONAL :: RCOND, RPVGRW, FERR, BERR
!  .. ARRAY ARGUMENTS ..
   COMPLEX(WP), INTENT(INOUT) :: A(:,:), B(:)
   COMPLEX(WP), INTENT(OUT) :: X(:)
   INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
   COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
   REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:), R(:)
!  .. PARAMETERS ..
   CHARACTER(LEN=8), PARAMETER :: SRNAME = 'LA_GBSVX'
!  .. LOCAL SCALARS ..
   CHARACTER(LEN=1) :: LFACT, LTRANS, LEQUED
   INTEGER :: LINFO, N, ISTAT, ISTAT1, SIPIV, S1AF, S2AF, &
              SC, SR, LD, LKL, LKU, LDA
   REAL(WP) :: LRCOND, MVR, MVC, LFERR, LBERR
!  .. LOCAL POINTERS ..
   INTEGER, POINTER :: LPIV(:)
   REAL(WP),  POINTER :: RWORK(:), LC(:), LR(:)
   COMPLEX(WP),  POINTER :: WORK(:), LAF(:, :)
!  .. INTRINSIC FUNCTIONS ..
   INTRINSIC MAX, PRESENT, SIZE, MINVAL, TINY
!  .. EXECUTABLE STATEMENTS ..
   LINFO = 0; ISTAT = 0
   LDA = SIZE(A,1); N = SIZE(A, 2); LD = MAX(1,N)
   IF( PRESENT(KL) ) THEN; LKL = KL; ELSE; LKL = (LDA-1)/2; ENDIF
   LKU = LDA -LKL -1
   IF( PRESENT(RCOND) ) RCOND = 1.0_WP
   IF( PRESENT(RPVGRW) ) RPVGRW = 1.0_WP
   IF( PRESENT(FACT) )THEN; LFACT = FACT; ELSE; LFACT='N'; END IF
   IF( PRESENT(EQUED) .AND. LSAME(LFACT,'F') )THEN; LEQUED = EQUED
   ELSE; LEQUED='N'; END IF
   IF( PRESENT(IPIV) )THEN; SIPIV = SIZE(IPIV); ELSE; SIPIV = N; END IF
   IF( PRESENT(AF) )THEN; S1AF = SIZE(AF,1); S2AF = SIZE(AF,2)
   ELSE; S1AF = 2*LKL+LKU+1; S2AF = N; END IF
   IF( ( PRESENT(C) ) )THEN; SC = SIZE(C); ELSE; SC = N; END IF
   IF( ( PRESENT(C) .AND. LSAME(LFACT,'F') ) .AND. &
       ( LSAME(LEQUED,'C') .OR. LSAME(LEQUED,'B') ) )THEN; MVC = MINVAL(C)
   ELSE; MVC = TINY(1.0_WP); END IF
   IF( PRESENT(R) )THEN; SR = SIZE(R); ELSE; SR = N; END IF
   IF( ( PRESENT(R) .AND. LSAME(LFACT,'F') ) .AND. &
       ( LSAME(LEQUED,'R') .OR. LSAME(LEQUED,'B') ) )THEN; MVR = MINVAL(R)
   ELSE; MVR = TINY(1.0_WP); END IF
   IF(PRESENT(TRANS))THEN; LTRANS = TRANS; ELSE; LTRANS='N'; END IF
!  .. TEST THE ARGUMENTS
   IF( LDA - LKL -LKU -1 < 0 .OR. LDA < 0 .OR. N < 0 ) THEN; LINFO = -1
   ELSE IF( SIZE(B) /= N )THEN; LINFO = -2
   ELSE IF( SIZE(X) /= N )THEN; LINFO = -3
   ELSE IF( LKL < 0 .OR. LKU < 0 ) THEN; LINFO = -4
   ELSE IF( S1AF /= 2*LKL+LKU+1 .OR. S2AF /= N ) THEN; LINFO = -5
   ELSE IF( SIPIV /= N )THEN; LINFO = -6
   ELSE IF( SR /= N .OR. MVR <= 0.0_WP )THEN; LINFO = -10
   ELSE IF( SC /= N .OR. MVC <= 0.0_WP )THEN; LINFO = -11
   ELSE IF( ( .NOT. ( LSAME(LFACT,'F') .OR. LSAME(LFACT,'N') .OR. &
                    LSAME(LFACT,'E') ) ) .OR. &
       ( LSAME(LFACT,'F') .AND. .NOT.( PRESENT(AF) .AND. PRESENT(IPIV) ) ) )THEN
      LINFO = -7
   ELSE IF( .NOT.( LSAME(LTRANS,'N') .OR.  LSAME(LTRANS,'T') .OR. &
                  LSAME(LTRANS,'C') ) )THEN; LINFO = -8
   ELSE IF( ( .NOT.( LSAME(LEQUED,'N') .OR. LSAME(LEQUED,'R') .OR. &
          LSAME(LEQUED,'C') .OR. LSAME(LEQUED,'B') ) &
              .AND. LSAME(LFACT,'F') ) .OR. &
         ( ( LSAME(LEQUED,'R') .OR. LSAME(LEQUED,'B') ) .AND. &
              .NOT.PRESENT(R) ) .OR. &
         ( ( LSAME(LEQUED,'C') .OR. LSAME(LEQUED,'B') ) .AND. &
              .NOT.PRESENT(C) ) )THEN; LINFO = -9
   ELSE IF ( N > 0 )THEN
      IF( .NOT.PRESENT(AF) ) THEN; ALLOCATE( LAF(S1AF,N), STAT=ISTAT )
      ELSE; LAF => AF; END IF
      IF( ISTAT == 0 )THEN
         IF( .NOT.PRESENT(IPIV) )THEN; ALLOCATE( LPIV(N), STAT=ISTAT )
         ELSE; LPIV => IPIV; END IF
      END IF
      IF( ISTAT == 0 )THEN
         IF( .NOT.PRESENT(R) )THEN; ALLOCATE( LR(N), STAT=ISTAT )
         ELSE; LR => R; END IF
      END IF
      IF( ISTAT == 0 )THEN
         IF( .NOT.PRESENT(C) )THEN; ALLOCATE( LC(N), STAT=ISTAT )
         ELSE; LC => C; END IF
      END IF
      IF( ISTAT == 0 ) ALLOCATE(WORK(2*N), RWORK(N), STAT=ISTAT )
      IF( ISTAT == 0 )THEN
         CALL GBSVX_F77( LFACT, LTRANS, N, LKL, LKU, 1, A, LDA, LAF, S1AF, &
                         LPIV, LEQUED, LR, LC, B, LD, X, LD, LRCOND, &
                         LFERR, LBERR, WORK, RWORK, LINFO )
      ELSE; LINFO = -100; END IF
      IF( .NOT.PRESENT(R) ) DEALLOCATE( LR, STAT=ISTAT1 )
      IF( .NOT.PRESENT(C) ) DEALLOCATE( LC, STAT=ISTAT1 )
      IF( .NOT.PRESENT(AF) ) DEALLOCATE( LAF, STAT=ISTAT1 )
      IF( .NOT.PRESENT(IPIV) ) DEALLOCATE( LPIV, STAT=ISTAT1 )
      IF( PRESENT(FERR) ) FERR = LFERR
      IF( PRESENT(BERR) ) BERR = LBERR
      IF( PRESENT(RCOND) ) RCOND=LRCOND
      IF( PRESENT(EQUED) .AND. .NOT.LSAME(LFACT,'F') ) EQUED=LEQUED
      IF( PRESENT(RPVGRW) ) RPVGRW=RWORK(1)
      DEALLOCATE( WORK, RWORK, STAT=ISTAT1 )
   END IF
   CALL ERINFO( LINFO, SRNAME, INFO, ISTAT )
END SUBROUTINE ZGBSVX1_F95
